/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorWithSourceBasesBase;
import org.jboss.elasticsearch.tools.content.ValueUtils;

public class RemoveMultipleFieldsPreprocessor
extends StructuredContentPreprocessorWithSourceBasesBase<Object> {
    protected static final String CFG_FIELDS = "fields";
    protected List<String> fields;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        String s;
        super.init(settings);
        Object o = settings.get(CFG_FIELDS);
        if (o instanceof List) {
            this.fields = (List)o;
        } else if (o instanceof String && (s = ValueUtils.trimToNull((String)o)) != null) {
            this.fields = new ArrayList<String>();
            this.fields.add(s);
        }
        if (this.fields == null || this.fields.isEmpty()) {
            throw new SettingsException("Missing, empty or bad 'settings/fields' configuration value for '" + this.name + "' preprocessor");
        }
    }

    @Override
    protected void processOneSourceValue(Map<String, Object> data, Object context, String base, PreprocessChainContext chainContext) {
        for (String key : this.fields) {
            StructureUtils.removeValueFromMapOfMaps(data, key);
        }
    }

    @Override
    protected Object createContext() {
        return null;
    }

    public List<String> getFields() {
        return this.fields;
    }
}

