/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;

public class PreprocessChainContextImpl
implements PreprocessChainContext {
    protected List<DataWarning> warnings = new ArrayList<DataWarning>();

    @Override
    public void addDataWarning(String preprocessorName, String warningMessage) {
        if (preprocessorName == null || warningMessage == null) {
            throw new IllegalArgumentException("preprocessorName nor warningMessage can be null");
        }
        this.warnings.add(new DataWarning(preprocessorName, warningMessage));
    }

    public List<DataWarning> getWarnings() {
        return this.warnings;
    }

    public boolean isWarning() {
        return !this.warnings.isEmpty();
    }

    public String toString() {
        return "PreprocessChainContextImpl [warnings=" + this.warnings + "]";
    }

    public static final class DataWarning
    implements Serializable {
        private String preprocessorName;
        private String warningMessage;

        public DataWarning(String preprocessorName, String warningMessage) {
            this.preprocessorName = preprocessorName;
            this.warningMessage = warningMessage;
        }

        public String getPreprocessorName() {
            return this.preprocessorName;
        }

        public String getWarningMessage() {
            return this.warningMessage;
        }

        public String toString() {
            return "DataWarning [preprocessorName=" + this.preprocessorName + ", warningMessage=" + this.warningMessage + "]";
        }
    }
}

