/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.elasticsearch.tools.content;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.jboss.elasticsearch.tools.content.PreprocessChainContext;
import org.jboss.elasticsearch.tools.content.StructureUtils;
import org.jboss.elasticsearch.tools.content.StructuredContentPreprocessorWithSourceBasesBase;

public class IsDateInRangePreprocessor
extends StructuredContentPreprocessorWithSourceBasesBase<Map<String, Object>> {
    protected static final String CFG_LEFT_DATE = "left_date";
    protected static final String CFG_RIGHT_DATE = "right_date";
    protected static final String CFG_CHECKED_DATE = "checked_date";
    protected static final String CFG_LEFT_DATE_FORMAT = "left_date_format";
    protected static final String CFG_RIGHT_DATE_FORMAT = "right_date_format";
    protected static final String CFG_CHECKED_DATE_FORMAT = "checked_date_format";
    protected static final String CFG_RESULT_FIELD = "result_field";
    protected static final String CFG_DEFAULT_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSXX";
    protected SimpleDateFormat dateFormatter = new SimpleDateFormat();
    protected String leftDateField;
    protected String rightDateField;
    protected String checkedDateField;
    protected String resultField;
    protected String leftDateFormat;
    protected String rightDateFormat;
    protected String checkedDateFormat;

    @Override
    public void init(Map<String, Object> settings) throws SettingsException {
        super.init(settings);
        this.leftDateField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_LEFT_DATE), null);
        this.leftDateField = this.leftDateField != null && this.leftDateField.isEmpty() ? null : this.leftDateField;
        this.leftDateFormat = XContentMapValues.nodeStringValue((Object)settings.get(CFG_LEFT_DATE_FORMAT), (String)CFG_DEFAULT_DATE_FORMAT);
        this.rightDateField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_RIGHT_DATE), null);
        this.rightDateField = this.rightDateField != null && this.rightDateField.isEmpty() ? null : this.rightDateField;
        this.rightDateFormat = XContentMapValues.nodeStringValue((Object)settings.get(CFG_RIGHT_DATE_FORMAT), (String)CFG_DEFAULT_DATE_FORMAT);
        this.checkedDateField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_CHECKED_DATE), null);
        this.validateConfigurationObjectNotEmpty(this.checkedDateField, CFG_CHECKED_DATE);
        this.checkedDateFormat = XContentMapValues.nodeStringValue((Object)settings.get(CFG_CHECKED_DATE_FORMAT), (String)CFG_DEFAULT_DATE_FORMAT);
        this.resultField = XContentMapValues.nodeStringValue((Object)settings.get(CFG_RESULT_FIELD), null);
        this.validateConfigurationStringNotEmpty(this.resultField, CFG_RESULT_FIELD);
        if (this.leftDateField == null && this.rightDateField == null) {
            throw new SettingsException("At least one of dates defining range, settings/left_date or settings/right_date need to be provided.");
        }
    }

    @Override
    protected Map<String, Object> createContext(Map<String, Object> data) {
        return data;
    }

    @Override
    protected void processOneSourceValue(Map<String, Object> data, Map<String, Object> context, String base, PreprocessChainContext chainContext) {
        if (data == null) {
            return;
        }
        Boolean result = null;
        Date leftDate = null;
        Date rightDate = null;
        Date checkedDate = null;
        try {
            leftDate = this.handleDateExtractionAndParsing(this.leftDateField, this.leftDateFormat, data, base, chainContext);
            rightDate = this.handleDateExtractionAndParsing(this.rightDateField, this.rightDateFormat, data, base, chainContext);
            checkedDate = this.handleDateExtractionAndParsing(this.checkedDateField, this.checkedDateFormat, base != null ? context : data, null, chainContext);
        }
        catch (DataProblemException e) {
            return;
        }
        if (leftDate != null && rightDate != null && leftDate.after(rightDate)) {
            Date tmpDate = leftDate;
            leftDate = rightDate;
            rightDate = tmpDate;
        }
        result = leftDate != null && rightDate != null ? Boolean.valueOf(checkedDate.compareTo(leftDate) >= 0 && checkedDate.compareTo(rightDate) <= 0) : (leftDate != null ? Boolean.valueOf(checkedDate.compareTo(leftDate) >= 0) : (rightDate != null ? Boolean.valueOf(checkedDate.compareTo(rightDate) <= 0) : Boolean.valueOf(false)));
        StructureUtils.putValueIntoMapOfMaps(data, this.resultField, result);
    }

    @Override
    public List<String> getSourceBases() {
        return this.sourceBases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Date handleDateExtractionAndParsing(String dateField, String dateFormat, Map<String, Object> data, String base, PreprocessChainContext chainContext) throws DataProblemException {
        if (dateField == null) {
            return null;
        }
        Date resultDate = null;
        Object dateFieldData = null;
        dateFieldData = dateField.contains(".") ? XContentMapValues.extractValue((String)dateField, data) : data.get(dateField);
        if (dateFieldData != null) {
            if (!(dateFieldData instanceof String)) {
                String msg = "Value for field '" + dateField + "' is not a String, so can't be parsed to the date object.";
                this.addDataWarning(chainContext, msg);
                throw new DataProblemException();
            }
            String dateStr = dateFieldData.toString();
            if (dateStr != null && !dateStr.isEmpty()) {
                SimpleDateFormat simpleDateFormat = this.dateFormatter;
                synchronized (simpleDateFormat) {
                    this.dateFormatter.applyPattern(dateFormat);
                    try {
                        resultDate = this.dateFormatter.parse(dateStr);
                    }
                    catch (ParseException e) {
                        String msg = dateField + " parameter value of " + dateStr + " could not be parsed using " + dateFormat + " format.";
                        this.addDataWarning(chainContext, msg);
                        throw new DataProblemException();
                    }
                }
            }
        }
        return resultDate;
    }

    @Override
    protected void addDataWarning(PreprocessChainContext chainContext, String message) {
        super.addDataWarning(chainContext, message);
        this.logger.debug(message, new Object[0]);
    }

    class DataProblemException
    extends Exception {
        private static final long serialVersionUID = 1L;

        DataProblemException() {
        }
    }
}

