/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hal.standalone;

import io.undertow.Undertow;
import io.undertow.predicate.Predicates;
import io.undertow.server.handlers.resource.ClassPathResourceManager;
import io.undertow.server.handlers.resource.ResourceHandler;
import java.util.logging.Logger;

public class Main {
    public static void main(String[] args) {
        int port = 9090;
        if (args != null && args.length > 0) {
            try {
                port = Integer.parseInt(args[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        ClassPathResourceManager resource = new ClassPathResourceManager(Main.class.getClassLoader(), "hal");
        ResourceHandler handler = new ResourceHandler(resource).setResourceManager(resource).setDirectoryListingEnabled(false).setCachable(Predicates.not(Predicates.suffixes(".nocache.js", "index.html")));
        Undertow server = Undertow.builder().addHttpListener(port, "0.0.0.0").setHandler(handler).build();
        server.start();
        Logger.getLogger("HAL").info("HAL listening on port " + port);
    }

    private Main() {
    }
}

