/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api;

import java.util.HashMap;
import java.util.Map;
import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.UnsupportedCriterium;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySearchCriteriaImpl
implements IdentitySearchCriteria,
IdentityObjectSearchCriteria {
    private boolean sorted = false;
    private String sortByName;
    private boolean ascending = true;
    private boolean paged = false;
    private int firstResult;
    private int maxResults;
    private boolean filtered = false;
    private final Map<String, String[]> attributes = new HashMap<String, String[]>();
    private String filter;

    public IdentitySearchCriteria sort(SortOrder order) throws UnsupportedCriterium {
        this.sorted = true;
        this.ascending = order.equals((Object)SortOrder.ASCENDING);
        return this;
    }

    public IdentitySearchCriteria sortAttributeName(String name) throws UnsupportedCriterium {
        this.sorted = true;
        this.sortByName = name;
        return this;
    }

    public IdentitySearchCriteria page(int firstResult, int maxResults) throws UnsupportedCriterium {
        this.paged = true;
        this.firstResult = firstResult;
        this.maxResults = maxResults;
        return this;
    }

    public IdentitySearchCriteria attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedCriterium {
        if (attributeName == null) {
            throw new IllegalArgumentException("Attribute name is null");
        }
        if (attributeValue == null) {
            throw new IllegalArgumentException("Attribute values are null");
        }
        this.filtered = true;
        this.attributes.put(attributeName, attributeValue);
        return this;
    }

    public IdentitySearchCriteria idFilter(String filter) throws UnsupportedCriterium {
        if (filter == null) {
            throw new IllegalArgumentException("ID filter is null");
        }
        this.filter = filter;
        return this;
    }

    public String getFilter() {
        return this.filter;
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public String getSortAttributeName() {
        return this.sortByName;
    }

    public boolean isPaged() {
        return this.paged;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public boolean isFiltered() {
        return this.filtered;
    }

    public Map<String, String[]> getValues() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IdentitySearchCriteriaImpl that = (IdentitySearchCriteriaImpl)o;
        if (this.ascending != that.ascending) {
            return false;
        }
        if (this.filtered != that.filtered) {
            return false;
        }
        if (this.firstResult != that.firstResult) {
            return false;
        }
        if (this.maxResults != that.maxResults) {
            return false;
        }
        if (this.paged != that.paged) {
            return false;
        }
        if (this.sorted != that.sorted) {
            return false;
        }
        if (!((Object)this.attributes).equals(that.attributes)) {
            return false;
        }
        if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
            return false;
        }
        return !(this.sortByName != null ? !this.sortByName.equals(that.sortByName) : that.sortByName != null);
    }

    public int hashCode() {
        int result = this.sorted ? 1 : 0;
        result = 31 * result + (this.sortByName != null ? this.sortByName.hashCode() : 0);
        result = 31 * result + (this.ascending ? 1 : 0);
        result = 31 * result + (this.paged ? 1 : 0);
        result = 31 * result + this.firstResult;
        result = 31 * result + this.maxResults;
        result = 31 * result + (this.filtered ? 1 : 0);
        result = 31 * result + ((Object)this.attributes).hashCode();
        result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
        return result;
    }
}

