/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jboss.identity.idm.impl.api.AbstractCredential;
import org.jboss.identity.idm.impl.api.SimpleCredentialType;

public class PasswordCredential
extends AbstractCredential {
    private final String value;
    public static final SimpleCredentialType TYPE = new SimpleCredentialType("PASSWORD");

    public PasswordCredential(String value) {
        super(TYPE);
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public Object getEncodedValue() {
        if (this.value != null) {
            return PasswordCredential.md5AsHexString(this.getValue());
        }
        return null;
    }

    public static byte[] md5(String text) {
        if (text == null) {
            throw new NullPointerException("null text");
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(text.getBytes());
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Cannot find MD5 algorithm");
        }
    }

    public static String md5AsHexString(String text) {
        return PasswordCredential.toHexString(PasswordCredential.md5(text));
    }

    public static String toHexString(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("byte array must not be null");
        }
        StringBuffer hex = new StringBuffer(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            hex.append(Character.forDigit((bytes[i] & 0xF0) >> 4, 16));
            hex.append(Character.forDigit(bytes[i] & 0xF, 16));
        }
        return hex.toString();
    }
}

