/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.query;

import java.util.Collection;
import java.util.List;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.api.query.RoleQuery;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.impl.NotYetImplementedException;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.model.SimpleGroup;
import org.jboss.identity.idm.impl.api.model.SimpleRoleType;
import org.jboss.identity.idm.impl.api.model.SimpleUser;
import org.jboss.identity.idm.impl.api.query.AbstractQuery;
import org.jboss.identity.idm.impl.api.session.IdentitySessionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleQueryImpl
extends AbstractQuery
implements RoleQuery {
    private User user;
    private Group group;
    private RoleType roleType;

    public RoleQueryImpl(IdentitySessionImpl identitySession) {
        super(identitySession);
    }

    public Collection<Role> execute() throws QueryException {
        throw new NotYetImplementedException();
    }

    public Role uniqueResult() throws QueryException {
        throw new NotYetImplementedException();
    }

    public List<Role> list() throws QueryException {
        throw new NotYetImplementedException();
    }

    public RoleQuery setUser(User user) {
        this.checkNotNullArgument(user, "User");
        this.user = user;
        return this;
    }

    public RoleQuery setUser(String id) {
        this.checkNotNullArgument(id, "User id");
        this.user = new SimpleUser(id);
        return this;
    }

    public RoleQuery setGroup(Group group) {
        this.checkNotNullArgument(group, "Group");
        this.group = group;
        return this;
    }

    public RoleQuery setGroup(String id) {
        this.checkNotNullArgument(id, "Group id");
        this.group = new SimpleGroup(new GroupId(id));
        return this;
    }

    public RoleQuery setRoleType(RoleType roleType) {
        this.checkNotNullArgument(roleType, "RoleType");
        this.roleType = roleType;
        return this;
    }

    public RoleQuery setRoleType(String roleTypeName) {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.roleType = new SimpleRoleType(roleTypeName);
        return this;
    }

    public RoleQuery setIdentityType(IdentityType identityType) {
        this.checkNotNullArgument(identityType, "IdentityType");
        if (identityType instanceof User) {
            this.user = (User)identityType;
        } else {
            this.group = (Group)identityType;
        }
        return this;
    }

    public RoleQuery setIdentityTypeId(String id) {
        this.checkNotNullArgument(id, "IdentityType id");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.setIdentityType(identityType);
    }

    public RoleQuery sort(SortOrder order) throws UnsupportedQueryCriterium {
        return (RoleQuery)super.sort(order);
    }

    public RoleQuery sortAttributeName(String name) throws UnsupportedQueryCriterium {
        return (RoleQuery)super.sortAttributeName(name);
    }

    public RoleQuery page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        return (RoleQuery)super.page(firstResult, maxResults);
    }

    public RoleQuery attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        return (RoleQuery)super.attributeValuesFilter(attributeName, attributeValue);
    }
}

