/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jboss.identity.idm.api.Attribute;
import org.jboss.identity.idm.api.AttributeDescription;
import org.jboss.identity.idm.api.AttributesManager;
import org.jboss.identity.idm.api.Credential;
import org.jboss.identity.idm.api.CredentialType;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.PasswordCredential;
import org.jboss.identity.idm.impl.api.SimpleAttribute;
import org.jboss.identity.idm.impl.api.SimpleCredentialType;
import org.jboss.identity.idm.impl.api.attribute.IdentityObjectAttributeMetaDataImpl;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;
import org.jboss.identity.idm.spi.model.IdentityObjectCredentialType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesManagerImpl
extends AbstractManager
implements AttributesManager {
    public AttributesManagerImpl(IdentitySession session) {
        super(session);
    }

    public AttributeDescription getAttributeDescription(IdentityType identityType, String name) {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(name, "Attribute name");
        Map mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        if (mdMap != null && mdMap.containsKey(name)) {
            IdentityObjectAttributeMetaData attributeMD = (IdentityObjectAttributeMetaData)mdMap.get(name);
            if (attributeMD instanceof AttributeDescription) {
                return (AttributeDescription)attributeMD;
            }
            return new IdentityObjectAttributeMetaDataImpl(attributeMD);
        }
        return null;
    }

    public AttributeDescription getAttributeDescription(String id, String attributeName) {
        this.checkNotNullArgument(id, "IdentityType Id");
        this.checkNotNullArgument(attributeName, "Attribute name");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttributeDescription(identityType, attributeName);
    }

    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(IdentityType identityType) {
        this.checkNotNullArgument(identityType, "IdentityType");
        Map mdMap = this.getRepository().getAttributesMetaData(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
        HashMap<String, AttributeDescription> descriptionMap = new HashMap<String, AttributeDescription>();
        if (mdMap != null) {
            for (IdentityObjectAttributeMetaData attributeMD : mdMap.values()) {
                if (attributeMD instanceof AttributeDescription) {
                    descriptionMap.put(attributeMD.getName(), (AttributeDescription)attributeMD);
                    continue;
                }
                descriptionMap.put(attributeMD.getName(), new IdentityObjectAttributeMetaDataImpl(attributeMD));
            }
        }
        return descriptionMap;
    }

    public Map<String, AttributeDescription> getSupportedAttributesDescriptions(String id) {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getSupportedAttributesDescriptions(identityType);
    }

    public Set<String> getSupportedAttributeNames(IdentityType identityType) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        return this.getRepository().getSupportedAttributeNames(this.getInvocationContext(), this.createIdentityObject(identityType).getIdentityType());
    }

    public Set<String> getSupportedAttributeNames(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getSupportedAttributeNames(identityType);
    }

    public Map<String, Attribute> getAttributes(IdentityType identity) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        Map map = this.getRepository().getAttributes(this.getInvocationContext(), this.createIdentityObject(identity));
        HashMap<String, Attribute> newMap = new HashMap<String, Attribute>();
        for (Map.Entry entry : map.entrySet()) {
            newMap.put((String)entry.getKey(), this.convertAttribute((IdentityObjectAttribute)entry.getValue()));
        }
        return newMap;
    }

    public Map<String, Attribute> getAttributes(String id) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttributes(identityType);
    }

    public void updateAttributes(IdentityType identity, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributes, "Attributes");
        this.getRepository().updateAttributes(this.getInvocationContext(), this.createIdentityObject(identity), this.convertAttributes(attributes));
    }

    public void updateAttributes(String id, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributes, "Attributes");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.updateAttributes(identityType, attributes);
    }

    public Attribute getAttribute(IdentityType identity, String attributeName) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        return this.getAttributes(identity).get(attributeName);
    }

    public Attribute getAttribute(String id, String attributeName) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        return this.getAttribute(identityType, attributeName);
    }

    public void addAttribute(IdentityType identity, String attributeName, Object[] values) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(values, "Attribute values");
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, values)};
        this.addAttributes(identity, attrs);
    }

    public void addAttributes(String id, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributes, "Attributes");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttributes(identityType, attributes);
    }

    public void addAttribute(IdentityType identity, String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        Attribute[] attrs = new Attribute[]{new SimpleAttribute(attributeName, value)};
        this.addAttributes(identity, attrs);
    }

    public void addAttribute(String id, String attributeName, Object[] values) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(values, "Attribute values");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttribute(identityType, attributeName, values);
    }

    public void addAttribute(String id, String attributeName, Object value) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeName, "Attribute name");
        this.checkNotNullArgument(value, "Attribute value");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.addAttribute(identityType, attributeName, value);
    }

    public void addAttributes(IdentityType identity, Attribute[] attributes) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributes, "Attributes");
        this.getRepository().addAttributes(this.getInvocationContext(), this.createIdentityObject(identity), this.convertAttributes(attributes));
    }

    public void removeAttributes(IdentityType identity, String[] attributeNames) throws IdentityException {
        this.checkNotNullArgument(identity, "IdentityType");
        this.checkNotNullArgument(attributeNames, "Attribute names");
        this.getRepository().removeAttributes(this.getInvocationContext(), this.createIdentityObject(identity), attributeNames);
    }

    public void removeAttributes(String id, String[] attributeNames) throws IdentityException {
        this.checkNotNullArgument(id, "Id (Group) or name (User)");
        this.checkNotNullArgument(attributeNames, "Attribute names");
        IdentityType identityType = this.createIdentityTypeFromId(id);
        this.removeAttributes(identityType, attributeNames);
    }

    public boolean hasPassword(User identity) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.createIdentityObject(identity).getIdentityType(), (IdentityObjectCredentialType)PasswordCredential.TYPE);
    }

    public boolean validatePassword(User identity, String password) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(password, "Password");
        return this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(identity), (IdentityObjectCredential)new PasswordCredential(password));
    }

    public void updatePassword(User identity, String password) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(password, "Password");
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(identity), (IdentityObjectCredential)new PasswordCredential(password));
    }

    public boolean isCredentialTypeSupported(CredentialType credentialType) throws IdentityException {
        this.checkNotNullArgument(credentialType, "CredentialType");
        return this.getRepository().getSupportedFeatures().isCredentialSupported(this.getUserObjectType(), (IdentityObjectCredentialType)new SimpleCredentialType(credentialType.getName()));
    }

    public boolean validateCredentials(User identity, Credential[] credentials) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(credentials, "Credentials");
        for (Credential credential : credentials) {
            IdentityObjectCredential ioc = null;
            if (!(credential instanceof IdentityObjectCredential)) {
                throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
            }
            ioc = (IdentityObjectCredential)credential;
            if (this.getRepository().validateCredential(this.getInvocationContext(), this.createIdentityObject(identity), ioc)) continue;
            return false;
        }
        return true;
    }

    public void updateCredential(User identity, Credential credential) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(credential, "Credential");
        if (!(credential instanceof IdentityObjectCredential)) {
            throw new IdentityException("Unsupported Credential implementation: " + credential.getClass());
        }
        this.getRepository().updateCredential(this.getInvocationContext(), this.createIdentityObject(identity), (IdentityObjectCredential)credential);
    }
}

