/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session.managers;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySearchCriteria;
import org.jboss.identity.idm.api.IdentitySearchCriteriumType;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.api.RoleManager;
import org.jboss.identity.idm.api.RoleManagerFeaturesDescription;
import org.jboss.identity.idm.api.RoleType;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.api.model.SimpleRole;
import org.jboss.identity.idm.impl.api.model.SimpleRoleType;
import org.jboss.identity.idm.impl.api.session.managers.AbstractManager;
import org.jboss.identity.idm.impl.types.SimpleIdentityObjectRelationship;
import org.jboss.identity.idm.spi.exception.OperationNotSupportedException;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.store.IdentityObjectSearchCriteriaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleManagerImpl
extends AbstractManager
implements RoleManager {
    public static final IdentityObjectRelationshipType ROLE = new IdentityObjectRelationshipType(){

        public String getName() {
            return "JBOSS_IDENTITY_ROLE";
        }
    };
    private final RoleManagerFeaturesDescription featuresDescription = new RoleManagerFeaturesDescription(){

        public boolean isRoleTypeAddRemoveSupported() {
            return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRelationshipNameAddRemoveSupported();
        }

        public boolean isRoleTypeSearchCriteriumTypeSupported(IdentitySearchCriteriumType constraintType) {
            IdentityObjectSearchCriteriaType constraint = IdentityObjectSearchCriteriaType.valueOf((String)constraintType.name());
            if (constraint != null) {
                return RoleManagerImpl.this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint);
            }
            return false;
        }
    };

    public RoleManagerImpl(IdentitySession session) {
        super(session);
    }

    protected IdentityObjectRelationship createIdentityObjectRelationship(Role role) {
        return new SimpleIdentityObjectRelationship(this.createIdentityObject(role.getGroup()), this.createIdentityObject(role.getIdentity()), role.getRoleType().getName(), ROLE);
    }

    public RoleManagerFeaturesDescription getSupportedFeatures() {
        return this.featuresDescription;
    }

    public RoleType createRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        this.checkObjectName(name);
        String roleType = null;
        try {
            roleType = this.getRepository().createRelationshipName(this.getInvocationContext(), name);
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        return new SimpleRoleType(roleType);
    }

    public void removeRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        try {
            this.getRepository().removeRelationshipName(this.getInvocationContext(), name);
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public void removeRoleType(RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.removeRoleType(roleType.getName());
    }

    public RoleType getRoleType(String name) throws IdentityException {
        this.checkNotNullArgument(name, "RoleType name");
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), null);
            if (names.contains(name)) {
                return new SimpleRoleType(name);
            }
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
        return null;
    }

    public Collection<RoleType> findRoleTypes(IdentitySearchCriteria controls) throws IdentityException {
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.convertSearchControls(controls));
            HashSet<RoleType> types = new HashSet<RoleType>();
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public Role createRole(RoleType roleType, User identity, Group group) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        IdentityObjectRelationship rel = this.getRepository().createRelationship(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE, roleType.getName(), false);
        return new SimpleRole(new SimpleRoleType(rel.getName()), this.createUser(rel.getToIdentityObject()), this.createGroup(rel.getFromIdentityObject()));
    }

    public Role createRole(String roleTypeName, String userName, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.createRole(new SimpleRoleType(roleTypeName), user, group);
    }

    public void removeRole(RoleType roleType, User identity, Group group) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE, roleType.getName());
    }

    public void removeRole(String roleTypeName, String userName, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        this.removeRole(new SimpleRoleType(roleTypeName), user, group);
    }

    public void removeRole(Role role) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.getRepository().removeRelationship(this.getInvocationContext(), this.createIdentityObject(role.getGroup()), this.createIdentityObject(role.getIdentity()), ROLE, role.getRoleType().getName());
    }

    public boolean hasRole(User identity, Group group, RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        Set rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE);
        for (IdentityObjectRelationship rel : rels) {
            if (!rel.getType().getName().equals(ROLE.getName()) || rel.getName() == null || !rel.getName().equals(roleType.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String userName, String groupId, String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.hasRole(user, group, new SimpleRoleType(roleTypeName));
    }

    public Role getRole(RoleType roleType, User user, Group group) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(user, "User");
        this.checkNotNullArgument(group, "Group");
        Set rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(user), ROLE);
        if (rels.size() == 0) {
            throw new IdentityException("No such role present");
        }
        if (rels.size() > 1) {
            throw new IdentityException("More than one role definition present - illegal state!");
        }
        IdentityObjectRelationship relationship = (IdentityObjectRelationship)rels.iterator().next();
        return new SimpleRole(new SimpleRoleType(relationship.getType().getName()), this.createUser(relationship.getFromIdentityObject()), this.createGroup(relationship.getToIdentityObject()));
    }

    public Role getRole(String roleTypeName, String userId, String groupId) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(userId, "User id");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userId);
        Group group = this.createGroupFromId(groupId);
        SimpleRoleType roleType = new SimpleRoleType(roleTypeName);
        return this.getRole(roleType, user, group);
    }

    public Collection<RoleType> findRoleTypes(User identity, Group group) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        return this.findRoleTypes(identity, group, null);
    }

    public Collection<RoleType> findRoleTypes(User identity, Group group, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(group, "Group");
        Set rels = this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(group), this.createIdentityObject(identity), ROLE);
        HashSet<RoleType> types = new HashSet<RoleType>();
        for (IdentityObjectRelationship rel : rels) {
            types.add(new SimpleRoleType(rel.getName()));
        }
        return types;
    }

    public Collection<RoleType> findRoleTypes(String userName, String groupId, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupId, "Group Id");
        User user = this.createUserFromId(userName);
        Group group = this.createGroupFromId(groupId);
        return this.findRoleTypes(user, group, controls);
    }

    public Collection<RoleType> findUserRoleTypes(User identity) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        return this.findUserRoleTypes(identity, null);
    }

    public Collection<RoleType> findUserRoleTypes(User identity, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        HashSet<RoleType> types = new HashSet<RoleType>();
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(identity), this.convertSearchControls(controls));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported", (Throwable)e);
        }
    }

    public Collection<RoleType> findUserRoleTypes(String userName, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findUserRoleTypes(user, controls);
    }

    public Collection<RoleType> findGroupRoleTypes(Group group) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        return this.findGroupRoleTypes(group, null);
    }

    public Collection<RoleType> findGroupRoleTypes(String groupId, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(groupId, "Group Id");
        Group group = this.createGroupFromId(groupId);
        return this.findGroupRoleTypes(group, controls);
    }

    public Collection<RoleType> findGroupRoleTypes(Group group, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(group, "Group");
        HashSet<RoleType> types = new HashSet<RoleType>();
        try {
            Set names = this.getRepository().getRelationshipNames(this.getInvocationContext(), this.createIdentityObject(group), this.convertSearchControls(controls));
            for (String name : names) {
                types.add(new SimpleRoleType(name));
            }
            return types;
        }
        catch (OperationNotSupportedException e) {
            throw new IdentityException("Role management not supported");
        }
    }

    public Collection<Group> findGroupsWithRelatedRole(User identity, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        LinkedList<Group> identities = new LinkedList<Group>();
        Collection ios = null;
        ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(identity), ROLE, false, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findGroupsWithRelatedRole(String userName, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        User user = this.createUserFromId(userName);
        return this.findGroupsWithRelatedRole(user, controls);
    }

    public Collection<Group> findGroupsWithRelatedRole(User identity, String groupType, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(identity, "User");
        this.checkNotNullArgument(groupType, "Group type");
        LinkedList<Group> identities = new LinkedList<Group>();
        IdentityObjectType iot = this.getIdentityObjectType(groupType);
        Collection ios = null;
        ios = this.getRepository().findIdentityObject(this.getInvocationContext(), this.createIdentityObject(identity), ROLE, false, this.convertSearchControls(controls));
        for (IdentityObject io : ios) {
            if (!io.getIdentityType().getName().equals(iot.getName())) continue;
            identities.add(this.createGroup(io));
        }
        return identities;
    }

    public Collection<Group> findGroupsWithRelatedRole(String userName, String groupType, IdentitySearchCriteria controls) throws IdentityException {
        this.checkNotNullArgument(userName, "User name");
        this.checkNotNullArgument(groupType, "Group type");
        User user = this.createUserFromId(userName);
        return this.findGroupsWithRelatedRole(user, groupType, controls);
    }

    public Collection<Role> findRoles(IdentityType identityType, RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(identityType, "IdentityType");
        this.checkNotNullArgument(roleType, "RoleType");
        HashSet<Role> roles = new HashSet<Role>();
        Set relationships = null;
        relationships = identityType instanceof User ? this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, false, true, null) : this.getRepository().resolveRelationships(this.getInvocationContext(), this.createIdentityObject(identityType), ROLE, true, true, null);
        for (IdentityObjectRelationship relationship : relationships) {
            if (!roleType.getName().equals(relationship.getName())) continue;
            roles.add(new SimpleRole(new SimpleRoleType(relationship.getName()), this.createUser(relationship.getToIdentityObject()), this.createGroup(relationship.getFromIdentityObject())));
        }
        return roles;
    }

    public Collection<Role> findRoles(String id, String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(id, "Group id or User name");
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        return this.findRoles(this.createIdentityTypeFromId(id), new SimpleRoleType(roleTypeName));
    }

    public Map<String, String> getProperties(RoleType roleType) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType name");
        return this.getRepository().getRelationshipNameProperties(this.getInvocationContext(), roleType.getName());
    }

    public Map<String, String> getProperties(String roleTypeName) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        return this.getProperties(new SimpleRoleType(roleTypeName));
    }

    public Map<String, String> getProperties(Role role) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        return this.getRepository().getRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role));
    }

    public void setProperty(Role role, String name, String value) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.checkNotNullArgument(name, "Property name");
        this.checkNotNullArgument(value, "Property value");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(name, value);
        this.getRepository().setRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role), props);
    }

    public void setProperty(RoleType roleType, String name, String value) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(name, "Property name");
        this.checkNotNullArgument(value, "Property value");
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(name, value);
        this.getRepository().setRelationshipNameProperties(this.getInvocationContext(), roleType.getName(), props);
    }

    public void setProperty(String roleTypeName, String name, String value) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.checkNotNullArgument(name, "Property name");
        this.checkNotNullArgument(value, "Property value");
        this.setProperty(new SimpleRoleType(roleTypeName), name, value);
    }

    public void setProperties(Role role, Map<String, String> properties) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.checkNotNullArgument(properties, "Properties");
        this.getRepository().setRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role), properties);
    }

    public void setProperties(RoleType roleType, Map<String, String> properties) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(properties, "Properties");
        this.getRepository().setRelationshipNameProperties(this.getInvocationContext(), roleType.getName(), properties);
    }

    public void setProperties(String roleTypeName, Map<String, String> properties) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.setProperties(new SimpleRoleType(roleTypeName), properties);
    }

    public void removeProperty(Role role, String name) throws IdentityException {
        this.checkNotNullArgument(role, "Role");
        this.checkNotNullArgument(name, "Property name");
        HashSet<String> names = new HashSet<String>();
        names.add(name);
        this.getRepository().removeRelationshipProperties(this.getInvocationContext(), this.createIdentityObjectRelationship(role), names);
    }

    public void removeProperty(RoleType roleType, String name) throws IdentityException {
        this.checkNotNullArgument(roleType, "RoleType");
        this.checkNotNullArgument(name, "Property name");
        HashSet<String> names = new HashSet<String>();
        names.add(name);
        this.getRepository().removeRelationshipNameProperties(this.getInvocationContext(), roleType.getName(), names);
    }

    public void removeProperty(String roleTypeName, String name) throws IdentityException {
        this.checkNotNullArgument(roleTypeName, "RoleType name");
        this.removeProperty(new SimpleRoleType(roleTypeName), name);
    }
}

