/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.cache;

import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.cache.Cache;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.identity.idm.exception.IdentityException;
import org.jboss.identity.idm.impl.cache.IdentityStoreCacheSupport;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.store.AttributeStore;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheAttributeStoreWrapper
extends IdentityStoreCacheSupport
implements AttributeStore {
    private static Logger log = Logger.getLogger(JBossCacheAttributeStoreWrapper.class.getName());
    private final AttributeStore attributeStore;
    protected final Cache cache;
    private boolean reloadAttributesToCacheOnUpdate = true;

    public JBossCacheAttributeStoreWrapper(AttributeStore attributeStore, InputStream cacheConfigInputStream) {
        this.attributeStore = attributeStore;
        DefaultCacheFactory factory = new DefaultCacheFactory();
        this.cache = factory.createCache(cacheConfigInputStream);
        this.cache.start();
    }

    public String getId() {
        return this.attributeStore.getId();
    }

    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        return this.attributeStore.createIdentityStoreSession();
    }

    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        return this.attributeStore.getSupportedAttributeNames(invocationContext, identityType);
    }

    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.attributeStore.getAttributesMetaData(invocationContext, identityType);
    }

    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        Map results = this.getAttributesFromCache(identity.getName(), identity.getIdentityType());
        if (results == null && (results = this.attributeStore.getAttributes(invocationContext, identity)) != null && results.size() > 0) {
            this.putIntoCache(identity, results);
        }
        return results;
    }

    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        Map<String, IdentityObjectAttribute> results = this.getAttributesFromCache(identity.getName(), identity.getIdentityType());
        if (results != null && results.containsKey(name)) {
            return results.get(name);
        }
        return this.attributeStore.getAttribute(invocationContext, identity, name);
    }

    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        Map results;
        this.attributeStore.updateAttributes(invocationCtx, identity, attributes);
        this.removeAttributesFromCache(identity);
        if (this.reloadAttributesToCacheOnUpdate && (results = this.attributeStore.getAttributes(invocationCtx, identity)) != null && results.size() > 0) {
            this.putIntoCache(identity, results);
        }
    }

    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        Map results;
        this.attributeStore.addAttributes(invocationCtx, identity, attributes);
        this.removeAttributesFromCache(identity);
        if (this.reloadAttributesToCacheOnUpdate && (results = this.attributeStore.getAttributes(invocationCtx, identity)) != null && results.size() > 0) {
            this.putIntoCache(identity, results);
        }
    }

    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributeNames) throws IdentityException {
        Map results;
        this.attributeStore.removeAttributes(invocationCtx, identity, attributeNames);
        this.removeAttributesFromCache(identity);
        if (this.reloadAttributesToCacheOnUpdate && (results = this.attributeStore.getAttributes(invocationCtx, identity)) != null && results.size() > 0) {
            this.putIntoCache(identity, results);
        }
    }

    @Override
    protected Logger getLog() {
        return log;
    }

    @Override
    protected Cache getCache() {
        return this.cache;
    }

    public String toString() {
        return "JBossCacheAttributeStoreWrapper (AttributeStore=" + this.attributeStore.getId() + ")";
    }
}

