/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.integration.jboss5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jboss.aop.microcontainer.aspects.jmx.JMX;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.impl.configuration.IdentityConfigurationImpl;
import org.jboss.identity.idm.integration.jboss5.IDMServiceMBean;

@JMX(exposedInterface=IDMServiceMBean.class, name="jboss.identity:service=IDMService")
public class IDMService
implements IDMServiceMBean {
    public static final String DEFAULT_JNDI = "java:/IdentitySessionFactory";
    private static Logger logger = Logger.getLogger(IDMService.class.getName());
    private String idmConfigFile;
    private String idmSessionFactoryJNDI;
    private String SQLScript;
    private IdentitySessionFactory sessionFactory;
    private String exitSQL;
    private String datasource;

    public IDMService(String idmConfigFile) {
        this.idmConfigFile = idmConfigFile;
        this.idmSessionFactoryJNDI = DEFAULT_JNDI;
    }

    public String getIdmConfigFile() {
        return this.idmConfigFile;
    }

    public String getIdmSessionFactoryJNDI() {
        return this.idmSessionFactoryJNDI;
    }

    public String getSQLScript() {
        return this.SQLScript;
    }

    public void setIdmSessionFactoryJNDI(String idmSessionFactoryJNDI) {
        this.idmSessionFactoryJNDI = idmSessionFactoryJNDI;
    }

    public void setSQLScript(String script) {
        this.SQLScript = script;
    }

    public void start() throws Exception {
        logger.info("Starting the JBoss Identity Management Service");
        if (this.needToInitializeDB()) {
            this.initializeDB();
        }
        this.sessionFactory = new IdentityConfigurationImpl().configure(this.getIdmConfigFile()).buildIdentitySessionFactory();
        InitialContext context = new InitialContext();
        context.bind(this.getIdmSessionFactoryJNDI(), (Object)this.sessionFactory);
        logger.info("Started the JBoss Identity Management Service");
    }

    public void stop() throws Exception {
        logger.info("Stopping the JBoss Identity Management Service");
    }

    public void destroy() throws Exception {
        this.sessionFactory.close();
        InitialContext context = new InitialContext();
        context.unbind(this.getIdmSessionFactoryJNDI());
        logger.info("Stopped the JBoss Identity Management Service");
    }

    public String getExitSQL() {
        return this.exitSQL;
    }

    public void setExitSQL(String exitSQL) {
        this.exitSQL = exitSQL;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    private boolean needToInitializeDB() {
        return this.getDatasource() != null && this.getSQLScript() != null && this.getExitSQL() != null;
    }

    private void initializeDB() throws Exception {
        String[] list;
        DataSource ds = (DataSource)new InitialContext().lookup(this.datasource);
        Connection conn = ds.getConnection();
        boolean load = false;
        Statement st = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(this.exitSQL.trim());
            rs.close();
        }
        catch (SQLException e) {
            load = true;
        }
        st.close();
        if (!load) {
            logger.info(this.datasource + " datasource is already initialized");
            return;
        }
        logger.info("Initializing " + this.datasource + " from listed sql files");
        for (String sql : list = this.SQLScript.split(",")) {
            this.executeSql(sql.trim(), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String resource, Connection conn) throws Exception {
        String[] statements;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        String sql = new String(this.readStream(url.openStream()), "UTF-8");
        sql = sql.replaceAll("(?m)^--([^\n]+)?$", "");
        for (String statement : statements = sql.split(";")) {
            if (statement == null || "".equals(statement.trim())) continue;
            Statement sqlStatement = conn.createStatement();
            try {
                sqlStatement.executeUpdate(statement);
            }
            finally {
                sqlStatement.close();
            }
        }
    }

    private byte[] readStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg passed in method call.");
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int readCount = 0;
        try {
            while ((readCount = stream.read(buffer)) != -1) {
                outBuffer.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading stream.", e);
        }
        return outBuffer.toByteArray();
    }
}

