/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;

import org.jboss.identity.federation.bindings.config.IDPType;
import org.jboss.identity.federation.bindings.config.SPType;
import org.jboss.identity.federation.core.constants.JBossIdentityFederationConstants;
import org.jboss.identity.federation.core.saml.v2.factories.JBossSAMLBaseFactory;

/**
 * Util for tomcat valves
 * @author Anil.Saldhana@redhat.com
 * @since Jan 22, 2009
 */
public class ValveUtil
{ 
   /**
    * Seek the input stream to the KeyStore
    * @param keyStore
    * @return
    */
   public static InputStream getKeyStoreInputStream(String keyStore)
   {
      InputStream is = null;
      
      try
      {
         //Try the file method
         File file = new File(keyStore); 
         is = new FileInputStream(file);
      }
      catch(Exception e)
      {
         try
         {
            URL url = new URL(keyStore);
            is = url.openStream(); 
         } 
         catch(Exception ex)
         {
            is = SecurityActions.getContextClassLoader().getResourceAsStream(keyStore); 
         }
      }
      if(is == null)
         throw new RuntimeException("Keystore not located");
      return is;
   } 
   
   @SuppressWarnings("unchecked")
   public static IDPType getIDPConfiguration(InputStream is) throws Exception
   {
      if(is == null)
         throw new IllegalArgumentException("inputstream is null");
      String schema = "schema/config/jboss-identity-fed.xsd";
      
      String key = JBossIdentityFederationConstants.JAXB_SCHEMA_VALIDATION;
      boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
      
      String pkgName = "org.jboss.identity.federation.bindings.config";
      Unmarshaller un = null;
      if(validate)
         un = JBossSAMLBaseFactory.getValidatingUnmarshaller(pkgName, schema);
      else
         un = JBossSAMLBaseFactory.getUnmarshaller(pkgName);
      
      JAXBElement<IDPType> jaxbSp =  (JAXBElement<IDPType>) un.unmarshal(is);
      return jaxbSp.getValue(); 
   }
   
   @SuppressWarnings("unchecked")
   public static SPType getSPConfiguration(InputStream is) throws Exception
   {
      if(is == null)
         throw new IllegalArgumentException("inputstream is null");
      String schema = "schema/config/jboss-identity-fed.xsd";
      
      String key = JBossIdentityFederationConstants.JAXB_SCHEMA_VALIDATION;
      boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
      
      String pkgName = "org.jboss.identity.federation.bindings.config";
      Unmarshaller un = null;
      if(validate)
         un = JBossSAMLBaseFactory.getValidatingUnmarshaller(pkgName, schema);
      else
         un = JBossSAMLBaseFactory.getUnmarshaller(pkgName);
      
      JAXBElement<SPType> jaxbSp =  (JAXBElement<SPType>) un.unmarshal(is);
      return jaxbSp.getValue(); 
   }
   
   /**
    * Given a SP or IDP issuer from the assertion, return the host
    * @param domainURL
    * @return
    * @throws Exception
    */
   public static String getDomain(String domainURL) throws Exception
   {
      URL url = new URL(domainURL);
      return url.getHost();
   }
}