/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.config.SPType;
import org.jboss.identity.federation.web.util.ConfigurationUtil;

/**
 * Base Class for Form Authenticators
 * @author Anil.Saldhana@redhat.com
 * @since Jun 9, 2009
 */
public class BaseFormAuthenticator extends FormAuthenticator
{
   private static Logger log = Logger.getLogger(BaseFormAuthenticator.class);
   private boolean trace = log.isTraceEnabled();
   
   protected SPType spConfiguration = null;
   
   protected String serviceURL = null;
   protected String identityURL = null;

   protected String configFile = "/WEB-INF/jboss-idfed.xml";
    
   public BaseFormAuthenticator()
   {
      super(); 
   }

   public String getConfigFile()
   {
      return configFile;
   }

   public void setConfigFile(String configFile)
   {
      this.configFile = configFile;
   }
   
   /**
    * Perform validation os the request object
    * @param request
    * @return
    * @throws IOException
    * @throws GeneralSecurityException
    */
   protected boolean validate(Request request) throws IOException, GeneralSecurityException
   {
      return request.getParameter("SAMLResponse") != null; 
   }
   
   @Override
   public void start() throws LifecycleException
   {
      super.start();
      
      InputStream is = context.getServletContext().getResourceAsStream(configFile);
      if(is == null)
         throw new RuntimeException(configFile + " missing");
      try
      {
         spConfiguration = ConfigurationUtil.getSPConfiguration(is);
         this.identityURL = spConfiguration.getIdentityURL();
         this.serviceURL = spConfiguration.getServiceURL();
         if(trace) log.trace("Identity Provider URL=" + this.identityURL); 
      }
      catch (Exception e)
      {
         throw new RuntimeException(e);
      }
   }  
}