/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2008, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors. 
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

/**
 * Util for tomcat valves
 * @author Anil.Saldhana@redhat.com
 * @since Jan 22, 2009
 */
public class ValveUtil
{ 
   /**
    * Seek the input stream to the KeyStore
    * @param keyStore
    * @return
    */
   public static InputStream getKeyStoreInputStream(String keyStore)
   {
      InputStream is = null;
      
      try
      {
         //Try the file method
         File file = new File(keyStore); 
         is = new FileInputStream(file);
      }
      catch(Exception e)
      {
         try
         {
            URL url = new URL(keyStore);
            is = url.openStream(); 
         } 
         catch(Exception ex)
         {
            is = SecurityActions.getContextClassLoader().getResourceAsStream(keyStore); 
         }
      }
      
      if(is == null)
      {
         //Try the user.home dir
         String userHome = SecurityActions.getSystemProperty("user.home", "") + "/jbid-keystore";
         File ksDir = new File(userHome);
         if(ksDir.exists())
         {
            try
            {
               is = new FileInputStream(new File(userHome + "/" + keyStore));
            }
            catch (FileNotFoundException e)
            {
               is = null;
            }
         }
      }
      if(is == null)
         throw new RuntimeException("Keystore not located:" + keyStore);
      return is;
   } 
   
   
   
   /**
    * Given a SP or IDP issuer from the assertion, return the host
    * @param domainURL
    * @return
    * @throws IOException  
    */
   public static String getDomain(String domainURL) throws IOException  
   {
      URL url = new URL(domainURL);
      return url.getHost();
   }
}