/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.jboss.wstrust;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.jboss.identity.federation.bindings.jboss.wstrust.SecurityActions;
import org.jboss.identity.federation.core.config.KeyProviderType;
import org.jboss.identity.federation.core.config.PropertyType;
import org.jboss.identity.federation.core.config.STSType;
import org.jboss.identity.federation.core.config.ServiceProviderType;
import org.jboss.identity.federation.core.config.ServiceProvidersType;
import org.jboss.identity.federation.core.config.TokenProviderType;
import org.jboss.identity.federation.core.config.TokenProvidersType;
import org.jboss.identity.federation.core.wstrust.STSConfiguration;
import org.jboss.identity.federation.core.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.core.wstrust.WSTrustRequestHandler;
import org.jboss.identity.federation.core.wstrust.WSTrustServiceFactory;
import org.jboss.identity.federation.web.interfaces.TrustKeyManager;

public class JBossSTSConfiguration
implements STSConfiguration {
    private final STSType delegate;
    private final Map<String, SecurityTokenProvider> tokenProviders = new HashMap<String, SecurityTokenProvider>();
    private final Map<String, ServiceProviderType> spMetadata = new HashMap<String, ServiceProviderType>();
    private TrustKeyManager trustManager;
    private WSTrustRequestHandler handler;

    public JBossSTSConfiguration() {
        this.delegate = new STSType();
        this.delegate.setRequestHandler("org.jboss.identity.federation.core.wstrust.StandardRequestHandler");
    }

    public JBossSTSConfiguration(STSType config) {
        KeyProviderType keyProviderType;
        ServiceProvidersType serviceProviders;
        TokenProvidersType providers;
        this.delegate = config;
        if (this.delegate.getRequestHandler() == null) {
            this.delegate.setRequestHandler("org.jboss.identity.federation.core.wstrust.StandardRequestHandler");
        }
        if ((providers = this.delegate.getTokenProviders()) != null) {
            WSTrustServiceFactory serviceFactory = WSTrustServiceFactory.getInstance();
            for (TokenProviderType provider : providers.getTokenProvider()) {
                SecurityTokenProvider tokenProvider = serviceFactory.createTokenProvider(provider.getProviderClass());
                HashMap<String, String> properties = new HashMap<String, String>();
                for (PropertyType propertyType : provider.getProperty()) {
                    properties.put(propertyType.getName(), propertyType.getValue());
                }
                tokenProvider.initialize(properties);
                this.tokenProviders.put(provider.getTokenType(), tokenProvider);
                String tokenElementAndNS = provider.getTokenElement() + "$" + provider.getTokenElementNS();
                this.tokenProviders.put(tokenElementAndNS, tokenProvider);
            }
        }
        if ((serviceProviders = this.delegate.getServiceProviders()) != null) {
            for (TokenProviderType provider : serviceProviders.getServiceProvider()) {
                this.spMetadata.put(provider.getEndpoint(), (ServiceProviderType)provider);
            }
        }
        if ((keyProviderType = config.getKeyProvider()) != null) {
            String keyManagerClassName = keyProviderType.getClassName();
            try {
                this.trustManager = (TrustKeyManager)SecurityActions.instantiateClass(keyManagerClassName);
                this.trustManager.setAuthProperties(keyProviderType.getAuth());
                this.trustManager.setValidatingAlias(keyProviderType.getValidatingAlias());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to construct the key manager:", e);
            }
        }
    }

    public String getSTSName() {
        return this.delegate.getSTSName();
    }

    public boolean encryptIssuedToken() {
        return this.delegate.isEncryptToken();
    }

    public boolean signIssuedToken() {
        return this.delegate.isSignToken();
    }

    public long getIssuedTokenTimeout() {
        return this.delegate.getTokenTimeout() * 1000;
    }

    public WSTrustRequestHandler getRequestHandler() {
        if (this.handler == null) {
            this.handler = WSTrustServiceFactory.getInstance().createRequestHandler(this.delegate.getRequestHandler(), (STSConfiguration)this);
        }
        return this.handler;
    }

    public SecurityTokenProvider getProviderForService(String serviceName) {
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return this.tokenProviders.get(provider.getTokenType());
        }
        return null;
    }

    public SecurityTokenProvider getProviderForTokenType(String tokenType) {
        return this.tokenProviders.get(tokenType);
    }

    public SecurityTokenProvider getProviderForTokenElementNS(String tokenLocalName, String tokenNamespace) {
        return this.tokenProviders.get(tokenLocalName + "$" + tokenNamespace);
    }

    public String getTokenTypeForService(String serviceName) {
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return provider.getTokenType();
        }
        return null;
    }

    public PublicKey getServiceProviderPublicKey(String serviceName) {
        PublicKey key = null;
        if (this.trustManager != null) {
            try {
                ServiceProviderType provider = this.spMetadata.get(serviceName);
                if (provider != null && provider.getTruststoreAlias() != null) {
                    key = this.trustManager.getPublicKey(provider.getTruststoreAlias());
                }
                if (key == null) {
                    key = this.trustManager.getValidatingKey(serviceName);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Error obtaining public key for service " + serviceName, e);
            }
        }
        return key;
    }

    public KeyPair getSTSKeyPair() {
        KeyPair keyPair = null;
        if (this.trustManager != null) {
            try {
                keyPair = this.trustManager.getSigningKeyPair();
            }
            catch (Exception e) {
                throw new RuntimeException("Error obtaining signing key pair:", e);
            }
        }
        return keyPair;
    }
}

