/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.util.KeyStoreUtil;
import org.jboss.identity.federation.bindings.tomcat.SecurityActions;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.bindings.util.cert.EncryptionKeyUtil;
import org.jboss.identity.federation.core.config.AuthPropertyType;
import org.jboss.identity.federation.core.config.KeyValueType;
import org.jboss.identity.federation.web.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.web.interfaces.TrustKeyManager;
import org.jboss.identity.federation.web.interfaces.TrustKeyProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyStoreKeyManager
implements TrustKeyManager {
    private final Map<String, SecretKey> keys = new HashMap<String, SecretKey>();
    private static Logger log = Logger.getLogger(KeyStoreKeyManager.class);
    private boolean trace = log.isTraceEnabled();
    private final HashMap<String, String> domainAliasMap = new HashMap();
    private final HashMap<String, String> authPropsMap = new HashMap();
    private KeyStore ks = null;
    private String keyStoreURL;
    private char[] signingKeyPass;
    private String signingAlias;
    private String keyStorePass;
    public static final String KEYSTORE_URL = "KeyStoreURL";
    public static final String KEYSTORE_PASS = "KeyStorePass";
    public static final String SIGNING_KEY_PASS = "SigningKeyPass";
    public static final String SIGNING_KEY_ALIAS = "SigningKeyAlias";

    public PrivateKey getSigningKey() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        try {
            if (this.ks == null) {
                this.setUpKeyStore();
            }
            if (this.ks == null) {
                throw new IllegalStateException("KeyStore is null");
            }
            return (PrivateKey)this.ks.getKey(this.signingAlias, this.signingKeyPass);
        }
        catch (KeyStoreException e) {
            throw new TrustKeyConfigurationException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (UnrecoverableKeyException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
    }

    public KeyPair getSigningKeyPair() throws TrustKeyConfigurationException, TrustKeyProcessingException {
        try {
            if (this.ks == null) {
                this.setUpKeyStore();
            }
            PrivateKey privateKey = this.getSigningKey();
            PublicKey publicKey = KeyStoreUtil.getPublicKey((KeyStore)this.ks, (String)this.signingAlias, (char[])this.signingKeyPass);
            return new KeyPair(publicKey, privateKey);
        }
        catch (KeyStoreException e) {
            throw new TrustKeyConfigurationException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
    }

    public Certificate getCertificate(String alias) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        try {
            if (this.ks == null) {
                this.setUpKeyStore();
            }
            if (this.ks == null) {
                throw new IllegalStateException("KeyStore is null");
            }
            if (alias == null || alias.length() == 0) {
                throw new IllegalArgumentException("Alias is null");
            }
            return this.ks.getCertificate(alias);
        }
        catch (KeyStoreException e) {
            throw new TrustKeyConfigurationException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
    }

    public PublicKey getPublicKey(String alias) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        PublicKey publicKey = null;
        try {
            if (this.ks == null) {
                this.setUpKeyStore();
            }
            if (this.ks == null) {
                throw new IllegalStateException("KeyStore is null");
            }
            Certificate cert = this.ks.getCertificate(alias);
            if (cert != null) {
                publicKey = cert.getPublicKey();
            } else if (this.trace) {
                log.trace((Object)("No public key found for alias=" + alias));
            }
            return publicKey;
        }
        catch (KeyStoreException e) {
            throw new TrustKeyConfigurationException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
    }

    public PublicKey getValidatingKey(String domain) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        PublicKey publicKey = null;
        try {
            if (this.ks == null) {
                this.setUpKeyStore();
            }
            if (this.ks == null) {
                throw new IllegalStateException("KeyStore is null");
            }
            String domainAlias = this.domainAliasMap.get(domain);
            if (domainAlias == null) {
                throw new IllegalStateException("Domain Alias missing for " + domain);
            }
            publicKey = null;
            try {
                publicKey = KeyStoreUtil.getPublicKey((KeyStore)this.ks, (String)domainAlias, (char[])this.keyStorePass.toCharArray());
            }
            catch (UnrecoverableKeyException urke) {
                publicKey = KeyStoreUtil.getPublicKey((KeyStore)this.ks, (String)domainAlias, (char[])this.signingKeyPass);
            }
        }
        catch (KeyStoreException e) {
            throw new TrustKeyConfigurationException((Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (GeneralSecurityException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        catch (IOException e) {
            throw new TrustKeyProcessingException((Throwable)e);
        }
        return publicKey;
    }

    public void setAuthProperties(List<AuthPropertyType> authList) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        for (AuthPropertyType auth : authList) {
            this.authPropsMap.put(auth.getKey(), auth.getValue());
        }
        this.keyStoreURL = this.authPropsMap.get(KEYSTORE_URL);
        this.keyStorePass = this.authPropsMap.get(KEYSTORE_PASS);
        this.signingAlias = this.authPropsMap.get(SIGNING_KEY_ALIAS);
        String keypass = this.authPropsMap.get(SIGNING_KEY_PASS);
        if (keypass == null || keypass.length() == 0) {
            throw new RuntimeException("Signing Key Pass is null");
        }
        this.signingKeyPass = keypass.toCharArray();
    }

    public void setValidatingAlias(List<KeyValueType> aliases) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        for (KeyValueType alias : aliases) {
            this.domainAliasMap.put(alias.getKey(), alias.getValue());
        }
    }

    public SecretKey getEncryptionKey(String domain, String encryptionAlgorithm, int keyLength) throws TrustKeyConfigurationException, TrustKeyProcessingException {
        SecretKey key = this.keys.get(domain);
        if (key == null) {
            try {
                key = EncryptionKeyUtil.getSecretKey(encryptionAlgorithm, keyLength);
            }
            catch (GeneralSecurityException e) {
                throw new TrustKeyProcessingException((Throwable)e);
            }
            this.keys.put(domain, key);
        }
        return key;
    }

    private void setUpKeyStore() throws GeneralSecurityException, IOException {
        if (this.keyStoreURL == null) {
            this.keyStoreURL = SecurityActions.getProperty("javax.net.ssl.keyStore", null);
        }
        if (this.keyStorePass == null) {
            this.keyStorePass = SecurityActions.getProperty("javax.net.ssl.keyStorePassword", null);
        }
        InputStream is = ValveUtil.getKeyStoreInputStream(this.keyStoreURL);
        this.ks = KeyStoreUtil.getKeyStore((InputStream)is, (char[])this.keyStorePass.toCharArray());
    }
}

