/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.idp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.bindings.tomcat.TomcatRoleGenerator;
import org.jboss.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.config.KeyProviderType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.impl.DelegatedAttributeManager;
import org.jboss.identity.federation.core.interfaces.AttributeManager;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.web.interfaces.RoleGenerator;
import org.jboss.identity.federation.web.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.web.interfaces.TrustKeyManager;
import org.jboss.identity.federation.web.interfaces.TrustKeyProcessingException;
import org.jboss.identity.federation.web.util.ConfigurationUtil;
import org.jboss.identity.federation.web.util.IDPWebRequestUtil;
import org.jboss.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.w3c.dom.Document;

public class IDPWebBrowserSSOValve
extends ValveBase
implements Lifecycle {
    private static Logger log = Logger.getLogger(IDPWebBrowserSSOValve.class);
    private boolean trace = log.isTraceEnabled();
    protected IDPType idpConfiguration = null;
    private RoleGenerator rg = new TomcatRoleGenerator();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    private TrustKeyManager keyManager;
    private Boolean ignoreIncomingSignatures = true;
    private Boolean signOutgoingMessages = true;
    private transient DelegatedAttributeManager attribManager = new DelegatedAttributeManager();
    private List<String> attributeKeys = new ArrayList<String>();
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean started = false;

    public void setAttributeList(String attribList) {
        if (attribList != null && !"".equals(attribList)) {
            this.attributeKeys.clear();
            StringTokenizer st = new StringTokenizer(attribList, ",");
            while (st != null && st.hasMoreTokens()) {
                this.attributeKeys.add(st.nextToken());
            }
        }
    }

    public Boolean getIgnoreIncomingSignatures() {
        return this.ignoreIncomingSignatures;
    }

    public void setIgnoreIncomingSignatures(Boolean ignoreIncomingSignature) {
        this.ignoreIncomingSignatures = ignoreIncomingSignature;
    }

    public Boolean getSignOutgoingMessages() {
        return this.signOutgoingMessages;
    }

    public void setSignOutgoingMessages(Boolean signOutgoingMessages) {
        this.signOutgoingMessages = signOutgoingMessages;
    }

    public void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(rgName);
            this.rg = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block84: {
            Principal userPrincipal;
            String referer = request.getHeader("Referer");
            String relayState = request.getParameter("RelayState");
            String samlMessage = request.getParameter("SAMLRequest");
            String signature = request.getParameter("Signature");
            String sigAlg = request.getParameter("SigAlg");
            boolean containsSAMLRequestMessage = samlMessage != null;
            Session session = request.getSessionInternal();
            if (containsSAMLRequestMessage) {
                if (this.trace) {
                    log.trace((Object)"Storing the SAMLRequest and RelayState in session");
                }
                session.setNote("SAMLRequest", (Object)samlMessage);
                if (relayState != null && relayState.length() > 0) {
                    session.setNote("RelayState", (Object)relayState.trim());
                }
                if (signature != null && signature.length() > 0) {
                    session.setNote("Signature", (Object)signature.trim());
                }
                if (sigAlg != null && sigAlg.length() > 0) {
                    session.setNote("sigAlg", (Object)sigAlg.trim());
                }
            }
            if ((userPrincipal = request.getPrincipal()) == null) {
                try {
                    this.getNext().invoke(request, response);
                }
                finally {
                    userPrincipal = request.getPrincipal();
                    referer = request.getHeader("Referer");
                    if (this.trace) {
                        log.trace((Object)("Referer in finally block=" + referer + ":user principal=" + userPrincipal));
                    }
                }
            }
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
            webRequestUtil.setAttributeManager((AttributeManager)this.attribManager);
            webRequestUtil.setAttributeKeys(this.attributeKeys);
            Document samlErrorResponse = null;
            if (response.getStatus() == 403) {
                try {
                    samlErrorResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                    if (this.signOutgoingMessages.booleanValue()) {
                        webRequestUtil.send(samlErrorResponse, referer, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                    } else {
                        webRequestUtil.send(samlErrorResponse, referer, relayState, (HttpServletResponse)response, false, null);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
            if (userPrincipal != null) {
                samlMessage = (String)session.getNote("SAMLRequest");
                relayState = (String)session.getNote("RelayState");
                signature = (String)session.getNote("Signature");
                sigAlg = (String)session.getNote("sigAlg");
                if (this.trace) {
                    log.trace((Object)"Retrieved saml message and relay state from session");
                    log.trace((Object)("saml message=" + samlMessage + "::relay state=" + relayState));
                    log.trace((Object)("Signature=" + signature + "::sigAlg=" + sigAlg));
                }
                session.removeNote("SAMLRequest");
                if (relayState != null && relayState.length() > 0) {
                    session.removeNote("RelayState");
                }
                if (signature != null && signature.length() > 0) {
                    session.removeNote("Signature");
                }
                if (sigAlg != null && sigAlg.length() > 0) {
                    session.removeNote("sigAlg");
                }
                if (samlMessage != null) {
                    block82: {
                        RequestAbstractType requestAbstractType = null;
                        Document samlResponse = null;
                        String destination = null;
                        requestAbstractType = webRequestUtil.getSAMLRequest(samlMessage);
                        boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                        boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlMessage, signature, sigAlg), isPost);
                        if (!isValid) {
                            throw new GeneralSecurityException("Validation check failed");
                        }
                        webRequestUtil.isTrusted(requestAbstractType.getIssuer().getValue());
                        List roles = this.rg.generateRoles(userPrincipal);
                        log.trace((Object)"Roles have been determined:Creating response");
                        AuthnRequestType art = (AuthnRequestType)requestAbstractType;
                        destination = art.getAssertionConsumerServiceURL();
                        samlResponse = webRequestUtil.getResponse(destination, userPrincipal, roles, this.identityURL, this.assertionValidity, this.signOutgoingMessages.booleanValue());
                        Object var21_28 = null;
                        try {
                            if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                this.recycle(response);
                            }
                            if (this.signOutgoingMessages.booleanValue()) {
                                webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                                break block82;
                            }
                            webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null);
                        }
                        catch (ParsingException e2) {
                            if (this.trace) {
                                log.trace((Object)e2);
                            }
                            break block82;
                        }
                        catch (GeneralSecurityException e3) {
                            if (this.trace) {
                                log.trace((Object)e3);
                            }
                            break block82;
                        }
                        {
                            catch (IssuerNotTrustedException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var21_29 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                                        break block82;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block82;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block82;
                                }
                            }
                            catch (ParsingException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var21_30 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                                        break block82;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block82;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block82;
                                }
                            }
                            catch (ConfigurationException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var21_31 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                                        break block82;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block82;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block82;
                                }
                            }
                            catch (IssueInstantMissingException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var21_32 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                                        break block82;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block82;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                    break block82;
                                }
                            }
                            catch (GeneralSecurityException e) {
                                if (this.trace) {
                                    log.trace((Object)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var21_33 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                                        break block82;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                    break block82;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)e3);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block83: {
                                Object var21_34 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
                                    } else {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null);
                                    }
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)e2);
                                    }
                                }
                                catch (GeneralSecurityException e3) {
                                    if (!this.trace) break block83;
                                    log.trace((Object)e3);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return;
                }
                log.error((Object)"No SAML Request Message");
                if (this.trace) {
                    log.trace((Object)("Referer=" + referer));
                }
                try {
                    this.sendErrorResponseToSP(referer, response, relayState, webRequestUtil);
                }
                catch (ConfigurationException e) {
                    if (!this.trace) break block84;
                    log.trace((Object)e);
                }
            }
        }
    }

    protected void sendErrorResponseToSP(String referrer, Response response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("About to send error response to SP:" + referrer));
        }
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
        try {
            if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                this.recycle(response);
            }
            if (this.signOutgoingMessages.booleanValue()) {
                webRequestUtil.send(samlResponse, referrer, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey());
            } else {
                webRequestUtil.send(samlResponse, referrer, relayState, (HttpServletResponse)response, false, null);
            }
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean validate(String remoteAddress, String queryString, SessionHolder holder, boolean isPost) throws IOException, GeneralSecurityException {
        if (holder.samlRequest == null || holder.samlRequest.length() == 0) {
            return false;
        }
        if (!this.ignoreIncomingSignatures.booleanValue() && !isPost) {
            PublicKey validatingKey;
            String sig = holder.signature;
            if (sig == null || sig.length() == 0) {
                log.error((Object)("Signature received from SP is null:" + remoteAddress));
                return false;
            }
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL((String)queryString);
            if (sigValue == null) {
                return false;
            }
            try {
                validatingKey = this.keyManager.getValidatingKey(remoteAddress);
            }
            catch (TrustKeyConfigurationException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            catch (TrustKeyProcessingException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            return RedirectBindingSignatureUtil.validateSignature((String)queryString, (PublicKey)validatingKey, (byte[])sigValue);
        }
        return true;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        ClassLoader tcl;
        if (this.started) {
            throw new LifecycleException("IDPRedirectValve already Started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        String configFile = "/WEB-INF/jboss-idfed.xml";
        Context context = (Context)this.getContainer();
        InputStream is = context.getServletContext().getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        try {
            this.idpConfiguration = ConfigurationUtil.getIDPConfiguration((InputStream)is);
            this.identityURL = this.idpConfiguration.getIdentityURL();
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
            String attributeManager = this.idpConfiguration.getAttributeManager();
            if (attributeManager != null && !"".equals(attributeManager)) {
                tcl = SecurityActions.getContextClassLoader();
                AttributeManager delegate = (AttributeManager)tcl.loadClass(attributeManager).newInstance();
                this.attribManager.setDelegate(delegate);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.signOutgoingMessages.booleanValue()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new LifecycleException("Key Provider is null for context=" + context.getName());
            }
            try {
                tcl = SecurityActions.getContextClassLoader();
                String keyManagerClassName = keyProvider.getClassName();
                if (keyManagerClassName == null) {
                    throw new RuntimeException("KeyManager class name is null");
                }
                Class<?> clazz = tcl.loadClass(keyManagerClassName);
                this.keyManager = (TrustKeyManager)clazz.newInstance();
                this.keyManager.setAuthProperties(keyProvider.getAuth());
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new LifecycleException(e.getLocalizedMessage());
            }
            if (this.trace) {
                log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
            }
        }
        String[] ak = new String[]{"mail", "cn", "commonname", "givenname", "surname", "employeeType", "employeeNumber", "facsimileTelephoneNumber"};
        this.attributeKeys.addAll(Arrays.asList(ak));
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("IDPRedirectValve NotStarted");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    private void recycle(Response response) {
        response.recycle();
    }

    protected static class SessionHolder {
        String samlRequest;
        String signature;
        String sigAlg;

        public SessionHolder(String req, String sig, String alg) {
            this.samlRequest = req;
            this.signature = sig;
            this.sigAlg = alg;
        }
    }
}

