/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.jboss.identity.federation.bindings.tomcat.sp.SPUtil;
import org.jboss.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.core.config.TrustType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.web.util.PostBindingUtil;
import org.jboss.identity.federation.web.util.ServerDetector;
import org.xml.sax.SAXException;

public class SPPostFormAuthenticator
extends BaseFormAuthenticator {
    private static Logger log = Logger.getLogger(SPPostFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    private boolean jbossEnv = false;

    public SPPostFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        SPUtil spUtil = new SPUtil();
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (this.trace) {
                log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            return true;
        }
        Session session = request.getSessionInternal(true);
        String relayState = request.getParameter("RelayState");
        try {
            principal = (GenericPrincipal)this.process(request, response);
            if (principal == null) {
                AuthnRequestType authnRequest = spUtil.createSAMLRequest(this.serviceURL, this.identityURL);
                this.sendRequestToIDP(authnRequest, relayState, response);
                return false;
            }
            String username = principal.getName();
            String password = "EMPTY_STR";
            if (this.spConfiguration.getServerEnvironment().equalsIgnoreCase("JBOSS") || this.jbossEnv) {
                GenericPrincipal gp = (GenericPrincipal)principal;
                ServiceProviderSAMLContext.push(username, Arrays.asList(gp.getRoles()));
                principal = this.context.getRealm().authenticate(username, password);
                ServiceProviderSAMLContext.clear();
            }
            session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            request.setUserPrincipal(principal);
            this.register(request, response, principal, "FORM", username, password);
            return true;
        }
        catch (AssertionExpiredException aie) {
            block11: {
                if (this.trace) {
                    log.trace((Object)"Assertion has expired. Issuing a new saml2 request to the IDP");
                }
                try {
                    AuthnRequestType authnRequest = spUtil.createSAMLRequest(this.serviceURL, this.identityURL);
                    this.sendRequestToIDP(authnRequest, relayState, response);
                }
                catch (Exception e) {
                    if (!this.trace) break block11;
                    log.trace((Object)"Exception:", (Throwable)e);
                }
            }
            return false;
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Exception :", (Throwable)e);
            }
            response.sendError(500);
            return super.authenticate(request, response, loginConfig);
        }
    }

    protected void sendRequestToIDP(AuthnRequestType authnRequest, String relayState, Response response) throws IOException, SAXException, JAXBException, GeneralSecurityException {
        SAML2Request saml2Request = new SAML2Request();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, (OutputStream)baos);
        String samlMessage = PostBindingUtil.base64Encode((String)baos.toString());
        String destination = authnRequest.getDestination();
        PostBindingUtil.sendPost((DestinationInfoHolder)new DestinationInfoHolder(destination, samlMessage, relayState), (HttpServletResponse)response, (boolean)true);
    }

    protected AuthnRequestType createSAMLRequestMessage(String relayState, Response response) throws ServletException, ConfigurationException {
        if (this.serviceURL == null) {
            throw new ServletException("serviceURL is not configured");
        }
        SPUtil spUtil = new SPUtil();
        return spUtil.createSAMLRequest(this.serviceURL, this.identityURL);
    }

    protected String getDestination(String urlEncodedRequest, String urlEncodedRelayState) {
        StringBuilder sb = new StringBuilder();
        sb.append("?SAMLRequest=").append(urlEncodedRequest);
        if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        return sb.toString();
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String domainsTrusted;
            String issuerDomain = ValveUtil.getDomain(issuer);
            TrustType idpTrust = this.spConfiguration.getTrust();
            if (idpTrust != null && (domainsTrusted = idpTrust.getDomains()).indexOf(issuerDomain) < 0) {
                throw new IssuerNotTrustedException(issuer);
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected ResponseType decryptAssertion(ResponseType responseType) {
        throw new RuntimeException("This authenticator does not handle encryption");
    }

    private Principal process(Request request, Response response) throws JAXBException, SAXException, IssuerNotTrustedException, AssertionExpiredException, ConfigurationException, GeneralSecurityException {
        Principal userPrincipal = null;
        String samlResponse = request.getParameter("SAMLResponse");
        if (samlResponse != null && samlResponse.length() > 0) {
            boolean isValid = false;
            try {
                isValid = this.validate(request);
            }
            catch (IOException e) {
                throw new GeneralSecurityException(e);
            }
            if (!isValid) {
                throw new GeneralSecurityException("Validity check failed");
            }
            byte[] base64DecodedResponse = PostBindingUtil.base64Decode((String)samlResponse);
            ByteArrayInputStream is = new ByteArrayInputStream(base64DecodedResponse);
            SAML2Response saml2Response = new SAML2Response();
            ResponseType responseType = saml2Response.getResponseType((InputStream)is);
            SAMLDocumentHolder samlDocumentHolder = saml2Response.getSamlDocumentHolder();
            boolean validSignature = this.verifySignature(samlDocumentHolder);
            if (!validSignature) {
                throw new IssuerNotTrustedException("Signature in saml document is invalid");
            }
            this.isTrusted(responseType.getIssuer().getValue());
            List assertions = responseType.getAssertionOrEncryptedAssertion();
            if (assertions.size() == 0) {
                throw new IllegalStateException("No assertions in reply from IDP");
            }
            Object assertion = assertions.get(0);
            if (assertion instanceof EncryptedElementType) {
                responseType = this.decryptAssertion(responseType);
            }
            SPUtil spUtil = new SPUtil();
            return spUtil.handleSAMLResponse(request, responseType);
        }
        return userPrincipal;
    }

    protected boolean verifySignature(SAMLDocumentHolder samlDocumentHolder) throws IssuerNotTrustedException {
        return true;
    }
}

