/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PublicKey;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.XMLSignatureException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Response;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.bindings.tomcat.sp.SPPostFormAuthenticator;
import org.jboss.identity.federation.bindings.tomcat.sp.SecurityActions;
import org.jboss.identity.federation.core.config.KeyProviderType;
import org.jboss.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.DestinationInfoHolder;
import org.jboss.identity.federation.core.util.XMLSignatureUtil;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.web.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.web.interfaces.TrustKeyManager;
import org.jboss.identity.federation.web.interfaces.TrustKeyProcessingException;
import org.jboss.identity.federation.web.util.PostBindingUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SPPostSignatureFormAuthenticator
extends SPPostFormAuthenticator {
    private static Logger log = Logger.getLogger(SPPostSignatureFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    private TrustKeyManager keyManager;
    private boolean signAssertions = false;

    public boolean isSignAssertions() {
        return this.signAssertions;
    }

    public void setSignAssertions(boolean signAssertions) {
        this.signAssertions = signAssertions;
    }

    public void start() throws LifecycleException {
        super.start();
        KeyProviderType keyProvider = this.spConfiguration.getKeyProvider();
        if (keyProvider == null) {
            throw new LifecycleException("KeyProvider is null");
        }
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            this.keyManager.setAuthProperties(keyProvider.getAuth());
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        if (this.trace) {
            log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
        }
    }

    protected void sendRequestToIDP(AuthnRequestType authnRequest, String relayState, Response response) throws IOException, SAXException, JAXBException, GeneralSecurityException {
        SAML2Request saml2Request = new SAML2Request();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, (OutputStream)baos);
        String samlMessage = PostBindingUtil.base64Encode((String)baos.toString());
        String destination = authnRequest.getDestination();
        PostBindingUtil.sendPost((DestinationInfoHolder)new DestinationInfoHolder(destination, samlMessage, relayState), (HttpServletResponse)response, (boolean)true);
    }

    protected boolean verifySignature(SAMLDocumentHolder samlDocumentHolder) throws IssuerNotTrustedException {
        URL issuerURL;
        Document samlResponse = samlDocumentHolder.getSamlDocument();
        ResponseType response = (ResponseType)samlDocumentHolder.getSamlObject();
        String issuerID = response.getIssuer().getValue();
        if (issuerID == null) {
            throw new IssuerNotTrustedException("Issue missing");
        }
        try {
            issuerURL = new URL(issuerID);
        }
        catch (MalformedURLException e1) {
            throw new IssuerNotTrustedException((Throwable)e1);
        }
        try {
            PublicKey publicKey = this.keyManager.getValidatingKey(issuerURL.getHost());
            if (this.trace) {
                log.trace((Object)"Going to verify signature in the saml response from IDP");
            }
            boolean sigResult = XMLSignatureUtil.validate((Document)samlResponse, (Key)publicKey);
            if (this.trace) {
                log.trace((Object)("Signature verification=" + sigResult));
            }
            return sigResult;
        }
        catch (TrustKeyConfigurationException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (TrustKeyProcessingException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (MarshalException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        catch (XMLSignatureException e) {
            log.error((Object)"Unable to verify signature", (Throwable)e);
        }
        return false;
    }
}

