/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.jboss.identity.federation.bindings.util.SecurityActions;

public class ValveUtil {
    public static InputStream getKeyStoreInputStream(String keyStore) {
        String userHome;
        File ksDir;
        InputStream is = null;
        try {
            File file = new File(keyStore);
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            try {
                URL url = new URL(keyStore);
                is = url.openStream();
            }
            catch (Exception ex) {
                is = SecurityActions.getContextClassLoader().getResourceAsStream(keyStore);
            }
        }
        if (is == null && (ksDir = new File(userHome = SecurityActions.getSystemProperty("user.home", "") + "/jbid-keystore")).exists()) {
            try {
                is = new FileInputStream(new File(userHome + "/" + keyStore));
            }
            catch (FileNotFoundException e) {
                is = null;
            }
        }
        if (is == null) {
            throw new RuntimeException("Keystore not located:" + keyStore);
        }
        return is;
    }

    public static String getDomain(String domainURL) throws IOException {
        URL url = new URL(domainURL);
        return url.getHost();
    }
}

