/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.metadata.KeyDescriptorMetaDataBuilder;
import org.jboss.identity.federation.api.saml.v2.metadata.MetaDataBuilder;
import org.jboss.identity.federation.api.util.KeyUtil;
import org.jboss.identity.federation.bindings.providers.IMetadataProvider;
import org.jboss.identity.federation.bindings.servlets.SecurityActions;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.config.KeyProviderType;
import org.jboss.identity.federation.core.config.KeyValueType;
import org.jboss.identity.federation.core.config.MetadataProviderType;
import org.jboss.identity.federation.core.interfaces.TrustKeyManager;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.jboss.identity.federation.core.util.XMLEncryptionUtil;
import org.jboss.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.jboss.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.jboss.identity.federation.saml.v2.metadata.RoleDescriptorType;
import org.jboss.identity.federation.web.util.ConfigurationUtil;
import org.jboss.identity.xmlsec.w3.xmldsig.KeyInfoType;

public class MetadataServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(MetadataServlet.class);
    private boolean trace = log.isTraceEnabled();
    private String configFileLocation = "/WEB-INF/jboss-idfed.xml";
    private transient MetadataProviderType metadataProviderType = null;
    private transient IMetadataProvider<?> metadataProvider = null;
    private transient EntityDescriptorType metadata;
    private String signingAlias = null;
    private String encryptingAlias = null;
    private TrustKeyManager keyManager;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        try {
            InputStream is;
            ServletContext context = config.getServletContext();
            String configL = config.getInitParameter("configFile");
            if (configL != null && configL.length() > 0) {
                this.configFileLocation = configL;
            }
            if (this.trace) {
                log.trace((Object)("Config File Location=" + this.configFileLocation));
            }
            if ((is = context.getResourceAsStream(this.configFileLocation)) == null) {
                throw new RuntimeException(this.configFileLocation + " missing");
            }
            this.signingAlias = config.getInitParameter("signingAlias");
            this.encryptingAlias = config.getInitParameter("encryptingAlias");
            IDPType providerType = ConfigurationUtil.getIDPConfiguration((InputStream)is);
            this.metadataProviderType = providerType.getMetaDataProvider();
            String fqn = this.metadataProviderType.getClassName();
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            Class<?> clazz = tcl.loadClass(fqn);
            this.metadataProvider = (IMetadataProvider)clazz.newInstance();
            List keyValues = this.metadataProviderType.getOption();
            HashMap<String, String> options = new HashMap<String, String>();
            if (keyValues != null) {
                for (KeyValueType kvt : keyValues) {
                    options.put(kvt.getKey(), kvt.getValue());
                }
            }
            this.metadataProvider.init(options);
            if (this.metadataProvider.isMultiple()) {
                throw new RuntimeException("Multiple Entities not currently supported");
            }
            String fileInjectionStr = this.metadataProvider.requireFileInjection();
            if (fileInjectionStr != null && fileInjectionStr.length() > 0) {
                this.metadataProvider.injectFileStream(context.getResourceAsStream(fileInjectionStr));
            }
            this.metadata = (EntityDescriptorType)this.metadataProvider.getMetaData();
            KeyProviderType keyProvider = providerType.getKeyProvider();
            this.signingAlias = keyProvider.getSigningAlias();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            this.keyManager.setAuthProperties(keyProvider.getAuth());
            Certificate cert = this.keyManager.getCertificate(this.signingAlias);
            KeyInfoType keyInfo = KeyUtil.getKeyInfo((Certificate)cert);
            KeyDescriptorType keyDescriptor = KeyDescriptorMetaDataBuilder.createKeyDescriptor((KeyInfoType)keyInfo, null, (int)0, (boolean)true, (boolean)false);
            this.updateKeyDescriptor(this.metadata, keyDescriptor);
            if (this.encryptingAlias != null) {
                cert = this.keyManager.getCertificate(this.encryptingAlias);
                keyInfo = KeyUtil.getKeyInfo((Certificate)cert);
                String certAlgo = cert.getPublicKey().getAlgorithm();
                keyDescriptor = KeyDescriptorMetaDataBuilder.createKeyDescriptor((KeyInfoType)keyInfo, (String)XMLEncryptionUtil.getEncryptionURL((String)certAlgo), (int)XMLEncryptionUtil.getEncryptionKeySize((String)certAlgo), (boolean)false, (boolean)true);
                this.updateKeyDescriptor(this.metadata, keyDescriptor);
            }
        }
        catch (Exception e) {
            log.error((Object)"Exception in starting servlet:", (Throwable)e);
            throw new ServletException("Unable to start servlet");
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        resp.setContentType(JBossSAMLConstants.METADATA_MIME.get());
        ServletOutputStream os = resp.getOutputStream();
        JAXBElement jaxbEl = MetaDataBuilder.getObjectFactory().createEntityDescriptor(this.metadata);
        try {
            MetaDataBuilder.getMarshaller().marshal((Object)jaxbEl, (OutputStream)os);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateKeyDescriptor(EntityDescriptorType entityD, KeyDescriptorType keyD) {
        List objs = entityD.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor();
        if (objs != null) {
            for (RoleDescriptorType roleD : objs) {
                roleD.getKeyDescriptor().add(keyD);
            }
        }
    }
}

