/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.idp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.bindings.tomcat.TomcatRoleGenerator;
import org.jboss.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.config.TrustType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.web.interfaces.RoleGenerator;
import org.jboss.identity.federation.web.util.ConfigurationUtil;
import org.jboss.identity.federation.web.util.HTTPRedirectUtil;
import org.jboss.identity.federation.web.util.RedirectBindingUtil;
import org.xml.sax.SAXException;

public class IDPRedirectValve
extends ValveBase
implements Lifecycle {
    private static Logger log = Logger.getLogger(IDPRedirectValve.class);
    private boolean trace = log.isTraceEnabled();
    protected IDPType idpConfiguration = null;
    private RoleGenerator rg = new TomcatRoleGenerator();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean started = false;

    public void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(rgName);
            this.rg = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        boolean containsSAMLRequestMessage = this.hasSAMLRequestMessage(request);
        Principal userPrincipal = request.getPrincipal();
        if (userPrincipal != null) return;
        try {
            this.getNext().invoke(request, response);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            String referer = request.getHeader("Referer");
            if (response.getStatus() == 403) {
                ResponseType errorResponseType = this.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get());
                try {
                    this.send(errorResponseType, request.getParameter("RelayState"), response);
                    return;
                }
                catch (ParsingException e) {
                    log.error((Object)e);
                    return;
                }
                catch (ProcessingException e) {
                    log.error((Object)e);
                }
                return;
            }
            userPrincipal = request.getPrincipal();
            if (userPrincipal == null) throw throwable;
            if (containsSAMLRequestMessage) {
                RequestAbstractType requestAbstractType = null;
                try {
                    requestAbstractType = this.getSAMLRequest(request);
                    boolean isValid = this.validate(request);
                    if (!isValid) {
                        throw new GeneralSecurityException("Validity Checks Failed");
                    }
                    this.isTrusted(requestAbstractType.getIssuer().getValue());
                    ResponseType responseType = this.getResponse(request, userPrincipal);
                    this.send(responseType, request.getParameter("RelayState"), response);
                    throw throwable;
                }
                catch (Exception e) {
                    log.error((Object)"Exception:", (Throwable)e);
                    if (requestAbstractType != null) {
                        referer = requestAbstractType.getIssuer().getValue();
                    }
                    ResponseType errorResponseType = this.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_RESPONDER.get());
                    try {
                        this.send(errorResponseType, request.getParameter("RelayState"), response);
                        throw throwable;
                    }
                    catch (ParsingException e1) {
                        log.error((Object)e1);
                        throw throwable;
                    }
                    catch (ProcessingException e1) {
                        log.error((Object)e1);
                    }
                }
                throw throwable;
            }
            log.error((Object)"No SAML Request Message");
            if (!this.trace) throw new ServletException("No SAML Request Message");
            log.trace((Object)("Referer=" + referer));
            throw new ServletException("No SAML Request Message");
        }
        String referer = request.getHeader("Referer");
        if (response.getStatus() == 403) {
            ResponseType errorResponseType = this.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get());
            try {
                this.send(errorResponseType, request.getParameter("RelayState"), response);
                return;
            }
            catch (ParsingException e) {
                log.error((Object)e);
                return;
            }
            catch (ProcessingException e) {
                log.error((Object)e);
            }
            return;
        }
        userPrincipal = request.getPrincipal();
        if (userPrincipal == null) return;
        if (containsSAMLRequestMessage) {
            RequestAbstractType requestAbstractType = null;
            try {
                requestAbstractType = this.getSAMLRequest(request);
                boolean isValid = this.validate(request);
                if (!isValid) {
                    throw new GeneralSecurityException("Validity Checks Failed");
                }
                this.isTrusted(requestAbstractType.getIssuer().getValue());
                ResponseType responseType = this.getResponse(request, userPrincipal);
                this.send(responseType, request.getParameter("RelayState"), response);
                return;
            }
            catch (Exception e) {
                log.error((Object)"Exception:", (Throwable)e);
                if (requestAbstractType != null) {
                    referer = requestAbstractType.getIssuer().getValue();
                }
                ResponseType errorResponseType = this.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_RESPONDER.get());
                try {
                    this.send(errorResponseType, request.getParameter("RelayState"), response);
                    return;
                }
                catch (ParsingException e1) {
                    log.error((Object)e1);
                    return;
                }
                catch (ProcessingException e1) {
                    log.error((Object)e1);
                }
            }
            return;
        }
        log.error((Object)"No SAML Request Message");
        if (!this.trace) throw new ServletException("No SAML Request Message");
        log.trace((Object)("Referer=" + referer));
        throw new ServletException("No SAML Request Message");
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String domainsTrusted;
            String issuerDomain = ValveUtil.getDomain(issuer);
            TrustType idpTrust = this.idpConfiguration.getTrust();
            if (idpTrust != null && (domainsTrusted = idpTrust.getDomains()).indexOf(issuerDomain) < 0) {
                throw new IssuerNotTrustedException(issuer);
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected void send(ResponseType responseType, String relayState, Response response) throws ParsingException, ProcessingException {
        try {
            SAML2Response saml2Response = new SAML2Response();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            saml2Response.marshall(responseType, (OutputStream)baos);
            String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode((byte[])baos.toByteArray());
            String destination = responseType.getDestination();
            if (this.trace) {
                log.trace((Object)("IDP:Destination=" + destination));
            }
            if (relayState != null && relayState.length() > 0) {
                relayState = RedirectBindingUtil.urlEncode((String)relayState);
            }
            String finalDest = destination + this.getDestination(urlEncodedResponse, relayState);
            HTTPRedirectUtil.sendRedirectForResponder((String)finalDest, (HttpServletResponse)response);
        }
        catch (JAXBException e) {
            throw new ParsingException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ParsingException((Throwable)e);
        }
        catch (IOException e) {
            throw new ProcessingException((Throwable)e);
        }
    }

    protected String getDestination(String urlEncodedResponse, String urlEncodedRelayState) {
        StringBuilder sb = new StringBuilder();
        sb.append("?SAMLResponse=").append(urlEncodedResponse);
        if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        return sb.toString();
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        return this.hasSAMLRequestMessage(request);
    }

    private boolean hasSAMLRequestMessage(Request request) {
        return request.getParameter("SAMLRequest") != null;
    }

    private RequestAbstractType getSAMLRequest(Request request) throws ParsingException, IOException {
        String samlMessage = this.getSAMLMessage(request);
        InputStream is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        SAML2Request saml2Request = new SAML2Request();
        return saml2Request.getRequestType(is);
    }

    protected ResponseType getResponse(Request request, Principal userPrincipal) throws ParsingException, ConfigurationException, ProcessingException {
        ResponseType responseType = null;
        String samlMessage = this.getSAMLMessage(request);
        InputStream is = RedirectBindingUtil.base64DeflateDecode((String)samlMessage);
        SAML2Request saml2Request = new SAML2Request();
        AuthnRequestType authnRequestType = null;
        try {
            authnRequestType = saml2Request.getAuthnRequestType(is);
        }
        catch (JAXBException e2) {
            throw new ParsingException((Throwable)e2);
        }
        catch (SAXException e2) {
            throw new ParsingException((Throwable)e2);
        }
        if (authnRequestType == null) {
            throw new IllegalStateException("AuthnRequest is null");
        }
        if (log.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            try {
                saml2Request.marshall((RequestAbstractType)authnRequestType, (Writer)sw);
            }
            catch (SAXException e) {
                log.trace((Object)e);
            }
            catch (JAXBException e) {
                log.trace((Object)e);
            }
            log.trace((Object)("IDPRedirectValve::AuthnRequest=" + sw.toString()));
        }
        SAML2Response saml2Response = new SAML2Response();
        String id = IDGenerator.create((String)"ID_");
        IssuerInfoHolder issuerHolder = new IssuerInfoHolder(this.identityURL);
        issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
        IDPInfoHolder idp = new IDPInfoHolder();
        idp.setNameIDFormatValue(userPrincipal.getName());
        idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
        SPInfoHolder sp = new SPInfoHolder();
        sp.setResponseDestinationURI(authnRequestType.getAssertionConsumerServiceURL());
        responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
        List roles = this.rg.generateRoles(userPrincipal);
        AssertionType assertion = (AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0);
        AttributeStatementType attrStatement = saml2Response.createAttributeStatement(roles);
        assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attrStatement);
        try {
            saml2Response.createTimedConditions(assertion, this.assertionValidity);
        }
        catch (IssueInstantMissingException e1) {
            log.error((Object)e1);
        }
        if (log.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            try {
                saml2Response.marshall(responseType, (Writer)sw);
            }
            catch (JAXBException e) {
                log.trace((Object)e);
            }
            catch (SAXException e) {
                log.trace((Object)e);
            }
            log.trace((Object)("IDPRedirectValve::Response=" + sw.toString()));
        }
        return responseType;
    }

    private ResponseType getErrorResponse(String responseURL, String status) throws ServletException {
        try {
            ResponseType responseType = null;
            SAML2Response saml2Response = new SAML2Response();
            String id = IDGenerator.create((String)"ID_");
            IssuerInfoHolder issuerHolder = new IssuerInfoHolder(this.identityURL);
            issuerHolder.setStatusCode(status);
            IDPInfoHolder idp = new IDPInfoHolder();
            idp.setNameIDFormatValue(null);
            idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
            SPInfoHolder sp = new SPInfoHolder();
            sp.setResponseDestinationURI(responseURL);
            responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
            if (log.isTraceEnabled()) {
                log.trace((Object)"ResponseType = ");
                StringWriter sw = new StringWriter();
                saml2Response.marshall(responseType, (Writer)sw);
                log.trace((Object)("IDPRedirectValve::Response=" + sw.toString()));
            }
            return responseType;
        }
        catch (Exception e) {
            log.error((Object)"Exception in getErrorResponse::", (Throwable)e);
            throw new ServletException(e.getLocalizedMessage());
        }
    }

    private String getSAMLMessage(Request request) {
        return request.getParameter("SAMLRequest");
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("IDPRedirectValve already Started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        String configFile = "/WEB-INF/jboss-idfed.xml";
        Context context = (Context)this.getContainer();
        InputStream is = context.getServletContext().getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        try {
            this.idpConfiguration = ConfigurationUtil.getIDPConfiguration((InputStream)is);
            this.identityURL = this.idpConfiguration.getIdentityURL();
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("IDPRedirectValve NotStarted");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }
}

