/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.config.SPType;
import org.jboss.identity.federation.web.util.ConfigurationUtil;

public class BaseFormAuthenticator
extends FormAuthenticator {
    private static Logger log = Logger.getLogger(BaseFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    protected SPType spConfiguration = null;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected String configFile = "/WEB-INF/jboss-idfed.xml";

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        return request.getParameter("SAMLResponse") != null;
    }

    public void start() throws LifecycleException {
        super.start();
        InputStream is = this.context.getServletContext().getResourceAsStream(this.configFile);
        if (is == null) {
            throw new RuntimeException(this.configFile + " missing");
        }
        try {
            this.spConfiguration = ConfigurationUtil.getSPConfiguration((InputStream)is);
            this.identityURL = this.spConfiguration.getIdentityURL();
            this.serviceURL = this.spConfiguration.getServiceURL();
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

