/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.api.util.Base64;
import org.jboss.identity.federation.api.util.DeflateUtil;
import org.jboss.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.jboss.identity.federation.bindings.tomcat.sp.SPUtil;
import org.jboss.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.core.config.TrustType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.AssertionExpiredException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.web.util.HTTPRedirectUtil;
import org.jboss.identity.federation.web.util.RedirectBindingUtil;
import org.jboss.identity.federation.web.util.ServerDetector;
import org.xml.sax.SAXException;

public class SPRedirectFormAuthenticator
extends BaseFormAuthenticator {
    private static Logger log = Logger.getLogger(SPRedirectFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    private boolean jbossEnv = false;

    public SPRedirectFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        Principal principal = request.getUserPrincipal();
        if (principal != null) {
            if (this.trace) {
                log.trace((Object)("Already authenticated '" + principal.getName() + "'"));
            }
            return true;
        }
        Session session = request.getSessionInternal(true);
        String relayState = request.getParameter("RelayState");
        try {
            principal = (GenericPrincipal)this.process(request, response);
            if (principal == null) {
                String destination = this.createSAMLRequestMessage(relayState, response);
                HTTPRedirectUtil.sendRedirectForRequestor((String)destination, (HttpServletResponse)response);
                return false;
            }
            String username = principal.getName();
            String password = "EMPTY_STR";
            if (this.spConfiguration.getServerEnvironment().equalsIgnoreCase("JBOSS") || this.jbossEnv) {
                GenericPrincipal gp = (GenericPrincipal)principal;
                ServiceProviderSAMLContext.push(username, Arrays.asList(gp.getRoles()));
                principal = this.context.getRealm().authenticate(username, password);
                ServiceProviderSAMLContext.clear();
            }
            session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
            session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
            request.setUserPrincipal(principal);
            this.register(request, response, principal, "FORM", username, password);
            return true;
        }
        catch (AssertionExpiredException aie) {
            block11: {
                if (this.trace) {
                    log.trace((Object)"Assertion has expired. Issuing a new saml2 request to the IDP");
                }
                try {
                    String destination = this.createSAMLRequestMessage(relayState, response);
                    HTTPRedirectUtil.sendRedirectForRequestor((String)destination, (HttpServletResponse)response);
                }
                catch (Exception e) {
                    if (!this.trace) break block11;
                    log.trace((Object)"Exception:", (Throwable)e);
                }
            }
            return false;
        }
        catch (Exception e) {
            if (this.trace) {
                log.trace((Object)"Exception :", (Throwable)e);
            }
            return super.authenticate(request, response, loginConfig);
        }
    }

    protected String createSAMLRequestMessage(String relayState, Response response) throws ServletException, ConfigurationException, SAXException, JAXBException, IOException {
        if (this.serviceURL == null) {
            throw new ServletException("serviceURL is not configured");
        }
        SAML2Request saml2Request = new SAML2Request();
        SPUtil spUtil = new SPUtil();
        AuthnRequestType authnRequest = spUtil.createSAMLRequest(this.serviceURL, this.identityURL);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, (OutputStream)baos);
        String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])baos.toByteArray());
        String destination = authnRequest.getDestination() + this.getDestination(base64Request, relayState);
        if (this.trace) {
            log.trace((Object)("Sending to destination=" + destination));
        }
        return destination;
    }

    protected String getDestination(String urlEncodedRequest, String urlEncodedRelayState) {
        StringBuilder sb = new StringBuilder();
        sb.append("?SAMLRequest=").append(urlEncodedRequest);
        if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        return sb.toString();
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String issuerDomain = ValveUtil.getDomain(issuer);
            TrustType spTrust = this.spConfiguration.getTrust();
            if (spTrust != null) {
                String domainsTrusted = spTrust.getDomains();
                if (this.trace) {
                    log.trace((Object)("Domains that SP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                }
                if (domainsTrusted.indexOf(issuerDomain) < 0) {
                    StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                    while (st != null && st.hasMoreTokens()) {
                        String uriBit = st.nextToken();
                        if (this.trace) {
                            log.trace((Object)("Matching uri bit=" + uriBit));
                        }
                        if (issuerDomain.indexOf(uriBit) <= 0) continue;
                        if (this.trace) {
                            log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                        }
                        return;
                    }
                    throw new IssuerNotTrustedException(issuer);
                }
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected ResponseType decryptAssertion(ResponseType responseType) throws IOException, GeneralSecurityException, ConfigurationException, ParsingException {
        throw new RuntimeException("This authenticator does not handle encryption");
    }

    private Principal process(Request request, Response response) throws IOException, GeneralSecurityException, ConfigurationException, ParsingException {
        Principal userPrincipal = null;
        String samlResponse = request.getParameter("SAMLResponse");
        if (samlResponse != null && samlResponse.length() > 0) {
            boolean isValid = this.validate(request);
            if (!isValid) {
                throw new GeneralSecurityException("Validity Checks failed");
            }
            byte[] base64DecodedResponse = Base64.decode((String)samlResponse);
            InputStream is = DeflateUtil.decode((byte[])base64DecodedResponse);
            SAML2Response saml2Response = new SAML2Response();
            ResponseType responseType = saml2Response.getResponseType(is);
            this.isTrusted(responseType.getIssuer().getValue());
            List assertions = responseType.getAssertionOrEncryptedAssertion();
            if (assertions.size() == 0) {
                throw new IllegalStateException("No assertions in reply from IDP");
            }
            Object assertion = assertions.get(0);
            if (assertion instanceof EncryptedElementType) {
                responseType = this.decryptAssertion(responseType);
            }
            SPUtil spUtil = new SPUtil();
            return spUtil.handleSAMLResponse(request, responseType);
        }
        return userPrincipal;
    }
}

