/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.jboss.wstrust;

import java.io.InputStream;
import java.net.URL;
import javax.annotation.Resource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.transform.Source;
import javax.xml.ws.Service;
import javax.xml.ws.ServiceMode;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceProvider;
import org.jboss.identity.federation.api.wstrust.STSConfiguration;
import org.jboss.identity.federation.api.wstrust.SecurityTokenService;
import org.jboss.identity.federation.api.wstrust.WSTrustException;
import org.jboss.identity.federation.api.wstrust.WSTrustJAXBFactory;
import org.jboss.identity.federation.api.wstrust.WSTrustRequestHandler;
import org.jboss.identity.federation.bindings.config.STSType;
import org.jboss.identity.federation.bindings.jboss.wstrust.JBossSTSConfiguration;
import org.jboss.identity.federation.bindings.jboss.wstrust.SecurityActions;
import org.jboss.identity.federation.core.wstrust.BaseRequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.BaseRequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.RequestSecurityToken;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenCollection;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenResponse;
import org.jboss.identity.federation.core.wstrust.RequestSecurityTokenResponseCollection;

@WebServiceProvider(serviceName="JBossSTS", portName="JBossSTSPort", targetNamespace="http://org.jboss.identity.trust/sts", wsdlLocation="WEB-INF/wsdl/JBossSTS.wsdl")
@ServiceMode(value=Service.Mode.PAYLOAD)
public class JBossSTS
implements SecurityTokenService {
    @Resource
    protected WebServiceContext context;
    protected STSConfiguration config;

    public Source invoke(Source request) {
        BaseRequestSecurityToken baseRequest = WSTrustJAXBFactory.getInstance().parseRequestSecurityToken(request);
        if (baseRequest instanceof RequestSecurityToken) {
            return this.handleTokenRequest((RequestSecurityToken)baseRequest);
        }
        if (baseRequest instanceof RequestSecurityTokenCollection) {
            return this.handleTokenRequestCollection((RequestSecurityTokenCollection)baseRequest);
        }
        throw new WebServiceException("Invalid security token request");
    }

    protected Source handleTokenRequest(RequestSecurityToken request) {
        if (this.config == null) {
            this.config = this.getConfiguration();
        }
        WSTrustRequestHandler handler = this.config.getRequestHandler();
        String requestType = request.getRequestType().toString();
        try {
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Issue")) {
                return this.marshallResponse(handler.issue(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Renew")) {
                return this.marshallResponse(handler.renew(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Cancel")) {
                return this.marshallResponse(handler.cancel(request, this.context.getUserPrincipal()));
            }
            if (requestType.equals("http://docs.oasis-open.org/ws-sx/ws-trust/200512/Validate")) {
                return this.marshallResponse(handler.validate(request, this.context.getUserPrincipal()));
            }
            throw new WSTrustException("Invalid request type: " + requestType);
        }
        catch (WSTrustException we) {
            throw new WebServiceException(we.getMessage(), (Throwable)we);
        }
    }

    protected Source handleTokenRequestCollection(RequestSecurityTokenCollection requestCollection) {
        return null;
    }

    protected Source marshallResponse(RequestSecurityTokenResponse response) {
        RequestSecurityTokenResponseCollection responseCollection = new RequestSecurityTokenResponseCollection();
        responseCollection.addRequestSecurityTokenResponse(response);
        return WSTrustJAXBFactory.getInstance().marshallRequestSecurityTokenResponse((BaseRequestSecurityTokenResponse)responseCollection);
    }

    protected STSConfiguration getConfiguration() {
        URL configurationFile = SecurityActions.getContextClassLoader().getResource("jboss-sts.xml");
        if (configurationFile == null) {
            return new JBossSTSConfiguration();
        }
        try {
            InputStream stream = configurationFile.openStream();
            JAXBContext context = JAXBContext.newInstance((String)"org.jboss.identity.federation.bindings.config");
            JAXBElement element = (JAXBElement)context.createUnmarshaller().unmarshal(stream);
            STSType stsConfig = (STSType)element.getValue();
            return new JBossSTSConfiguration(stsConfig);
        }
        catch (Exception e) {
            throw new RuntimeException("Error parsing the configuration file", e);
        }
    }
}

