/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.jboss.wstrust;

import java.security.KeyPair;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;
import org.jboss.identity.federation.api.wstrust.STSConfiguration;
import org.jboss.identity.federation.api.wstrust.SecurityTokenProvider;
import org.jboss.identity.federation.api.wstrust.WSTrustRequestHandler;
import org.jboss.identity.federation.api.wstrust.WSTrustServiceFactory;
import org.jboss.identity.federation.bindings.config.KeyProviderType;
import org.jboss.identity.federation.bindings.config.STSType;
import org.jboss.identity.federation.bindings.config.ServiceProviderType;
import org.jboss.identity.federation.bindings.config.ServiceProvidersType;
import org.jboss.identity.federation.bindings.config.TokenProviderType;
import org.jboss.identity.federation.bindings.config.TokenProvidersType;
import org.jboss.identity.federation.bindings.interfaces.TrustKeyManager;
import org.jboss.identity.federation.bindings.jboss.wstrust.SecurityActions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSTSConfiguration
implements STSConfiguration {
    private final STSType delegate;
    private final Map<String, SecurityTokenProvider> tokenProviders = new HashMap<String, SecurityTokenProvider>();
    private final Map<String, ServiceProviderType> spMetadata = new HashMap<String, ServiceProviderType>();
    private final Map<String, Object> options = new HashMap<String, Object>();
    private TrustKeyManager trustManager;
    private WSTrustRequestHandler handler;

    public JBossSTSConfiguration() {
        this.delegate = new STSType();
        this.delegate.setSTSName("JBossSTS");
        this.delegate.setEncryptToken(false);
        this.delegate.setTokenTimeout(3600);
        this.delegate.setRequestHandler("org.jboss.identity.federation.api.wstrust.StandardRequestHandler");
    }

    public JBossSTSConfiguration(STSType config) {
        KeyProviderType keyProviderType;
        ServiceProvidersType serviceProviders;
        TokenProvidersType providers;
        this.delegate = config;
        if (this.delegate.getRequestHandler() == null) {
            this.delegate.setRequestHandler("org.jboss.identity.federation.api.wstrust.StandardRequestHandler");
        }
        if ((providers = this.delegate.getTokenProviders()) != null) {
            WSTrustServiceFactory serviceFactory = WSTrustServiceFactory.getInstance();
            for (TokenProviderType tokenProviderType : providers.getTokenProvider()) {
                this.tokenProviders.put(tokenProviderType.getTokenType(), serviceFactory.createTokenProvider(tokenProviderType.getProviderClass()));
            }
        }
        if ((serviceProviders = this.delegate.getServiceProviders()) != null) {
            for (ServiceProviderType serviceProviderType : serviceProviders.getServiceProvider()) {
                this.spMetadata.put(serviceProviderType.getEndpoint(), serviceProviderType);
            }
        }
        if ((keyProviderType = config.getKeyProvider()) != null) {
            String string = keyProviderType.getClassName();
            try {
                this.trustManager = (TrustKeyManager)SecurityActions.instantiateClass(string);
                this.trustManager.setAuthProperties(keyProviderType.getAuth());
                this.trustManager.setValidatingAlias(keyProviderType.getValidatingAlias());
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to construct the key manager", e);
            }
        }
    }

    public String getSTSName() {
        return this.delegate.getSTSName();
    }

    public boolean getEncryptIssuedToken() {
        return this.delegate.isEncryptToken();
    }

    public long getIssuedTokenTimeout() {
        return this.delegate.getTokenTimeout() * 1000;
    }

    public WSTrustRequestHandler getRequestHandler() {
        if (this.handler == null) {
            this.handler = WSTrustServiceFactory.getInstance().createRequestHandler(this.delegate.getRequestHandler(), (STSConfiguration)this);
        }
        return this.handler;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public SecurityTokenProvider getProviderForService(String serviceName) {
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return this.tokenProviders.get(provider.getTokenType());
        }
        return null;
    }

    public SecurityTokenProvider getProviderForTokenType(String tokenType) {
        return this.tokenProviders.get(tokenType);
    }

    public String getTokenTypeForService(String serviceName) {
        ServiceProviderType provider = this.spMetadata.get(serviceName);
        if (provider != null) {
            return provider.getTokenType();
        }
        return null;
    }

    public PublicKey getServiceProviderPublicKey(String serviceName) {
        PublicKey key = null;
        if (this.trustManager != null) {
            try {
                key = this.trustManager.getValidatingKey(serviceName);
            }
            catch (Exception e) {
                throw new RuntimeException("Error obtaining public key for service " + serviceName, e);
            }
        }
        return key;
    }

    public KeyPair getSTSKeyPair() {
        KeyPair keyPair = null;
        if (this.trustManager != null) {
            try {
                keyPair = this.trustManager.getSigningKeyPair();
            }
            catch (Exception e) {
                throw new RuntimeException("Error obtaining signing key pair", e);
            }
        }
        return keyPair;
    }
}

