/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.servlets;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.bindings.servlets.SecurityActions;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLConstants;
import org.jboss.identity.federation.core.saml.v2.factories.SAMLAssertionFactory;
import org.jboss.identity.federation.core.saml.v2.factories.SOAPFactory;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.saml.v2.util.JAXBElementMappingUtil;
import org.jboss.identity.federation.core.saml.v2.util.SOAPSAMLXACMLUtil;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Body;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Envelope;
import org.jboss.identity.federation.org.xmlsoap.schemas.soap.envelope.Fault;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.assertion.XACMLAuthzDecisionStatementType;
import org.jboss.identity.federation.saml.v2.profiles.xacml.protocol.XACMLAuthzDecisionQueryType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.security.xacml.core.JBossPDP;
import org.jboss.security.xacml.core.JBossRequestContext;
import org.jboss.security.xacml.core.model.context.RequestType;
import org.jboss.security.xacml.core.model.context.ResultType;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPSAMLXACMLServlet
extends HttpServlet {
    private static Logger log = Logger.getLogger(SOAPSAMLXACMLServlet.class);
    private static final long serialVersionUID = 1L;
    String policyConfigFileName = null;
    String issuerId = null;
    String issuer = null;
    boolean debug = false;

    public void init(ServletConfig config) throws ServletException {
        this.issuerId = config.getInitParameter("issuerID");
        if (this.issuerId == null) {
            this.issuerId = "issue-id:1";
        }
        this.issuer = config.getInitParameter("issuer");
        if (this.issuer == null) {
            this.issuer = "urn:jboss-identity";
        }
        this.policyConfigFileName = config.getInitParameter("policyConfigFileName");
        if (this.policyConfigFileName == null) {
            this.policyConfigFileName = "policyConfig.xml";
        }
        String debugStr = config.getInitParameter("debug");
        try {
            this.debug = Boolean.parseBoolean(debugStr);
        }
        catch (Exception ignore) {
            this.debug = false;
        }
        log.trace((Object)("Issuer=" + this.issuer + " :: issuerID=" + this.issuerId));
        log.trace((Object)("PolicyConfig File:" + this.policyConfigFileName));
        log.trace((Object)("Debug=" + this.debug));
        if (this.debug) {
            SecurityActions.setSystemProperty("jaxb.debug", "true");
        }
        super.init(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block27: {
            Object unmarshalledObject;
            JAXBElement jaxbRequestType = null;
            Envelope envelope = null;
            XACMLAuthzDecisionQueryType xacmlRequest = null;
            Document inputDoc = DocumentUtil.getDocument((InputStream)req.getInputStream());
            if (this.debug) {
                log.trace((Object)("Received SOAP:" + DocumentUtil.getDocumentAsString((Document)inputDoc)));
            }
            Unmarshaller un = SOAPSAMLXACMLUtil.getUnmarshaller();
            if (this.debug) {
                un.setEventHandler((ValidationEventHandler)new DefaultValidationEventHandler());
            }
            if ((unmarshalledObject = un.unmarshal(DocumentUtil.getNodeAsStream((Node)inputDoc))) instanceof JAXBElement) {
                JAXBElement jaxbElement = (JAXBElement)unmarshalledObject;
                Object element = jaxbElement.getValue();
                if (element instanceof Envelope) {
                    envelope = (Envelope)element;
                    Body soapBody = envelope.getBody();
                    Object samlRequest = soapBody.getAny().get(0);
                    if (samlRequest instanceof JAXBElement) {
                        jaxbRequestType = (JAXBElement)samlRequest;
                        jaxbRequestType = (JAXBElement)samlRequest;
                        xacmlRequest = (XACMLAuthzDecisionQueryType)jaxbRequestType.getValue();
                    } else if (samlRequest instanceof Element) {
                        Element elem = (Element)samlRequest;
                        xacmlRequest = SOAPSAMLXACMLUtil.getXACMLQueryType((Element)elem);
                    }
                } else if (element instanceof XACMLAuthzDecisionQueryType) {
                    xacmlRequest = (XACMLAuthzDecisionQueryType)element;
                }
            }
            if (xacmlRequest == null) {
                throw new IOException("XACML Request not parsed");
            }
            RequestType requestType = xacmlRequest.getRequest();
            JBossRequestContext requestContext = new JBossRequestContext();
            requestContext.setRequest(requestType);
            ResponseContext responseContext = this.getPDP().evaluate((RequestContext)requestContext);
            org.jboss.security.xacml.core.model.context.ResponseType responseType = new org.jboss.security.xacml.core.model.context.ResponseType();
            ResultType resultType = responseContext.getResult();
            responseType.getResult().add(resultType);
            XACMLAuthzDecisionStatementType xacmlStatement = SOAPSAMLXACMLUtil.createXACMLAuthzDecisionStatementType();
            xacmlStatement.setRequest(requestType);
            xacmlStatement.setResponse(responseType);
            String ID = IDGenerator.create((String)"ID_");
            SAML2Response saml2Response = new SAML2Response();
            IssuerInfoHolder issuerInfo = new IssuerInfoHolder(this.issuer);
            AssertionType assertion = SAMLAssertionFactory.getObjectFactory().createAssertionType();
            assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(xacmlStatement);
            assertion.setID(ID);
            assertion.setVersion(JBossSAMLConstants.VERSION_2_0.get());
            assertion.setIssuer(issuerInfo.getIssuer());
            JAXBElement jaxbResponse = JAXBElementMappingUtil.get((ResponseType)saml2Response.createResponseType(ID, issuerInfo, assertion));
            envelope = this.createEnvelope(jaxbResponse);
            Object var21_23 = null;
            resp.setContentType("text/xml;charset=utf-8");
            ServletOutputStream os = resp.getOutputStream();
            try {
                if (envelope == null) {
                    throw new IllegalStateException("SOAPEnvelope is null");
                }
                JAXBElement jaxbEnvelope = JAXBElementMappingUtil.get((Envelope)envelope);
                Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                marshaller.marshal((Object)jaxbEnvelope, (OutputStream)os);
            }
            catch (JAXBException e2) {
                this.log("marshalling exception", e2);
            }
            break block27;
            {
                catch (JAXBException e) {
                    log.error((Object)"Exception parsing SOAP:", (Throwable)e);
                    envelope = this.createEnvelope(this.createFault("Parsing Error:" + e.getMessage()));
                    Object var21_24 = null;
                    resp.setContentType("text/xml;charset=utf-8");
                    os = resp.getOutputStream();
                    try {
                        if (envelope == null) {
                            throw new IllegalStateException("SOAPEnvelope is null");
                        }
                        JAXBElement jaxbEnvelope = JAXBElementMappingUtil.get((Envelope)envelope);
                        Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                        marshaller.marshal((Object)jaxbEnvelope, (OutputStream)os);
                    }
                    catch (JAXBException e2) {
                        this.log("marshalling exception", e2);
                    }
                    break block27;
                }
                catch (PrivilegedActionException e) {
                    log.error((Object)"Exception getting PDP:", (Throwable)e);
                    envelope = this.createEnvelope(this.createFault("PDP Setup Error:" + e.getMessage()));
                    Object var21_25 = null;
                    resp.setContentType("text/xml;charset=utf-8");
                    os = resp.getOutputStream();
                    try {
                        if (envelope == null) {
                            throw new IllegalStateException("SOAPEnvelope is null");
                        }
                        JAXBElement jaxbEnvelope = JAXBElementMappingUtil.get((Envelope)envelope);
                        Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                        marshaller.marshal((Object)jaxbEnvelope, (OutputStream)os);
                    }
                    catch (JAXBException e2) {
                        this.log("marshalling exception", e2);
                    }
                    break block27;
                }
                catch (Exception e) {
                    log.error((Object)"Exception:", (Throwable)e);
                    envelope = this.createEnvelope(this.createFault("Server Error:" + e.getMessage()));
                    Object var21_26 = null;
                    resp.setContentType("text/xml;charset=utf-8");
                    os = resp.getOutputStream();
                    try {
                        if (envelope == null) {
                            throw new IllegalStateException("SOAPEnvelope is null");
                        }
                        JAXBElement jaxbEnvelope = JAXBElementMappingUtil.get((Envelope)envelope);
                        Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                        marshaller.marshal((Object)jaxbEnvelope, (OutputStream)os);
                    }
                    catch (JAXBException e2) {
                        this.log("marshalling exception", e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var21_27 = null;
                resp.setContentType("text/xml;charset=utf-8");
                os = resp.getOutputStream();
                try {
                    if (envelope == null) {
                        throw new IllegalStateException("SOAPEnvelope is null");
                    }
                    JAXBElement jaxbEnvelope = JAXBElementMappingUtil.get(envelope);
                    Marshaller marshaller = SOAPSAMLXACMLUtil.getMarshaller();
                    marshaller.marshal((Object)jaxbEnvelope, (OutputStream)os);
                }
                catch (JAXBException e2) {
                    this.log("marshalling exception", e2);
                }
                throw throwable;
            }
        }
    }

    private PolicyDecisionPoint getPDP() throws PrivilegedActionException {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        InputStream is = tcl.getResourceAsStream(this.policyConfigFileName);
        if (is == null) {
            throw new IllegalStateException(this.policyConfigFileName + " could not be located");
        }
        return new JBossPDP(is);
    }

    private Envelope createEnvelope(Object obj) {
        Envelope envelope = SOAPFactory.getObjectFactory().createEnvelope();
        Body body = SOAPFactory.getObjectFactory().createBody();
        body.getAny().add(obj);
        envelope.setBody(body);
        return envelope;
    }

    private JAXBElement<Fault> createFault(String msg) {
        Fault fault = SOAPFactory.getObjectFactory().createFault();
        fault.setFaultstring(msg);
        return SOAPFactory.getObjectFactory().createFault(fault);
    }
}

