/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.idp;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.bindings.config.EncryptionType;
import org.jboss.identity.federation.bindings.config.KeyProviderType;
import org.jboss.identity.federation.bindings.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.bindings.interfaces.TrustKeyManager;
import org.jboss.identity.federation.bindings.interfaces.TrustKeyProcessingException;
import org.jboss.identity.federation.bindings.tomcat.idp.IDPRedirectValve;
import org.jboss.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.jboss.identity.federation.bindings.util.RedirectBindingSignatureUtil;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.saml.v2.util.SignatureUtil;
import org.jboss.identity.federation.core.util.XMLEncryptionUtil;
import org.jboss.identity.federation.saml.v2.assertion.EncryptedElementType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class IDPRedirectWithSignatureValve
extends IDPRedirectValve {
    private static Logger log = Logger.getLogger(IDPRedirectWithSignatureValve.class);
    private boolean ignoreSignature = false;
    private TrustKeyManager keyManager;

    public void setIgnoreSignature(String val) {
        if (val != null && val.length() > 0) {
            this.ignoreSignature = Boolean.valueOf(val);
        }
    }

    public void start() throws LifecycleException {
        super.start();
        KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
        try {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            String keyManagerClassName = keyProvider.getClassName();
            if (keyManagerClassName == null) {
                throw new RuntimeException("KeyManager class name is null");
            }
            Class<?> clazz = tcl.loadClass(keyManagerClassName);
            this.keyManager = (TrustKeyManager)clazz.newInstance();
            this.keyManager.setAuthProperties(keyProvider.getAuth());
            this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
        }
        catch (Exception e) {
            log.error((Object)"Exception reading configuration:", (Throwable)e);
            throw new LifecycleException(e.getLocalizedMessage());
        }
        log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        PublicKey validatingKey;
        boolean result = super.validate(request);
        if (!result) {
            return result;
        }
        if (this.ignoreSignature) {
            log.trace((Object)"Since signature is to be ignored, validation returns");
            return true;
        }
        String queryString = request.getQueryString();
        byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL(queryString);
        if (sigValue == null) {
            return false;
        }
        String reqFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "SAMLRequest");
        String relayStateFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "RelayState");
        String sigAlgFromURL = RedirectBindingSignatureUtil.getTokenValue(queryString, "SigAlg");
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLRequest=").append(reqFromURL);
        if (relayStateFromURL != null && relayStateFromURL.length() > 0) {
            sb.append("&RelayState=").append(relayStateFromURL);
        }
        sb.append("&SigAlg=").append(sigAlgFromURL);
        try {
            validatingKey = this.keyManager.getValidatingKey(request.getRemoteAddr());
        }
        catch (TrustKeyConfigurationException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        catch (TrustKeyProcessingException e) {
            throw new GeneralSecurityException(e.getCause());
        }
        boolean isValid = SignatureUtil.validate((byte[])sb.toString().getBytes("UTF-8"), (byte[])sigValue, (PublicKey)validatingKey);
        return isValid;
    }

    protected String getDestination(String urlEncodedResponse, String urlEncodedRelayState) {
        try {
            PrivateKey signingKey = this.keyManager.getSigningKey();
            StringBuffer sb = new StringBuffer();
            String url = RedirectBindingSignatureUtil.getSAMLResponseURLWithSignature(urlEncodedResponse, urlEncodedRelayState, signingKey);
            sb.append("?").append(url);
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ResponseType getResponse(Request request, Principal userPrincipal) throws ParsingException, ConfigurationException, ProcessingException {
        SAML2Response saml2Response = new SAML2Response();
        ResponseType responseType = super.getResponse(request, userPrincipal);
        if (this.idpConfiguration.isEncrypt()) {
            String sp = responseType.getDestination();
            if (sp == null) {
                throw new IllegalStateException("Unable to handle encryption as SP url is null");
            }
            try {
                URL spurl = new URL(sp);
                PublicKey publicKey = this.keyManager.getValidatingKey(spurl.getHost());
                EncryptionType enc = this.idpConfiguration.getEncryption();
                if (enc == null) {
                    throw new IllegalStateException("EncryptionType not configured");
                }
                String encAlgo = enc.getEncAlgo().value();
                int keyLength = enc.getKeySize();
                SecretKey sk = this.keyManager.getEncryptionKey(spurl.getHost(), encAlgo, keyLength);
                StringWriter sw = new StringWriter();
                saml2Response.marshall(responseType, (Writer)sw);
                Document responseDoc = DocumentUtil.getDocument((Reader)new StringReader(sw.toString()));
                String assertionNS = JBossSAMLURIConstants.ASSERTION_NSURI.get();
                QName assertionQName = new QName(assertionNS, "EncryptedAssertion", "saml");
                Element encAssertion = XMLEncryptionUtil.encryptElementInDocument((Document)responseDoc, (PublicKey)publicKey, (SecretKey)sk, (int)keyLength, (QName)assertionQName, (boolean)true);
                EncryptedElementType eet = saml2Response.getEncryptedAssertion(DocumentUtil.getNodeAsStream((Node)encAssertion));
                responseType.getAssertionOrEncryptedAssertion().set(0, eet);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            catch (JAXBException e) {
                throw new ParsingException((Throwable)e);
            }
            catch (SAXException e) {
                throw new ParsingException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new ConfigurationException((Throwable)e);
            }
            catch (IOException e) {
                throw new ProcessingException((Throwable)e);
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new ConfigurationException((Throwable)e);
            }
            catch (TransformerException e) {
                throw new ProcessingException((Throwable)e);
            }
            catch (Exception e) {
                throw new ProcessingException((Throwable)e);
            }
        }
        if (log.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            try {
                saml2Response.marshall(responseType, (Writer)sw);
            }
            catch (JAXBException e) {
                log.trace((Object)e);
            }
            catch (SAXException e) {
                log.trace((Object)e);
            }
            log.trace((Object)("IDPRedirectValveWithSignature::Response=" + sw.toString()));
        }
        return responseType;
    }
}

