/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.idp;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.bindings.config.IDPType;
import org.jboss.identity.federation.bindings.interfaces.RoleGenerator;
import org.jboss.identity.federation.bindings.tomcat.TomcatRoleGenerator;
import org.jboss.identity.federation.bindings.tomcat.idp.IDPWebRequestUtil;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;

public class IDPWebBrowserSSOValve
extends ValveBase
implements Lifecycle {
    private static Logger log = Logger.getLogger(IDPWebBrowserSSOValve.class);
    protected IDPType idpConfiguration = null;
    private RoleGenerator rg = new TomcatRoleGenerator();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block25: {
            IDPWebRequestUtil webRequestUtil;
            String relayState;
            String referer;
            block26: {
                block24: {
                    Principal userPrincipal;
                    referer = request.getHeader("Referer");
                    relayState = request.getParameter("RelayState");
                    String samlMessage = request.getParameter("SAMLRequest");
                    boolean containsSAMLRequestMessage = samlMessage != null;
                    Session session = request.getSessionInternal();
                    if (containsSAMLRequestMessage) {
                        log.trace((Object)"Storing the SAMLRequest and RelayState in session");
                        session.setNote("SAMLRequest", (Object)samlMessage);
                        if (relayState != null) {
                            session.setNote("RelayState", (Object)relayState);
                        }
                    }
                    if ((userPrincipal = request.getPrincipal()) == null) {
                        try {
                            this.getNext().invoke(request, response);
                            Object var10_9 = null;
                        }
                        catch (Throwable throwable) {
                            Object var10_10 = null;
                            userPrincipal = request.getPrincipal();
                            referer = request.getHeader("Referer");
                            log.debug((Object)("Referer in finally block=" + referer));
                            throw throwable;
                        }
                        userPrincipal = request.getPrincipal();
                        referer = request.getHeader("Referer");
                        log.debug((Object)("Referer in finally block=" + referer));
                        {
                        }
                    }
                    webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration);
                    if (response.getStatus() == 403) {
                        try {
                            ResponseType errorResponseType = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL);
                            webRequestUtil.send(errorResponseType, relayState, response);
                        }
                        catch (ParsingException e) {
                            throw new ServletException((Throwable)e);
                        }
                        return;
                    }
                    if (userPrincipal == null) break block25;
                    samlMessage = (String)session.getNote("SAMLRequest");
                    relayState = (String)session.getNote("RelayState");
                    log.trace((Object)"Retrieved saml message and relay state from session");
                    log.trace((Object)("saml message=" + samlMessage + "::relay state=" + relayState));
                    session.removeNote("SAMLRequest");
                    session.removeNote("RelayState");
                    if (samlMessage == null) break block26;
                    RequestAbstractType requestAbstractType = null;
                    ResponseType responseType = null;
                    requestAbstractType = webRequestUtil.getSAMLRequest(samlMessage);
                    this.validate(request);
                    webRequestUtil.isTrusted(requestAbstractType.getIssuer().getValue());
                    List<String> roles = this.rg.generateRoles(userPrincipal);
                    AuthnRequestType art = (AuthnRequestType)requestAbstractType;
                    responseType = webRequestUtil.getResponse(art.getAssertionConsumerServiceURL(), userPrincipal, roles, this.identityURL, this.assertionValidity);
                    Object var15_22 = null;
                    try {
                        webRequestUtil.send(responseType, relayState, response);
                    }
                    catch (ParsingException e2) {
                        log.trace((Object)e2);
                    }
                    break block24;
                    {
                        catch (IssuerNotTrustedException e) {
                            log.trace((Object)e);
                            responseType = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL);
                            Object var15_23 = null;
                            try {
                                webRequestUtil.send(responseType, relayState, response);
                            }
                            catch (ParsingException e2) {
                                log.trace((Object)e2);
                            }
                            break block24;
                        }
                        catch (ParsingException e) {
                            log.trace((Object)e);
                            responseType = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL);
                            Object var15_24 = null;
                            try {
                                webRequestUtil.send(responseType, relayState, response);
                            }
                            catch (ParsingException e2) {
                                log.trace((Object)e2);
                            }
                            break block24;
                        }
                        catch (ConfigurationException e) {
                            log.trace((Object)e);
                            responseType = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL);
                            Object var15_25 = null;
                            try {
                                webRequestUtil.send(responseType, relayState, response);
                            }
                            catch (ParsingException e2) {
                                log.trace((Object)e2);
                            }
                            break block24;
                        }
                        catch (IssueInstantMissingException e) {
                            log.trace((Object)e);
                            responseType = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL);
                            Object var15_26 = null;
                            try {
                                webRequestUtil.send(responseType, relayState, response);
                            }
                            catch (ParsingException e2) {
                                log.trace((Object)e2);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_27 = null;
                        try {
                            webRequestUtil.send(responseType, relayState, response);
                        }
                        catch (ParsingException e2) {
                            log.trace((Object)e2);
                        }
                        throw throwable;
                    }
                }
                return;
            }
            log.error((Object)"No SAML Request Message");
            log.trace((Object)("Referer=" + referer));
            try {
                this.sendErrorResponseToSP(referer, response, relayState, webRequestUtil);
            }
            catch (ConfigurationException e) {
                log.trace((Object)e);
            }
        }
    }

    protected void sendErrorResponseToSP(String referrer, Response response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        ResponseType errorResponseType = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL);
        try {
            webRequestUtil.send(errorResponseType, relayState, response);
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException("IDPRedirectValve already Started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        String configFile = "/WEB-INF/jboss-idfed.xml";
        Context context = (Context)this.getContainer();
        InputStream is = context.getServletContext().getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        try {
            this.idpConfiguration = ValveUtil.getIDPConfiguration(is);
            this.identityURL = this.idpConfiguration.getIdentityURL();
            log.trace((Object)("Identity Provider URL=" + this.identityURL));
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("IDPRedirectValve NotStarted");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    protected boolean validate(Request request) {
        return request.getParameter("SAMLRequest") != null;
    }
}

