/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.idp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Principal;
import java.util.List;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.catalina.connector.Response;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.common.IDGenerator;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.bindings.config.IDPType;
import org.jboss.identity.federation.bindings.config.TrustType;
import org.jboss.identity.federation.bindings.util.HTTPRedirectUtil;
import org.jboss.identity.federation.bindings.util.PostBindingUtil;
import org.jboss.identity.federation.bindings.util.RedirectBindingUtil;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.IDPInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.holders.SPInfoHolder;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDPWebRequestUtil {
    private static Logger log = Logger.getLogger(IDPWebRequestUtil.class);
    private HttpServletRequest request;
    private boolean redirectProfile = false;
    private boolean postProfile = false;
    private IDPType idpConfiguration;

    public IDPWebRequestUtil(HttpServletRequest request, IDPType idp) {
        this.request = request;
        this.idpConfiguration = idp;
        this.hasSAMLRequestInRedirectProfile();
        this.hasSAMLRequestInPostProfile();
    }

    public boolean hasSAMLRequestInRedirectProfile() {
        if ("GET".equalsIgnoreCase(this.request.getMethod())) {
            this.redirectProfile = this.request.getParameter("SAMLRequest") != null;
        }
        return this.redirectProfile;
    }

    public boolean hasSAMLRequestInPostProfile() {
        if ("POST".equalsIgnoreCase(this.request.getMethod())) {
            this.postProfile = this.request.getParameter("SAMLRequest") != null;
        }
        return this.postProfile;
    }

    public RequestAbstractType getSAMLRequest(String samlMessage) throws ParsingException {
        InputStream is = null;
        SAML2Request saml2Request = new SAML2Request();
        if (this.redirectProfile) {
            is = RedirectBindingUtil.base64DeflateDecode(samlMessage);
        } else {
            byte[] samlBytes = PostBindingUtil.base64Decode(samlMessage);
            log.trace((Object)("SAMLRequest=" + new String(samlBytes)));
            is = new ByteArrayInputStream(samlBytes);
        }
        try {
            return saml2Request.getRequestType(is);
        }
        catch (JAXBException e) {
            throw new ParsingException((Throwable)e);
        }
        catch (SAXException e) {
            throw new ParsingException((Throwable)e);
        }
    }

    public ResponseType getResponse(String assertionConsumerURL, Principal userPrincipal, List<String> roles, String identityURL, long assertionValidity) throws ConfigurationException, IssueInstantMissingException {
        log.trace((Object)("AssertionConsumerURL=" + assertionConsumerURL + "::assertion validity=" + assertionValidity));
        ResponseType responseType = null;
        SAML2Response saml2Response = new SAML2Response();
        String id = IDGenerator.create((String)"ID_");
        IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
        issuerHolder.setStatusCode(JBossSAMLURIConstants.STATUS_SUCCESS.get());
        IDPInfoHolder idp = new IDPInfoHolder();
        idp.setNameIDFormatValue(userPrincipal.getName());
        idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
        SPInfoHolder sp = new SPInfoHolder();
        sp.setResponseDestinationURI(assertionConsumerURL);
        responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
        AssertionType assertion = (AssertionType)responseType.getAssertionOrEncryptedAssertion().get(0);
        AttributeStatementType attrStatement = saml2Response.createAttributeStatement(roles);
        assertion.getStatementOrAuthnStatementOrAuthzDecisionStatement().add(attrStatement);
        saml2Response.createTimedConditions(assertion, assertionValidity);
        if (log.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            try {
                saml2Response.marshall(responseType, (Writer)sw);
            }
            catch (JAXBException e) {
                log.trace((Object)e);
            }
            catch (SAXException e) {
                log.trace((Object)e);
            }
            log.trace((Object)("Response=" + sw.toString()));
        }
        return responseType;
    }

    public void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String issuerDomain = ValveUtil.getDomain(issuer);
            TrustType idpTrust = this.idpConfiguration.getTrust();
            if (idpTrust != null) {
                String domainsTrusted = idpTrust.getDomains();
                log.trace((Object)("Domains that IDP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                if (domainsTrusted.indexOf(issuerDomain) < 0) {
                    StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                    while (st != null && st.hasMoreTokens()) {
                        String uriBit = st.nextToken();
                        log.trace((Object)("Matching uri bit=" + uriBit));
                        if (issuerDomain.indexOf(uriBit) <= 0) continue;
                        log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                        return;
                    }
                    throw new IssuerNotTrustedException(issuer);
                }
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void send(ResponseType responseType, String relayState, Response response) throws IOException, ParsingException {
        SAML2Response saml2Response = new SAML2Response();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            saml2Response.marshall(responseType, (OutputStream)baos);
        }
        catch (SAXException e1) {
            throw new ParsingException((Throwable)e1);
        }
        catch (JAXBException e1) {
            throw new ParsingException((Throwable)e1);
        }
        if (this.redirectProfile) {
            String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode(baos.toByteArray());
            String destination = responseType.getDestination();
            log.trace((Object)("IDP:Destination=" + destination));
            if (relayState != null && relayState.length() > 0) {
                relayState = RedirectBindingUtil.urlEncode(relayState);
            }
            String finalDest = destination + this.getDestination(urlEncodedResponse, relayState);
            HTTPRedirectUtil.sendRedirectForResponder(finalDest, (HttpServletResponse)response);
        } else {
            response.recycle();
            String samlResponse = PostBindingUtil.base64Encode(baos.toString());
            PostBindingUtil.sendPost(responseType.getDestination(), samlResponse, relayState, (HttpServletResponse)response, false);
        }
    }

    public String getDestination(String urlEncodedResponse, String urlEncodedRelayState) {
        if (this.redirectProfile) {
            StringBuilder sb = new StringBuilder();
            sb.append("?SAMLResponse=").append(urlEncodedResponse);
            if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
                sb.append("&RelayState=").append(urlEncodedRelayState);
            }
            return sb.toString();
        }
        return null;
    }

    public ResponseType getErrorResponse(String responseURL, String status, String identityURL) {
        if (this.redirectProfile) {
            ResponseType responseType = null;
            SAML2Response saml2Response = new SAML2Response();
            String id = IDGenerator.create((String)"ID_");
            IssuerInfoHolder issuerHolder = new IssuerInfoHolder(identityURL);
            issuerHolder.setStatusCode(status);
            IDPInfoHolder idp = new IDPInfoHolder();
            idp.setNameIDFormatValue(null);
            idp.setNameIDFormat(JBossSAMLURIConstants.NAMEID_FORMAT_PERSISTENT.get());
            SPInfoHolder sp = new SPInfoHolder();
            sp.setResponseDestinationURI(responseURL);
            try {
                responseType = saml2Response.createResponseType(id, sp, idp, issuerHolder);
            }
            catch (ConfigurationException e1) {
                log.trace((Object)e1);
                responseType = saml2Response.createResponseType();
            }
            log.debug((Object)"ResponseType = ");
            if (log.isTraceEnabled()) {
                StringWriter sw = new StringWriter();
                try {
                    saml2Response.marshall(responseType, (Writer)sw);
                }
                catch (JAXBException e) {
                    log.trace((Object)e);
                }
                catch (SAXException e) {
                    log.trace((Object)e);
                }
                log.trace((Object)("Response=" + sw.toString()));
            }
            return responseType;
        }
        return null;
    }
}

