/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;

public class HTTPRedirectUtil {
    public static void sendRedirectForRequestor(String destination, HttpServletResponse response) throws IOException {
        HTTPRedirectUtil.common(destination, response);
        response.setHeader("Cache-Control", "no-cache, no-store");
        HTTPRedirectUtil.sendRedirect(response, destination);
    }

    public static void sendRedirectForResponder(String destination, HttpServletResponse response) throws IOException {
        HTTPRedirectUtil.common(destination, response);
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate,private");
        HTTPRedirectUtil.sendRedirect(response, destination);
    }

    private static void common(String destination, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Location", destination);
        response.setHeader("Pragma", "no-cache");
    }

    private static void sendRedirect(HttpServletResponse response, String destination) throws IOException {
        response.setStatus(302);
        response.sendRedirect(destination);
    }
}

