/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.util.Base64;

public class PostBindingUtil {
    private static Logger log = Logger.getLogger(PostBindingUtil.class);

    public static String base64Encode(String stringToEncode) throws IOException {
        return Base64.encodeBytes((byte[])stringToEncode.getBytes("UTF-8"), (int)8);
    }

    public static byte[] base64Decode(String encodedString) {
        return Base64.decode((String)encodedString);
    }

    public static void sendPost(String destination, String samlMessage, String relayState, HttpServletResponse response, boolean sendToIDP) throws IOException {
        String key = sendToIDP ? "SAMLRequest" : "SAMLResponse";
        response.setContentType("text/html");
        PrintWriter out = response.getWriter();
        PostBindingUtil.common(destination, response);
        StringBuilder builder = new StringBuilder();
        builder.append("<HTML>");
        builder.append("<HEAD>");
        if (sendToIDP) {
            builder.append("<TITLE>HTTP Post Binding To Identity Provider</TITLE>");
        } else {
            builder.append("<TITLE>HTTP Post Binding Response To Service Provider</TITLE>");
        }
        builder.append("</HEAD>");
        builder.append("<BODY Onload=\"document.forms[0].submit()\">");
        builder.append("<FORM METHOD=\"POST\" ACTION=\"" + destination + "\">");
        builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"" + key + "\"" + " VALUE=\"" + samlMessage + "\"/>");
        if (relayState != null && relayState.length() > 0) {
            builder.append("<INPUT TYPE=\"HIDDEN\" NAME=\"RelayState\" VALUE=\"" + relayState + "\"/>");
        }
        builder.append("</FORM></BODY></HTML>");
        String str = builder.toString();
        log.debug((Object)str);
        out.println(str);
        out.close();
    }

    private static void common(String destination, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Cache-Control", "no-cache, no-store");
    }
}

