/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import javax.xml.bind.JAXBException;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.api.saml.v2.response.SAML2Response;
import org.jboss.identity.federation.bindings.util.RedirectBindingUtil;
import org.jboss.identity.federation.core.saml.v2.util.SignatureUtil;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.xml.sax.SAXException;

public class RedirectBindingSignatureUtil {
    public static String getSAMLRequestURLWithSignature(AuthnRequestType authRequest, String relayState, PrivateKey signingKey) throws SAXException, JAXBException, IOException, GeneralSecurityException {
        SAML2Request saml2Request = new SAML2Request();
        StringWriter sw = new StringWriter();
        saml2Request.marshall((RequestAbstractType)authRequest, (Writer)sw);
        String urlEncodedRequest = RedirectBindingUtil.deflateBase64URLEncode(sw.toString());
        String urlEncodedRelayState = null;
        if (relayState != null && relayState.length() > 0) {
            urlEncodedRelayState = URLEncoder.encode(relayState, "UTF-8");
        }
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature(urlEncodedRequest, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getRequestRedirectURLWithSignature(urlEncodedRequest, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static String getSAMLResponseURLWithSignature(ResponseType responseType, String relayState, PrivateKey signingKey) throws JAXBException, SAXException, IOException, GeneralSecurityException {
        SAML2Response saml2Response = new SAML2Response();
        StringWriter sw = new StringWriter();
        saml2Response.marshall(responseType, (Writer)sw);
        String urlEncodedResponse = RedirectBindingUtil.deflateBase64URLEncode(sw.toString());
        String urlEncodedRelayState = null;
        if (relayState != null && relayState.length() > 0) {
            urlEncodedRelayState = URLEncoder.encode(relayState, "UTF-8");
        }
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature(urlEncodedResponse, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getResponseRedirectURLWithSignature(urlEncodedResponse, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static String getSAMLRequestURLWithSignature(String urlEncodedRequest, String urlEncodedRelayState, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature(urlEncodedRequest, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getRequestRedirectURLWithSignature(urlEncodedRequest, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static String getSAMLResponseURLWithSignature(String urlEncodedResponse, String urlEncodedRelayState, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        byte[] sigValue = RedirectBindingSignatureUtil.computeSignature(urlEncodedResponse, urlEncodedRelayState, signingKey);
        return RedirectBindingSignatureUtil.getResponseRedirectURLWithSignature(urlEncodedResponse, urlEncodedRelayState, sigValue, signingKey.getAlgorithm());
    }

    public static AuthnRequestType getRequestFromSignedURL(String signedURL) throws JAXBException, SAXException, IOException {
        String samlRequestTokenValue = RedirectBindingSignatureUtil.getTokenValue(signedURL, "SAMLRequest");
        SAML2Request saml2Request = new SAML2Request();
        return saml2Request.getAuthnRequestType(RedirectBindingUtil.urlBase64DeflateDecode(samlRequestTokenValue));
    }

    public static byte[] getSignatureValueFromSignedURL(String signedURL) throws IOException {
        String sigValueTokenValue = RedirectBindingSignatureUtil.getTokenValue(signedURL, "Signature");
        if (sigValueTokenValue == null) {
            throw new IllegalArgumentException("Signature Token is not present");
        }
        return RedirectBindingUtil.urlBase64Decode(sigValueTokenValue);
    }

    public static String getTokenValue(String queryString, String token) {
        return RedirectBindingSignatureUtil.getTokenValue(RedirectBindingSignatureUtil.getToken(queryString, token));
    }

    private static byte[] computeSignature(String urlEncodedRequest, String urlEncodedRelayState, PrivateKey signingKey) throws IOException, GeneralSecurityException {
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLRequest=").append(urlEncodedRequest);
        if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        String algo = signingKey.getAlgorithm();
        String sigAlg = SignatureUtil.getXMLSignatureAlgorithmURI((String)algo);
        sigAlg = URLEncoder.encode(sigAlg, "UTF-8");
        sb.append("&SigAlg=").append(sigAlg);
        byte[] sigValue = SignatureUtil.sign((String)sb.toString(), (PrivateKey)signingKey);
        return sigValue;
    }

    private static String getRequestRedirectURLWithSignature(String urlEncodedRequest, String urlEncodedRelayState, byte[] signature, String sigAlgo) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLRequest=").append(urlEncodedRequest);
        if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
            sb.append("&").append("RelayState=").append(urlEncodedRelayState);
        }
        String sigAlg = SignatureUtil.getXMLSignatureAlgorithmURI((String)sigAlgo);
        sigAlg = URLEncoder.encode(sigAlg, "UTF-8");
        sb.append("&").append("SigAlg=").append(sigAlg);
        String encodedSig = RedirectBindingUtil.base64URLEncode(signature);
        sb.append("&").append("Signature=").append(encodedSig);
        return sb.toString();
    }

    private static String getResponseRedirectURLWithSignature(String urlEncodedResponse, String urlEncodedRelayState, byte[] signature, String sigAlgo) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("SAMLResponse=").append(urlEncodedResponse);
        if (urlEncodedRelayState != null && urlEncodedRelayState.length() > 0) {
            sb.append("&").append("RelayState=").append(urlEncodedRelayState);
        }
        String sigAlg = SignatureUtil.getXMLSignatureAlgorithmURI((String)sigAlgo);
        sigAlg = URLEncoder.encode(sigAlg, "UTF-8");
        sb.append("&").append("SigAlg=").append(sigAlg);
        String encodedSig = RedirectBindingUtil.base64URLEncode(signature);
        sb.append("&").append("Signature=").append(encodedSig);
        return sb.toString();
    }

    private static String getToken(String queryString, String token) {
        if (queryString == null) {
            throw new IllegalArgumentException("queryString is null");
        }
        int start = queryString.indexOf(token = token + "=");
        if (start < 0) {
            return null;
        }
        int end = queryString.indexOf("&", start);
        if (end == -1) {
            return queryString.substring(start);
        }
        return queryString.substring(start, end);
    }

    private static String getTokenValue(String token) {
        if (token == null) {
            return token;
        }
        int eq = token.indexOf(61);
        if (eq == -1) {
            return token;
        }
        return token.substring(eq + 1);
    }
}

