/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.identity.federation.bindings.config.IDPType;
import org.jboss.identity.federation.bindings.config.SPType;
import org.jboss.identity.federation.bindings.util.SecurityActions;
import org.jboss.identity.federation.core.util.JAXBUtil;
import org.xml.sax.SAXException;

public class ValveUtil {
    public static InputStream getKeyStoreInputStream(String keyStore) {
        String userHome;
        File ksDir;
        InputStream is = null;
        try {
            File file = new File(keyStore);
            is = new FileInputStream(file);
        }
        catch (Exception e) {
            try {
                URL url = new URL(keyStore);
                is = url.openStream();
            }
            catch (Exception ex) {
                is = SecurityActions.getContextClassLoader().getResourceAsStream(keyStore);
            }
        }
        if (is == null && (ksDir = new File(userHome = SecurityActions.getSystemProperty("user.home", "") + "/jbid-keystore")).exists()) {
            try {
                is = new FileInputStream(new File(userHome + "/" + keyStore));
            }
            catch (FileNotFoundException e) {
                is = null;
            }
        }
        if (is == null) {
            throw new RuntimeException("Keystore not located");
        }
        return is;
    }

    public static IDPType getIDPConfiguration(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/jboss-identity-fed.xsd";
        String key = "org.jboss.identity.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        String pkgName = "org.jboss.identity.federation.bindings.config";
        Unmarshaller un = null;
        un = validate ? JAXBUtil.getValidatingUnmarshaller((String)pkgName, (String)schema) : JAXBUtil.getUnmarshaller((String)pkgName);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (IDPType)jaxbSp.getValue();
    }

    public static SPType getSPConfiguration(InputStream is) throws JAXBException, SAXException {
        if (is == null) {
            throw new IllegalArgumentException("inputstream is null");
        }
        String schema = "schema/config/jboss-identity-fed.xsd";
        String key = "org.jboss.identity.jaxb.schema.validation";
        boolean validate = Boolean.parseBoolean(SecurityActions.getSystemProperty(key, "false"));
        String pkgName = "org.jboss.identity.federation.bindings.config";
        Unmarshaller un = null;
        un = validate ? JAXBUtil.getValidatingUnmarshaller((String)pkgName, (String)schema) : JAXBUtil.getUnmarshaller((String)pkgName);
        JAXBElement jaxbSp = (JAXBElement)un.unmarshal(is);
        return (SPType)jaxbSp.getValue();
    }

    public static String getDomain(String domainURL) throws IOException {
        URL url = new URL(domainURL);
        return url.getHost();
    }
}

