/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.factories;

import java.util.UUID;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.saml.v2.assertion.AssertionType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeStatementType;
import org.jboss.identity.federation.saml.v2.assertion.AttributeType;
import org.jboss.identity.federation.saml.v2.assertion.NameIDType;
import org.jboss.identity.federation.saml.v2.assertion.ObjectFactory;
import org.jboss.identity.federation.saml.v2.assertion.SubjectConfirmationDataType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectConfirmationType;
import org.jboss.identity.federation.saml.v2.assertion.SubjectType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossSAMLBaseFactory {
    private static ObjectFactory assertionObjectFactory = new ObjectFactory();

    public static AssertionType createAssertion() {
        return assertionObjectFactory.createAssertionType();
    }

    public static AttributeStatementType createAttributeStatement() {
        return assertionObjectFactory.createAttributeStatementType();
    }

    public static AttributeType createAttributeForRole(String roleName) {
        AttributeType att = assertionObjectFactory.createAttributeType();
        att.setFriendlyName("role");
        att.setName("role");
        att.setNameFormat(JBossSAMLURIConstants.ATTRIBUTE_FORMAT_BASIC.get());
        att.getAttributeValue().add(roleName);
        return att;
    }

    public static AttributeStatementType createAttributeStatement(String attributeValue) {
        AttributeStatementType attribStatement = assertionObjectFactory.createAttributeStatementType();
        AttributeType att = assertionObjectFactory.createAttributeType();
        JAXBElement<Object> attValue = assertionObjectFactory.createAttributeValue(attributeValue);
        att.getAttributeValue().add(attValue);
        attribStatement.getAttributeOrEncryptedAttribute().add(att);
        return attribStatement;
    }

    public static NameIDType createNameID() {
        return assertionObjectFactory.createNameIDType();
    }

    public static JAXBElement<NameIDType> createNameID(NameIDType nameIDType) {
        return assertionObjectFactory.createNameID(nameIDType);
    }

    public static SubjectType createSubject() {
        SubjectType subjectType = assertionObjectFactory.createSubjectType();
        return subjectType;
    }

    public static SubjectConfirmationType createSubjectConfirmation(String method) {
        SubjectConfirmationType sct = assertionObjectFactory.createSubjectConfirmationType();
        sct.setMethod(method);
        return sct;
    }

    public static JAXBElement<SubjectConfirmationType> createSubjectConfirmation(SubjectConfirmationType sct) {
        return assertionObjectFactory.createSubjectConfirmation(sct);
    }

    public static SubjectConfirmationDataType createSubjectConfirmationData(String inResponseTo, String destinationURI, XMLGregorianCalendar issueInstant) {
        SubjectConfirmationDataType subjectConfirmationData = assertionObjectFactory.createSubjectConfirmationDataType();
        subjectConfirmationData.setInResponseTo(inResponseTo);
        subjectConfirmationData.setRecipient(destinationURI);
        subjectConfirmationData.setNotBefore(issueInstant);
        subjectConfirmationData.setNotOnOrAfter(issueInstant);
        return subjectConfirmationData;
    }

    public static String createUUID() {
        return UUID.randomUUID().toString();
    }

    public static ObjectFactory getObjectFactory() {
        return assertionObjectFactory;
    }

    public static NameIDType getIssuer(String issuerID) {
        NameIDType nid = assertionObjectFactory.createNameIDType();
        nid.setValue(issuerID);
        return nid;
    }
}

