/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.core.saml.v2.util;

import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;

public class XMLTimeUtil {
    public static XMLGregorianCalendar add(XMLGregorianCalendar value, long milis) throws ConfigurationException {
        Duration duration;
        XMLGregorianCalendar newVal = (XMLGregorianCalendar)value.clone();
        try {
            duration = DatatypeFactory.newInstance().newDuration(milis);
        }
        catch (DatatypeConfigurationException e) {
            throw new ConfigurationException(e);
        }
        newVal.add(duration);
        return newVal;
    }

    public static XMLGregorianCalendar subtract(XMLGregorianCalendar value, long milis) throws ConfigurationException {
        if (milis < 0L) {
            throw new IllegalArgumentException("milis should be a positive value");
        }
        return XMLTimeUtil.add(value, -1L * milis);
    }

    public static XMLGregorianCalendar getIssueInstant(String timezone) throws ConfigurationException {
        DatatypeFactory dtf;
        TimeZone tz = TimeZone.getTimeZone(timezone);
        try {
            dtf = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new ConfigurationException(e);
        }
        GregorianCalendar gc = new GregorianCalendar(tz);
        XMLGregorianCalendar xgc = dtf.newXMLGregorianCalendar(gc);
        return xgc;
    }

    public static XMLGregorianCalendar getIssueInstant() throws ConfigurationException {
        return XMLTimeUtil.getIssueInstant(TimeZone.getDefault().getID());
    }

    public static long inMilis(int valueInMins) {
        return valueInMins * 60 * 1000;
    }

    public static boolean isValid(XMLGregorianCalendar now, XMLGregorianCalendar notbefore, XMLGregorianCalendar notOnOrAfter) {
        if (notbefore == null) {
            throw new IllegalArgumentException("notbefore argument is null");
        }
        if (notOnOrAfter == null) {
            throw new IllegalArgumentException("notOnOrAfter argument is null");
        }
        int val = notbefore.compare(now);
        if (val == 2 || val == 1) {
            return false;
        }
        val = notOnOrAfter.compare(now);
        return val == 1;
    }
}

