/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.query;

import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentityType;
import org.jboss.identity.idm.api.SortOrder;
import org.jboss.identity.idm.api.UnsupportedCriterium;
import org.jboss.identity.idm.api.query.QueryBuilder;
import org.jboss.identity.idm.api.query.UnsupportedQueryCriterium;
import org.jboss.identity.idm.impl.api.IdentitySearchCriteriaImpl;
import org.jboss.identity.idm.impl.api.model.GroupId;
import org.jboss.identity.idm.impl.api.model.SimpleGroup;
import org.jboss.identity.idm.impl.api.model.SimpleUser;

public class AbstractQueryBuilder
implements QueryBuilder {
    protected IdentitySearchCriteriaImpl searchCriteria = new IdentitySearchCriteriaImpl();

    public QueryBuilder sort(SortOrder order) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.sort(order);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium(unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder sortAttributeName(String name) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.sortAttributeName(name);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium(unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder page(int firstResult, int maxResults) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.page(firstResult, maxResults);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium(unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder attributeValuesFilter(String attributeName, String[] attributeValue) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.attributeValuesFilter(attributeName, attributeValue);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium(unsupportedCriterium);
        }
        return this;
    }

    public QueryBuilder idFilter(String idFilter) throws UnsupportedQueryCriterium {
        try {
            this.searchCriteria.idFilter(idFilter);
        }
        catch (UnsupportedCriterium unsupportedCriterium) {
            throw new UnsupportedQueryCriterium(unsupportedCriterium);
        }
        return this;
    }

    protected void checkNotNullArgument(Object arg, String name) {
        if (arg == null) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    protected Group createGroupFromId(String id) {
        return new SimpleGroup(new GroupId(id));
    }

    protected IdentityType createIdentityTypeFromId(String id) {
        if (GroupId.validateId(id)) {
            GroupId groupId = new GroupId(id);
            return new SimpleGroup(groupId);
        }
        return new SimpleUser(id);
    }
}

