/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.cache;

import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.spi.cache.IdentityStoreCacheProvider;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.store.AttributeStore;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossCacheAttributeStoreWrapper
implements AttributeStore {
    private static Logger log = Logger.getLogger(JBossCacheAttributeStoreWrapper.class.getName());
    private final AttributeStore attributeStore;
    protected final IdentityStoreCacheProvider cacheSupport;
    private boolean reloadAttributesToCacheOnUpdate = true;

    public JBossCacheAttributeStoreWrapper(AttributeStore attributeStore, IdentityStoreCacheProvider cacheSupport) {
        this.cacheSupport = cacheSupport;
        this.attributeStore = attributeStore;
    }

    @Override
    public String getId() {
        return this.attributeStore.getId();
    }

    @Override
    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        return this.attributeStore.createIdentityStoreSession();
    }

    @Override
    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        return this.attributeStore.getSupportedAttributeNames(invocationContext, identityType);
    }

    @Override
    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) {
        return this.attributeStore.getAttributesMetaData(invocationContext, identityType);
    }

    @Override
    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        Map<String, IdentityObjectAttribute> results = this.cacheSupport.getAttributesFromCache(identity.getName(), identity.getIdentityType());
        if (results == null && (results = this.attributeStore.getAttributes(invocationContext, identity)) != null && results.size() > 0) {
            this.cacheSupport.putIntoCache(identity, results);
        }
        return results;
    }

    @Override
    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        Map<String, IdentityObjectAttribute> results = this.cacheSupport.getAttributesFromCache(identity.getName(), identity.getIdentityType());
        if (results != null && results.containsKey(name)) {
            return results.get(name);
        }
        return this.attributeStore.getAttribute(invocationContext, identity, name);
    }

    @Override
    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        Map<String, IdentityObjectAttribute> results;
        this.attributeStore.updateAttributes(invocationCtx, identity, attributes);
        this.cacheSupport.removeAttributesFromCache(identity);
        if (this.reloadAttributesToCacheOnUpdate && (results = this.attributeStore.getAttributes(invocationCtx, identity)) != null && results.size() > 0) {
            this.cacheSupport.putIntoCache(identity, results);
        }
    }

    @Override
    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        Map<String, IdentityObjectAttribute> results;
        this.attributeStore.addAttributes(invocationCtx, identity, attributes);
        this.cacheSupport.removeAttributesFromCache(identity);
        if (this.reloadAttributesToCacheOnUpdate && (results = this.attributeStore.getAttributes(invocationCtx, identity)) != null && results.size() > 0) {
            this.cacheSupport.putIntoCache(identity, results);
        }
    }

    @Override
    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributeNames) throws IdentityException {
        Map<String, IdentityObjectAttribute> results;
        this.attributeStore.removeAttributes(invocationCtx, identity, attributeNames);
        this.cacheSupport.removeAttributesFromCache(identity);
        if (this.reloadAttributesToCacheOnUpdate && (results = this.attributeStore.getAttributes(invocationCtx, identity)) != null && results.size() > 0) {
            this.cacheSupport.putIntoCache(identity, results);
        }
    }

    protected Logger getLog() {
        return log;
    }

    public String toString() {
        return "JBossCacheAttributeStoreWrapper (AttributeStore=" + this.attributeStore.getId() + ")";
    }
}

