/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.model.hibernate;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.MapKey;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObject;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipName;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="jbid_io_rel", uniqueConstraints={@UniqueConstraint(columnNames={"NAME", "TYPE", "FROM_IDENTITY", "TO_IDENTITY"})})
public class HibernateIdentityObjectRelationship
implements IdentityObjectRelationship {
    public static final String findIdentityObjectRelationshipsByType = "select r from HibernateIdentityObjectRelationship r where r.type.name like :typeName";
    public static final String findIdentityObjectRelationshipNamesByType = "select r.name from HibernateIdentityObjectRelationship r where r.type.name like :typeName";
    @Id
    @GeneratedValue
    private Long id;
    @ManyToOne
    @JoinColumn(nullable=true, unique=false, name="NAME")
    private HibernateIdentityObjectRelationshipName name;
    @ManyToOne
    @JoinColumn(nullable=false, name="TYPE")
    private HibernateIdentityObjectRelationshipType type;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="FROM_IDENTITY")
    private HibernateIdentityObject fromIdentityObject;
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(nullable=false, name="TO_IDENTITY")
    private HibernateIdentityObject toIdentityObject;
    @CollectionOfElements
    @JoinTable(name="jbid_io_rel_props", joinColumns={@JoinColumn(name="REALATIONSHIP_ID", nullable=false)})
    @MapKey(columns={@Column(name="prop_key", nullable=false)})
    @Column(name="PROPERTY")
    private Map<String, String> properties = new HashMap<String, String>();

    public HibernateIdentityObjectRelationship() {
    }

    public HibernateIdentityObjectRelationship(HibernateIdentityObjectRelationshipType type, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject) {
        this.type = type;
        this.fromIdentityObject = fromIdentityObject;
        fromIdentityObject.getFromRelationships().add(this);
        this.toIdentityObject = toIdentityObject;
        toIdentityObject.getToRelationships().add(this);
    }

    public HibernateIdentityObjectRelationship(HibernateIdentityObjectRelationshipType type, HibernateIdentityObject fromIdentityObject, HibernateIdentityObject toIdentityObject, HibernateIdentityObjectRelationshipName name) {
        this.type = type;
        this.fromIdentityObject = fromIdentityObject;
        fromIdentityObject.getFromRelationships().add(this);
        this.toIdentityObject = toIdentityObject;
        toIdentityObject.getToRelationships().add(this);
        this.name = name;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public IdentityObjectRelationshipType getType() {
        return this.type;
    }

    public void setType(HibernateIdentityObjectRelationshipType type) {
        this.type = type;
    }

    @Override
    public HibernateIdentityObject getFromIdentityObject() {
        return this.fromIdentityObject;
    }

    public void setFromIdentityObject(HibernateIdentityObject fromIdentityObject) {
        this.fromIdentityObject = fromIdentityObject;
    }

    @Override
    public HibernateIdentityObject getToIdentityObject() {
        return this.toIdentityObject;
    }

    public void setToIdentityObject(HibernateIdentityObject toIdentityObject) {
        this.toIdentityObject = toIdentityObject;
    }

    @Override
    public String getName() {
        if (this.name != null) {
            return this.name.getName();
        }
        return null;
    }

    public void setName(HibernateIdentityObjectRelationshipName name) {
        this.name = name;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }
}

