/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.repository;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.api.session.managers.RoleManagerImpl;
import org.jboss.identity.idm.impl.repository.AbstractIdentityStoreRepository;
import org.jboss.identity.idm.impl.repository.RepositoryIdentityStoreSessionImpl;
import org.jboss.identity.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.configuration.IdentityRepositoryConfigurationContext;
import org.jboss.identity.idm.spi.configuration.IdentityStoreConfigurationContext;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityObjectAttributeMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.jboss.identity.idm.spi.exception.OperationNotSupportedException;
import org.jboss.identity.idm.spi.model.IdentityObject;
import org.jboss.identity.idm.spi.model.IdentityObjectAttribute;
import org.jboss.identity.idm.spi.model.IdentityObjectCredential;
import org.jboss.identity.idm.spi.model.IdentityObjectCredentialType;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationship;
import org.jboss.identity.idm.spi.model.IdentityObjectRelationshipType;
import org.jboss.identity.idm.spi.model.IdentityObjectType;
import org.jboss.identity.idm.spi.search.IdentityObjectSearchCriteria;
import org.jboss.identity.idm.spi.store.AttributeStore;
import org.jboss.identity.idm.spi.store.FeaturesMetaData;
import org.jboss.identity.idm.spi.store.IdentityObjectSearchCriteriaType;
import org.jboss.identity.idm.spi.store.IdentityStore;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FallbackIdentityStoreRepository
extends AbstractIdentityStoreRepository {
    private final String id;
    private IdentityRepositoryConfigurationMetaData configurationMD;
    public static final String ALLOW_NOT_DEFINED_ATTRIBUTES = "allowNotDefinedAttributes";
    private FeaturesMetaData featuresMetaData;
    private boolean allowNotDefinedAttributes = false;
    private final Set<IdentityStore> configuredIdentityStores = new HashSet<IdentityStore>();

    public FallbackIdentityStoreRepository(String id) {
        this.id = id;
    }

    @Override
    public void bootstrap(IdentityRepositoryConfigurationContext configurationContext, Map<String, IdentityStore> bootstrappedIdentityStores, Map<String, AttributeStore> bootstrappedAttributeStores) throws IdentityException {
        String allowNotDefineAttributes;
        super.bootstrap(configurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
        if (this.getIdentityStoreMappings().size() > 0) {
            this.configuredIdentityStores.addAll(this.getIdentityStoreMappings().values());
        }
        this.configurationMD = configurationContext.getRepositoryConfigurationMetaData();
        String isId = this.configurationMD.getDefaultIdentityStoreId();
        if (isId != null && bootstrappedIdentityStores.keySet().contains(isId) && !this.getIdentityStoreMappings().keySet().contains(this.defaultIdentityStore.getId())) {
            this.configuredIdentityStores.add(this.defaultIdentityStore);
        }
        if ((allowNotDefineAttributes = this.configurationMD.getOptionSingleValue(ALLOW_NOT_DEFINED_ATTRIBUTES)) != null && allowNotDefineAttributes.equalsIgnoreCase("true")) {
            this.allowNotDefinedAttributes = true;
        }
        this.featuresMetaData = new FeaturesMetaData(){

            @Override
            public boolean isNamedRelationshipsSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isNamedRelationshipsSupported();
            }

            @Override
            public boolean isRelationshipPropertiesSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isRelationshipPropertiesSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipPropertiesSupported();
            }

            @Override
            public boolean isSearchCriteriaTypeSupported(IdentityObjectType identityObjectType, IdentityObjectSearchCriteriaType storeSearchConstraint) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isSearchCriteriaTypeSupported(identityObjectType, storeSearchConstraint);
            }

            @Override
            public Set<String> getSupportedIdentityObjectTypes() {
                HashSet<String> supportedIOTs = new HashSet<String>();
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    supportedIOTs.addAll(identityStore.getSupportedFeatures().getSupportedIdentityObjectTypes());
                }
                supportedIOTs.addAll(FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                return supportedIOTs;
            }

            @Override
            public boolean isIdentityObjectTypeSupported(IdentityObjectType identityObjectType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isIdentityObjectTypeSupported(identityObjectType);
            }

            @Override
            public boolean isRelationshipTypeSupported(IdentityObjectType fromType, IdentityObjectType toType, IdentityObjectRelationshipType relationshipType) throws IdentityException {
                IdentityStore toStore;
                IdentityStore fromStore = FallbackIdentityStoreRepository.this.resolveIdentityStore(fromType);
                if (fromStore == (toStore = FallbackIdentityStoreRepository.this.resolveIdentityStore(toType))) {
                    return fromStore.getSupportedFeatures().isRelationshipTypeSupported(fromType, toType, relationshipType);
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipTypeSupported(fromType, toType, relationshipType);
            }

            @Override
            public Set<String> getSupportedRelationshipTypes() {
                HashSet<String> supportedRelTypes = new HashSet<String>();
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    supportedRelTypes.addAll(identityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                }
                supportedRelTypes.addAll(FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().getSupportedRelationshipTypes());
                return supportedRelTypes;
            }

            @Override
            public boolean isCredentialSupported(IdentityObjectType identityObjectType, IdentityObjectCredentialType credentialType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(identityObjectType).getSupportedFeatures().isCredentialSupported(identityObjectType, credentialType);
            }

            @Override
            public boolean isIdentityObjectAddRemoveSupported(IdentityObjectType objectType) {
                return FallbackIdentityStoreRepository.this.resolveIdentityStore(objectType).getSupportedFeatures().isIdentityObjectAddRemoveSupported(objectType);
            }

            @Override
            public boolean isRelationshipNameAddRemoveSupported() {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isRelationshipNameAddRemoveSupported()) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRelationshipNameAddRemoveSupported();
            }

            @Override
            public boolean isRoleNameSearchCriteriaTypeSupported(IdentityObjectSearchCriteriaType constraint) {
                for (IdentityStore identityStore : FallbackIdentityStoreRepository.this.getIdentityStoreMappings().values()) {
                    if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || !identityStore.getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint)) continue;
                    return true;
                }
                return FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isNamedRelationshipsSupported() && FallbackIdentityStoreRepository.this.defaultIdentityStore.getSupportedFeatures().isRoleNameSearchCriteriaTypeSupported(constraint);
            }
        };
    }

    @Override
    public void bootstrap(IdentityStoreConfigurationContext configurationContext) throws IdentityException {
    }

    @Override
    public IdentityStoreSession createIdentityStoreSession() throws IdentityException {
        HashMap<String, IdentityStoreSession> sessions = new HashMap<String, IdentityStoreSession>();
        for (IdentityStore identityStore : this.identityStoreMappings.values()) {
            sessions.put(identityStore.getId(), identityStore.createIdentityStoreSession());
        }
        for (AttributeStore attributeStore : this.attributeStoreMappings.values()) {
            if (sessions.containsKey(attributeStore.getId())) continue;
            sessions.put(attributeStore.getId(), attributeStore.createIdentityStoreSession());
        }
        if (!sessions.containsKey(this.defaultAttributeStore.getId())) {
            sessions.put(this.defaultAttributeStore.getId(), this.defaultAttributeStore.createIdentityStoreSession());
        }
        if (!sessions.containsKey(this.defaultIdentityStore.getId())) {
            sessions.put(this.defaultIdentityStore.getId(), this.defaultIdentityStore.createIdentityStoreSession());
        }
        return new RepositoryIdentityStoreSessionImpl(sessions);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public FeaturesMetaData getSupportedFeatures() {
        return this.featuresMetaData;
    }

    IdentityStore resolveIdentityStore(IdentityObject io) {
        return this.resolveIdentityStore(io.getIdentityType());
    }

    IdentityStore resolveIdentityStore(IdentityObjectType iot) {
        IdentityStore ids = this.getIdentityStore(iot);
        if (ids == null) {
            ids = this.defaultIdentityStore;
        }
        return ids;
    }

    AttributeStore resolveAttributeStore(IdentityObjectType iot) {
        AttributeStore ads = this.getAttributeStore(iot);
        if (ads == null) {
            ads = this.defaultIdentityStore;
        }
        return ads;
    }

    IdentityStoreInvocationContext resolveInvocationContext(IdentityStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(AttributeStore targetStore, IdentityStoreInvocationContext invocationCtx) {
        return this.resolveInvocationContext(targetStore.getId(), invocationCtx);
    }

    IdentityStoreInvocationContext resolveInvocationContext(String id, IdentityStoreInvocationContext invocationCtx) {
        RepositoryIdentityStoreSessionImpl repoSession = (RepositoryIdentityStoreSessionImpl)invocationCtx.getIdentityStoreSession();
        IdentityStoreSession targetSession = repoSession.getIdentityStoreSession(id);
        return new SimpleIdentityStoreInvocationContext(targetSession, invocationCtx.getRealmId());
    }

    @Override
    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        return targetStore.createIdentityObject(targetCtx, name, identityObjectType);
    }

    @Override
    public IdentityObject createIdentityObject(IdentityStoreInvocationContext invocationCtx, String name, IdentityObjectType identityObjectType, Map<String, String[]> attributes) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        return targetStore.createIdentityObject(targetCtx, name, identityObjectType, attributes);
    }

    @Override
    public void removeIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObject identity) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        targetStore.removeIdentityObject(targetCtx, identity);
    }

    @Override
    public int getIdentityObjectsCount(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        return targetStore.getIdentityObjectsCount(targetCtx, identityType);
    }

    @Override
    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String name, IdentityObjectType identityObjectType) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationContext);
        return targetStore.findIdentityObject(targetCtx, name, identityObjectType);
    }

    @Override
    public IdentityObject findIdentityObject(IdentityStoreInvocationContext invocationContext, String id) throws IdentityException {
        for (IdentityStore identityStore : this.getIdentityStoreMappings().values()) {
            IdentityStoreInvocationContext targetCtx;
            IdentityObject io = identityStore.findIdentityObject(targetCtx = this.resolveInvocationContext(identityStore, invocationContext), id);
            if (io == null) continue;
            return io;
        }
        return this.defaultIdentityStore.findIdentityObject(invocationContext, id);
    }

    @Override
    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCtx, IdentityObjectType identityType, IdentityObjectSearchCriteria criteria) throws IdentityException {
        IdentityStore targetStore = this.resolveIdentityStore(identityType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationCtx);
        return targetStore.findIdentityObject(targetCtx, identityType, criteria);
    }

    @Override
    public Collection<IdentityObject> findIdentityObject(IdentityStoreInvocationContext invocationCxt, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, IdentityObjectSearchCriteria criteria) throws IdentityException {
        Collection<IdentityObject> objects;
        IdentityStore mappedStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext mappedCtx = this.resolveInvocationContext(mappedStore, invocationCxt);
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (mappedStore == this.defaultIdentityStore) {
            return this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, criteria);
        }
        Collection<Object> results = new LinkedList();
        if (relationshipType == null || !RoleManagerImpl.ROLE.getName().equals(relationshipType.getName()) || mappedStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
            results = mappedStore.findIdentityObject(mappedCtx, identity, relationshipType, parent, criteria);
        }
        IdentityObject defaultStoreIdentityObject = null;
        try {
            defaultStoreIdentityObject = this.defaultIdentityStore.findIdentityObject(defaultCtx, identity.getName(), identity.getIdentityType());
        }
        catch (IdentityException e) {
            return results;
        }
        if (defaultStoreIdentityObject != null && (objects = this.defaultIdentityStore.findIdentityObject(defaultCtx, identity, relationshipType, parent, criteria)) != null && objects.size() != 0) {
            results.addAll(objects);
            if (criteria != null && criteria.isPaged() && results instanceof List) {
                results = this.cutPageFromResults((List<IdentityObject>)results, criteria);
            }
            if (criteria != null && criteria.isSorted() && results instanceof List) {
                this.sortByName((List<IdentityObject>)results, criteria.isAscending());
            }
        }
        return results;
    }

    @Override
    public IdentityObjectRelationship createRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName, boolean createNames) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(fromIdentity);
        IdentityStore toStore = this.resolveIdentityStore(toIdentity);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCxt);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (fromStore == toStore && (relationshipName == null || relationshipName != null && fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
            return fromStore.createRelationship(toTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
        }
        return this.defaultIdentityStore.createRelationship(defaultTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName, createNames);
    }

    @Override
    public void removeRelationship(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType, String relationshipName) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(fromIdentity);
        IdentityStore toStore = this.resolveIdentityStore(toIdentity);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCxt);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (fromStore == toStore && (relationshipName == null || relationshipName != null && fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
            fromStore.removeRelationship(toTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName);
            return;
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
        }
        this.defaultIdentityStore.removeRelationship(defaultTargetCtx, fromIdentity, toIdentity, relationshipType, relationshipName);
    }

    @Override
    public void removeRelationships(IdentityStoreInvocationContext invocationCtx, IdentityObject identity1, IdentityObject identity2, boolean named) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(identity1);
        IdentityStore toStore = this.resolveIdentityStore(identity2);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCtx);
        if (fromStore == toStore) {
            fromStore.removeRelationships(toTargetCtx, identity1, identity2, named);
            return;
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, identity1)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, identity1.getName(), identity1.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, identity2)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, identity2.getName(), identity2.getIdentityType());
        }
        this.defaultIdentityStore.removeRelationships(defaultTargetCtx, identity1, identity2, named);
    }

    @Override
    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext invocationCxt, IdentityObject fromIdentity, IdentityObject toIdentity, IdentityObjectRelationshipType relationshipType) throws IdentityException {
        IdentityStore fromStore = this.resolveIdentityStore(fromIdentity);
        IdentityStore toStore = this.resolveIdentityStore(toIdentity);
        IdentityStoreInvocationContext toTargetCtx = this.resolveInvocationContext(toStore, invocationCxt);
        IdentityStoreInvocationContext defaultTargetCtx = this.resolveInvocationContext(this.defaultIdentityStore, invocationCxt);
        if (fromStore == toStore && (!RoleManagerImpl.ROLE.getName().equals(relationshipType.getName()) || fromStore.getSupportedFeatures().isNamedRelationshipsSupported())) {
            return fromStore.resolveRelationships(toTargetCtx, fromIdentity, toIdentity, relationshipType);
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, fromIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, fromIdentity.getName(), fromIdentity.getIdentityType());
        }
        if (!this.hasIdentityObject(defaultTargetCtx, this.defaultIdentityStore, toIdentity)) {
            this.defaultIdentityStore.createIdentityObject(defaultTargetCtx, toIdentity.getName(), toIdentity.getIdentityType());
        }
        return this.defaultIdentityStore.resolveRelationships(defaultTargetCtx, fromIdentity, toIdentity, relationshipType);
    }

    @Override
    public Set<IdentityObjectRelationship> resolveRelationships(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectRelationshipType relationshipType, boolean parent, boolean named, String name) throws IdentityException {
        HashSet<IdentityObjectRelationship> relationships = new HashSet<IdentityObjectRelationship>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().getSupportedRelationshipTypes().contains(relationshipType.getName()) || named && (!named || !identityStore.getSupportedFeatures().isNamedRelationshipsSupported())) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            relationships.addAll(identityStore.resolveRelationships(storeCtx, identity, relationshipType, parent, named, name));
        }
        return relationships;
    }

    @Override
    public String createRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.createRelationshipName(storeCtx, name);
        }
        return name;
    }

    @Override
    public String removeRelationshipName(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.removeRelationshipName(storeCtx, name);
        }
        return name;
    }

    @Override
    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        HashSet<String> results = new HashSet<String>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            results.addAll(identityStore.getRelationshipNames(storeCtx, criteria));
        }
        return results;
    }

    @Override
    public Set<String> getRelationshipNames(IdentityStoreInvocationContext ctx, IdentityObject identity, IdentityObjectSearchCriteria criteria) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
        if (toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
            return toStore.getRelationshipNames(targetCtx, identity, criteria);
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultIdentityStore, ctx);
        return this.defaultIdentityStore.getRelationshipNames(defaultCtx, identity, criteria);
    }

    @Override
    public Map<String, String> getRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name) throws IdentityException, OperationNotSupportedException {
        HashMap<String, String> results = new HashMap<String, String>();
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            IdentityStoreInvocationContext storeCtx;
            Map<String, String> props;
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported() || (props = identityStore.getRelationshipNameProperties(storeCtx = this.resolveInvocationContext(identityStore, ctx), name)) == null || props.keySet().size() <= 0) continue;
            results.putAll(props);
        }
        return results;
    }

    @Override
    public void setRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.setRelationshipNameProperties(storeCtx, name, properties);
        }
    }

    @Override
    public void removeRelationshipNameProperties(IdentityStoreInvocationContext ctx, String name, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        for (IdentityStore identityStore : this.configuredIdentityStores) {
            if (!identityStore.getSupportedFeatures().isNamedRelationshipsSupported()) continue;
            IdentityStoreInvocationContext storeCtx = this.resolveInvocationContext(identityStore, ctx);
            identityStore.removeRelationshipNameProperties(storeCtx, name, properties);
        }
    }

    @Override
    public Map<String, String> getRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore;
        IdentityStore fromStore = this.resolveIdentityStore(relationship.getFromIdentityObject());
        if (fromStore == (toStore = this.resolveIdentityStore(relationship.getToIdentityObject())) && toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
            return fromStore.getRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship);
        }
        return this.defaultIdentityStore.getRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship);
    }

    @Override
    public void setRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Map<String, String> properties) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore;
        IdentityStore fromStore = this.resolveIdentityStore(relationship.getFromIdentityObject());
        if (fromStore == (toStore = this.resolveIdentityStore(relationship.getToIdentityObject())) && toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
            fromStore.setRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship, properties);
            return;
        }
        this.defaultIdentityStore.setRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship, properties);
    }

    @Override
    public void removeRelationshipProperties(IdentityStoreInvocationContext ctx, IdentityObjectRelationship relationship, Set<String> properties) throws IdentityException, OperationNotSupportedException {
        IdentityStore toStore;
        IdentityStore fromStore = this.resolveIdentityStore(relationship.getFromIdentityObject());
        if (fromStore == (toStore = this.resolveIdentityStore(relationship.getToIdentityObject())) && toStore.getSupportedFeatures().isNamedRelationshipsSupported()) {
            fromStore.removeRelationshipProperties(this.resolveInvocationContext(fromStore, ctx), relationship, properties);
            return;
        }
        this.defaultIdentityStore.removeRelationshipProperties(this.resolveInvocationContext(this.defaultIdentityStore, ctx), relationship, properties);
    }

    @Override
    public boolean validateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        IdentityStore toStore = this.resolveIdentityStore(identityObject);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
        return toStore.validateCredential(targetCtx, identityObject, credential);
    }

    @Override
    public void updateCredential(IdentityStoreInvocationContext ctx, IdentityObject identityObject, IdentityObjectCredential credential) throws IdentityException {
        IdentityStore toStore = this.resolveIdentityStore(identityObject);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, ctx);
        toStore.updateCredential(targetCtx, identityObject, credential);
    }

    @Override
    public Set<String> getSupportedAttributeNames(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityType) throws IdentityException {
        IdentityStore toStore = this.resolveIdentityStore(identityType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
        Set<String> results = toStore.getSupportedAttributeNames(targetCtx, identityType);
        if (toStore != this.defaultAttributeStore) {
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
            results.addAll(this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identityType));
        }
        return results;
    }

    @Override
    public Map<String, IdentityObjectAttributeMetaData> getAttributesMetaData(IdentityStoreInvocationContext invocationContext, IdentityObjectType identityObjectType) {
        IdentityStoreInvocationContext defaultCtx;
        Map<String, IdentityObjectAttributeMetaData> defaultMDMap;
        IdentityStore targetStore = this.resolveIdentityStore(identityObjectType);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(targetStore, invocationContext);
        HashMap<String, IdentityObjectAttributeMetaData> mdMap = new HashMap<String, IdentityObjectAttributeMetaData>();
        mdMap.putAll(targetStore.getAttributesMetaData(targetCtx, identityObjectType));
        if (targetStore != this.defaultAttributeStore && (defaultMDMap = this.defaultAttributeStore.getAttributesMetaData(defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext), identityObjectType)) != null) {
            for (Map.Entry<String, IdentityObjectAttributeMetaData> entry : defaultMDMap.entrySet()) {
                if (mdMap.containsKey(entry.getKey())) continue;
                mdMap.put(entry.getKey(), entry.getValue());
            }
        }
        return mdMap;
    }

    @Override
    public IdentityObjectAttribute getAttribute(IdentityStoreInvocationContext invocationContext, IdentityObject identity, String name) throws IdentityException {
        IdentityStoreInvocationContext targetCtx;
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityObjectAttribute result = toStore.getAttribute(targetCtx = this.resolveInvocationContext(toStore, invocationContext), identity, name);
        if (result == null && toStore != this.defaultAttributeStore) {
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
            result = this.defaultAttributeStore.getAttribute(defaultCtx, identity, name);
        }
        return result;
    }

    @Override
    public Map<String, IdentityObjectAttribute> getAttributes(IdentityStoreInvocationContext invocationContext, IdentityObject identity) throws IdentityException {
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationContext);
        Map<String, IdentityObjectAttribute> results = toStore.getAttributes(targetCtx, identity);
        if (toStore != this.defaultAttributeStore) {
            IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationContext);
            Map<String, IdentityObjectAttribute> defaultAttrs = this.defaultAttributeStore.getAttributes(defaultCtx, identity);
            for (Map.Entry<String, IdentityObjectAttribute> entry : defaultAttrs.entrySet()) {
                if (results.keySet().contains(entry.getKey())) continue;
                results.put(entry.getKey(), entry.getValue());
            }
        }
        return results;
    }

    @Override
    public void updateAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        ArrayList<IdentityObjectAttribute> filteredAttrs = new ArrayList<IdentityObjectAttribute>();
        ArrayList<IdentityObjectAttribute> leftAttrs = new ArrayList<IdentityObjectAttribute>();
        IdentityObjectAttribute[] attributesToAdd = null;
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        if (toStore != this.defaultAttributeStore) {
            Set<String> supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : attributes) {
                if (supportedAttrs.contains(entry.getName())) {
                    filteredAttrs.add(entry);
                    continue;
                }
                leftAttrs.add(entry);
            }
            toStore.updateAttributes(targetCtx, identity, filteredAttrs.toArray(new IdentityObjectAttribute[filteredAttrs.size()]));
            attributesToAdd = leftAttrs.toArray(new IdentityObjectAttribute[leftAttrs.size()]);
        } else {
            attributesToAdd = attributes;
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
        if (this.isAllowNotDefinedAttributes()) {
            this.defaultAttributeStore.updateAttributes(defaultCtx, identity, attributesToAdd);
        } else {
            Set<String> supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : leftAttrs) {
                if (supportedAttrs.contains(entry.getName())) continue;
                throw new IdentityException("Cannot update not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + entry.getName());
            }
            this.defaultAttributeStore.updateAttributes(defaultCtx, identity, attributesToAdd);
        }
    }

    @Override
    public void addAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, IdentityObjectAttribute[] attributes) throws IdentityException {
        ArrayList<IdentityObjectAttribute> filteredAttrs = new ArrayList<IdentityObjectAttribute>();
        ArrayList<IdentityObjectAttribute> leftAttrs = new ArrayList<IdentityObjectAttribute>();
        IdentityObjectAttribute[] attributesToAdd = null;
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        if (toStore != this.defaultAttributeStore) {
            Set<String> supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : attributes) {
                if (supportedAttrs.contains(entry.getName())) {
                    filteredAttrs.add(entry);
                    continue;
                }
                leftAttrs.add(entry);
            }
            toStore.addAttributes(targetCtx, identity, filteredAttrs.toArray(new IdentityObjectAttribute[filteredAttrs.size()]));
            attributesToAdd = leftAttrs.toArray(new IdentityObjectAttribute[leftAttrs.size()]);
        } else {
            attributesToAdd = attributes;
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
        if (this.isAllowNotDefinedAttributes()) {
            this.defaultAttributeStore.addAttributes(defaultCtx, identity, attributesToAdd);
        } else {
            Set<String> supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
            for (IdentityObjectAttribute entry : attributesToAdd) {
                if (supportedAttrs.contains(entry.getName())) continue;
                throw new IdentityException("Cannot add not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + entry.getName());
            }
            this.defaultAttributeStore.addAttributes(defaultCtx, identity, attributesToAdd);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeAttributes(IdentityStoreInvocationContext invocationCtx, IdentityObject identity, String[] attributes) throws IdentityException {
        LinkedList<String> filteredAttrs = new LinkedList<String>();
        List<Object> leftAttrs = new LinkedList();
        IdentityStore toStore = this.resolveIdentityStore(identity);
        IdentityStoreInvocationContext targetCtx = this.resolveInvocationContext(toStore, invocationCtx);
        if (toStore != this.defaultAttributeStore) {
            void var11_13;
            Set<String> supportedAttrs = toStore.getSupportedAttributeNames(targetCtx, identity.getIdentityType());
            String[] arr$ = attributes;
            int len$ = arr$.length;
            boolean bl = false;
            while (var11_13 < len$) {
                String name = arr$[var11_13];
                if (supportedAttrs.contains(name)) {
                    filteredAttrs.add(name);
                } else {
                    leftAttrs.add(name);
                }
                ++var11_13;
            }
            toStore.removeAttributes(targetCtx, identity, filteredAttrs.toArray(new String[filteredAttrs.size()]));
        } else {
            leftAttrs = Arrays.asList(attributes);
        }
        IdentityStoreInvocationContext defaultCtx = this.resolveInvocationContext(this.defaultAttributeStore, invocationCtx);
        if (this.isAllowNotDefinedAttributes()) {
            this.defaultAttributeStore.removeAttributes(defaultCtx, identity, leftAttrs.toArray(new String[leftAttrs.size()]));
        } else {
            Set<String> supportedAttrs = this.defaultAttributeStore.getSupportedAttributeNames(defaultCtx, identity.getIdentityType());
            for (String string : leftAttrs) {
                if (supportedAttrs.contains(string)) continue;
                throw new IdentityException("Cannot remove not defined attribute. Use 'allowNotDefinedAttributes' option to pass such attributes to default IdentityStore anyway.Attribute name: " + string);
            }
            this.defaultAttributeStore.removeAttributes(defaultCtx, identity, leftAttrs.toArray(new String[leftAttrs.size()]));
        }
    }

    private void sortByName(List<IdentityObject> objects, final boolean ascending) {
        Collections.sort(objects, new Comparator<IdentityObject>(){

            @Override
            public int compare(IdentityObject o1, IdentityObject o2) {
                if (ascending) {
                    return o1.getName().compareTo(o2.getName());
                }
                return o2.getName().compareTo(o1.getName());
            }
        });
    }

    private List<IdentityObject> cutPageFromResults(List<IdentityObject> objects, IdentityObjectSearchCriteria criteria) {
        LinkedList<IdentityObject> results = new LinkedList<IdentityObject>();
        for (int i = criteria.getFirstResult(); i < criteria.getFirstResult() + criteria.getMaxResults(); ++i) {
            if (i >= objects.size()) continue;
            results.add(objects.get(i));
        }
        return results;
    }

    public boolean isAllowNotDefinedAttributes() {
        return this.allowNotDefinedAttributes;
    }
}

