/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.integration.jboss5;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.sql.DataSource;

public class SQLPopulator {
    private static Logger logger = Logger.getLogger(SQLPopulator.class.getName());
    private String SQLScript;
    private String exitSQL;
    private String datasource;

    public SQLPopulator(String datasource, String SQLScript, String exitSQL) {
        this.SQLScript = SQLScript;
        this.exitSQL = exitSQL;
        this.datasource = datasource;
    }

    public void populateSchema() throws Exception {
        String[] list;
        DataSource ds = (DataSource)new InitialContext().lookup(this.datasource);
        Connection conn = ds.getConnection();
        boolean load = false;
        Statement st = conn.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery(this.exitSQL.trim());
            rs.close();
        }
        catch (SQLException e) {
            load = true;
        }
        st.close();
        if (!load) {
            logger.info(this.datasource + " datasource is already initialized");
            return;
        }
        logger.info("Initializing " + this.datasource + " from listed sql files");
        for (String sql : list = this.SQLScript.split(",")) {
            this.executeSql(sql.trim(), conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSql(String resource, Connection conn) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        try {
            String[] statements;
            String sql = new String(this.readStream(url.openStream()), "UTF-8");
            sql = sql.replaceAll("(?m)^--([^\n]+)?$", "");
            for (String statement : statements = sql.split(";")) {
                if (statement == null || "".equals(statement.trim())) continue;
                Statement sqlStatement = conn.createStatement();
                try {
                    sqlStatement.executeUpdate(statement);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Exception in executing :" + statement, e);
                }
                finally {
                    sqlStatement.close();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception in populating :" + resource, e);
        }
    }

    private byte[] readStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg passed in method call.");
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int readCount = 0;
        try {
            while ((readCount = stream.read(buffer)) != -1) {
                outBuffer.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading stream.", e);
        }
        return outBuffer.toByteArray();
    }
}

