/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.api.session;

import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.jboss.identity.idm.api.AttributesManager;
import org.jboss.identity.idm.api.Group;
import org.jboss.identity.idm.api.IdentitySession;
import org.jboss.identity.idm.api.PersistenceManager;
import org.jboss.identity.idm.api.RelationshipManager;
import org.jboss.identity.idm.api.Role;
import org.jboss.identity.idm.api.RoleManager;
import org.jboss.identity.idm.api.Transaction;
import org.jboss.identity.idm.api.User;
import org.jboss.identity.idm.api.query.GroupQuery;
import org.jboss.identity.idm.api.query.GroupQueryBuilder;
import org.jboss.identity.idm.api.query.QueryException;
import org.jboss.identity.idm.api.query.RoleQuery;
import org.jboss.identity.idm.api.query.RoleQueryBuilder;
import org.jboss.identity.idm.api.query.UserQuery;
import org.jboss.identity.idm.api.query.UserQueryBuilder;
import org.jboss.identity.idm.common.exception.FeatureNotSupportedException;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.api.query.GroupQueryBuilderImpl;
import org.jboss.identity.idm.impl.api.query.GroupQueryExecutorImpl;
import org.jboss.identity.idm.impl.api.query.GroupQueryImpl;
import org.jboss.identity.idm.impl.api.query.RoleQueryBuilderImpl;
import org.jboss.identity.idm.impl.api.query.RoleQueryExecutorImpl;
import org.jboss.identity.idm.impl.api.query.RoleQueryImpl;
import org.jboss.identity.idm.impl.api.query.UserQueryBuilderImpl;
import org.jboss.identity.idm.impl.api.query.UserQueryExecutorImpl;
import org.jboss.identity.idm.impl.api.query.UserQueryImpl;
import org.jboss.identity.idm.impl.api.session.SimpleTransactionImpl;
import org.jboss.identity.idm.impl.api.session.context.IdentitySessionContext;
import org.jboss.identity.idm.impl.api.session.context.IdentitySessionContextImpl;
import org.jboss.identity.idm.impl.api.session.context.IdentityStoreInvocationContextResolver;
import org.jboss.identity.idm.impl.api.session.managers.AttributesManagerImpl;
import org.jboss.identity.idm.impl.api.session.managers.PersistenceManagerImpl;
import org.jboss.identity.idm.impl.api.session.managers.RelationshipManagerImpl;
import org.jboss.identity.idm.impl.api.session.managers.RoleManagerImpl;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.jboss.identity.idm.impl.store.SimpleIdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.repository.IdentityStoreRepository;
import org.jboss.identity.idm.spi.store.IdentityStoreInvocationContext;
import org.jboss.identity.idm.spi.store.IdentityStoreSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentitySessionImpl
implements IdentitySession,
Serializable {
    private static final long serialVersionUID = 7615238887627699243L;
    private final String realmName;
    private final IdentitySessionContext sessionContext;
    private final PersistenceManager persistenceManager;
    private final RelationshipManager relationshipManager;
    private final AttributesManager profileManager;
    private final RoleManager roleManager;
    private final UserQueryExecutorImpl userQueryExecutor;
    private final GroupQueryExecutorImpl groupQueryExecutor;
    private final RoleQueryExecutorImpl roleQueryExecutor;

    public IdentitySessionContext getSessionContext() {
        return this.sessionContext;
    }

    public IdentitySessionImpl(String realmName, IdentityStoreRepository repository, IdentityObjectTypeMapper typeMapper) throws IdentityException {
        this.realmName = realmName;
        IdentityStoreSession storeSession = repository.createIdentityStoreSession();
        final SimpleIdentityStoreInvocationContext invocationCtx = new SimpleIdentityStoreInvocationContext(storeSession, realmName);
        IdentityStoreInvocationContextResolver resolver = new IdentityStoreInvocationContextResolver(){

            public IdentityStoreInvocationContext resolveInvocationContext() {
                return invocationCtx;
            }
        };
        this.sessionContext = new IdentitySessionContextImpl(repository, typeMapper, resolver);
        this.persistenceManager = new PersistenceManagerImpl(this);
        this.relationshipManager = new RelationshipManagerImpl(this);
        this.profileManager = new AttributesManagerImpl(this);
        this.roleManager = new RoleManagerImpl(this);
        this.userQueryExecutor = new UserQueryExecutorImpl(this);
        this.groupQueryExecutor = new GroupQueryExecutorImpl(this);
        this.roleQueryExecutor = new RoleQueryExecutorImpl(this);
    }

    @Override
    public String getRealmName() {
        return this.realmName;
    }

    @Override
    public void close() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().close();
    }

    @Override
    public void save() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().save();
    }

    @Override
    public void clear() throws IdentityException {
        this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().clear();
    }

    @Override
    public boolean isOpen() {
        return this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession().isOpen();
    }

    @Override
    public Transaction beginTransaction() {
        SimpleTransactionImpl transaction = new SimpleTransactionImpl(this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession());
        transaction.start();
        return transaction;
    }

    @Override
    public Transaction getTransaction() {
        return new SimpleTransactionImpl(this.sessionContext.resolveStoreInvocationContext().getIdentityStoreSession());
    }

    @Override
    public PersistenceManager getPersistenceManager() {
        return this.persistenceManager;
    }

    @Override
    public RelationshipManager getRelationshipManager() {
        return this.relationshipManager;
    }

    @Override
    public AttributesManager getAttributesManager() {
        return this.profileManager;
    }

    @Override
    public RoleManager getRoleManager() throws FeatureNotSupportedException {
        if (!this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isNamedRelationshipsSupported()) {
            throw new FeatureNotSupportedException("Role management not supported by underlaying configured identity stores");
        }
        return this.roleManager;
    }

    @Override
    public UserQueryBuilder createUserQueryBuilder() {
        return new UserQueryBuilderImpl();
    }

    @Override
    public GroupQueryBuilder createGroupQueryBuilder() {
        return new GroupQueryBuilderImpl();
    }

    @Override
    public RoleQueryBuilder createRoleQueryBuilder() throws FeatureNotSupportedException {
        if (!this.getSessionContext().getIdentityStoreRepository().getSupportedFeatures().isNamedRelationshipsSupported()) {
            throw new FeatureNotSupportedException("Role management not supported by underlaying configured identity stores");
        }
        return new RoleQueryBuilderImpl();
    }

    @Override
    public Collection<User> execute(UserQuery userQuery) throws QueryException {
        return this.userQueryExecutor.execute((UserQueryImpl)userQuery);
    }

    @Override
    public User uniqueResult(UserQuery userQuery) throws QueryException {
        return this.userQueryExecutor.uniqueResult((UserQueryImpl)userQuery);
    }

    @Override
    public List<User> list(UserQuery userQuery) throws QueryException {
        return this.userQueryExecutor.list((UserQueryImpl)userQuery);
    }

    @Override
    public Collection<Group> execute(GroupQuery groupQuery) throws QueryException {
        return this.groupQueryExecutor.execute((GroupQueryImpl)groupQuery);
    }

    @Override
    public Group uniqueResult(GroupQuery groupQuery) throws QueryException {
        return this.groupQueryExecutor.uniqueResult((GroupQueryImpl)groupQuery);
    }

    @Override
    public List<Group> list(GroupQuery groupQuery) throws QueryException {
        return this.groupQueryExecutor.list((GroupQueryImpl)groupQuery);
    }

    @Override
    public Collection<Role> execute(RoleQuery roleQuery) throws QueryException {
        return this.roleQueryExecutor.execute((RoleQueryImpl)roleQuery);
    }

    @Override
    public Role uniqueResult(RoleQuery roleQuery) throws QueryException {
        return this.roleQueryExecutor.uniqueResult((RoleQueryImpl)roleQuery);
    }

    @Override
    public List<Role> list(RoleQuery roleQuery) throws QueryException {
        return this.roleQueryExecutor.list((RoleQueryImpl)roleQuery);
    }
}

