/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.configuration;

import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.api.cfg.IdentityConfiguration;
import org.jboss.identity.idm.api.cfg.IdentityConfigurationRegistry;
import org.jboss.identity.idm.common.exception.IdentityConfigurationException;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.impl.api.IdentitySessionFactoryImpl;
import org.jboss.identity.idm.impl.api.session.mapper.DirectIdentityObjectTypeMapperImpl;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapper;
import org.jboss.identity.idm.impl.api.session.mapper.IdentityObjectTypeMapperImpl;
import org.jboss.identity.idm.impl.configuration.IdentityConfigurationContextImpl;
import org.jboss.identity.idm.impl.configuration.IdentityRepositoryConfigurationContextImpl;
import org.jboss.identity.idm.impl.configuration.IdentitySessionConfigurationContext;
import org.jboss.identity.idm.impl.configuration.IdentityStoreConfigurationContextImpl;
import org.jboss.identity.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.jboss.identity.idm.impl.helper.CopyOnWriteRegistry;
import org.jboss.identity.idm.spi.configuration.IdentityConfigurationContextRegistry;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityRepositoryConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.RealmConfigurationMetaData;
import org.jboss.identity.idm.spi.repository.IdentityStoreRepository;
import org.jboss.identity.idm.spi.store.AttributeStore;
import org.jboss.identity.idm.spi.store.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityConfigurationImpl
implements IdentityConfiguration,
IdentityConfigurationRegistry,
IdentityConfigurationContextRegistry,
Serializable {
    private static final Logger log = Logger.getLogger(IdentityConfigurationImpl.class.getName());
    private IdentityConfigurationMetaData configMD;
    private final CopyOnWriteRegistry registry = new CopyOnWriteRegistry();

    @Override
    public void register(Object object, String name) throws IdentityException {
        if (!this.registry.register(name, object)) {
            throw new IdentityException("Cannot register object in IdentityContext with name: " + name);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("registering object: " + name + " ; " + object.getClass());
        }
    }

    @Override
    public void unregister(String name) {
        if (this.registry.unregister(name) == null) {
            log.info("Cannot unregister object from IdentityContext with name: " + name);
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer("unregistering object: " + name);
        }
    }

    @Override
    public Object getObject(String name) throws IdentityException {
        Object o = this.registry.getRegistration(name);
        if (o == null) {
            throw new IdentityException("No such mapping in IdentityContext: " + name);
        }
        return o;
    }

    @Override
    public IdentityConfigurationRegistry getIdentityConfigurationRegistry() {
        return this;
    }

    public IdentityConfiguration configure(IdentityConfigurationMetaData configMD) {
        this.configMD = configMD;
        return this;
    }

    @Override
    public IdentityConfiguration configure(File configFile) throws IdentityConfigurationException {
        IdentityConfigurationMetaData configMD;
        this.configMD = configMD = JAXB2IdentityConfiguration.createConfigurationMetaData(configFile);
        return this;
    }

    @Override
    public IdentityConfiguration configure(String configResource) throws IdentityConfigurationException {
        IdentityConfigurationMetaData configMD;
        this.configMD = configMD = JAXB2IdentityConfiguration.createConfigurationMetaData(configResource);
        return this;
    }

    @Override
    public IdentitySessionFactory buildIdentitySessionFactory() throws IdentityConfigurationException {
        Map<String, IdentitySessionConfigurationContext> realmMap = null;
        if (this.configMD == null) {
            throw new IdentityConfigurationException("Failed to build IdentitySessionFactory. Configuration not initialized");
        }
        try {
            realmMap = this.createRealmMap(this.configMD);
        }
        catch (Exception e) {
            throw new IdentityConfigurationException("Failed to build IdentitySessionFactory", e);
        }
        return new IdentitySessionFactoryImpl(realmMap);
    }

    private Map<String, IdentitySessionConfigurationContext> createRealmMap(IdentityConfigurationMetaData configMD) throws Exception {
        IdentityConfigurationContextImpl configurationContext = new IdentityConfigurationContextImpl(configMD, this);
        HashMap<String, IdentityStore> bootstrappedIdentityStores = new HashMap<String, IdentityStore>();
        HashMap<String, AttributeStore> bootstrappedAttributeStores = new HashMap<String, AttributeStore>();
        for (IdentityStoreConfigurationMetaData metaData : configMD.getIdentityStores()) {
            Class<?> storeClass = null;
            try {
                storeClass = Class.forName(metaData.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Cannot instantiate identity store:" + metaData.getClassName(), e);
            }
            Class[] partypes = new Class[]{String.class};
            Constructor<?> ct = storeClass.getConstructor(partypes);
            Object[] argList = new Object[]{metaData.getId()};
            IdentityStore store = (IdentityStore)ct.newInstance(argList);
            IdentityStoreConfigurationContextImpl storeConfigurationCtx = new IdentityStoreConfigurationContextImpl(configMD, this, metaData);
            store.bootstrap(storeConfigurationCtx);
            bootstrappedIdentityStores.put(store.getId(), store);
            bootstrappedAttributeStores.put(store.getId(), store);
        }
        HashMap<String, IdentityStoreRepository> bootstrappedRepositories = new HashMap<String, IdentityStoreRepository>();
        for (IdentityRepositoryConfigurationMetaData metaData : configMD.getRepositories()) {
            Class<?> repoClass = null;
            try {
                repoClass = Class.forName(metaData.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IdentityException("Cannot instantiate identity store:" + metaData.getClassName(), e);
            }
            Class[] partypes = new Class[]{String.class};
            Constructor<?> ct = repoClass.getConstructor(partypes);
            Object[] argList = new Object[]{metaData.getId()};
            IdentityStoreRepository repo = (IdentityStoreRepository)ct.newInstance(argList);
            IdentityRepositoryConfigurationContextImpl repoConfigurationContext = new IdentityRepositoryConfigurationContextImpl(configMD, this, metaData);
            repo.bootstrap(repoConfigurationContext, bootstrappedIdentityStores, bootstrappedAttributeStores);
            bootstrappedRepositories.put(repo.getId(), repo);
        }
        HashMap<String, IdentitySessionConfigurationContext> sessionCtxMap = new HashMap<String, IdentitySessionConfigurationContext>();
        for (RealmConfigurationMetaData metaData : configMD.getRealms()) {
            String realmName = metaData.getId();
            IdentityStoreRepository repo = (IdentityStoreRepository)bootstrappedRepositories.get(metaData.getIdentityRepositoryIdRef());
            IdentityObjectTypeMapper mapper = null;
            mapper = metaData.getGroupTypeMappings() == null || metaData.getGroupTypeMappings().isEmpty() ? new DirectIdentityObjectTypeMapperImpl(metaData.getIdentityMapping()) : new IdentityObjectTypeMapperImpl(metaData.getGroupTypeMappings(), metaData.getIdentityMapping());
            IdentitySessionConfigurationContext sessionConfigCtx = new IdentitySessionConfigurationContext(realmName, configMD, repo, mapper);
            sessionCtxMap.put(realmName, sessionConfigCtx);
        }
        return sessionCtxMap;
    }
}

