/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.impl.model.hibernate;

import java.util.HashSet;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.Table;
import org.hibernate.annotations.Cascade;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObject;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectAttribute;
import org.jboss.identity.idm.impl.model.hibernate.HibernateIdentityObjectBinaryAttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="jbid_io_attr_bin")
@PrimaryKeyJoinColumn(name="ATTRIBUTE_ID")
public class HibernateIdentityObjectBinaryAttribute
extends HibernateIdentityObjectAttribute {
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private Set<HibernateIdentityObjectBinaryAttributeValue> values = new HashSet<HibernateIdentityObjectBinaryAttributeValue>();

    public HibernateIdentityObjectBinaryAttribute() {
    }

    public HibernateIdentityObjectBinaryAttribute(HibernateIdentityObject identityObject, String name, Set<byte[]> values) {
        super(identityObject, name);
        for (byte[] value : values) {
            this.addValue(value);
        }
    }

    @Override
    public Set<byte[]> getValues() {
        HashSet<byte[]> vals = new HashSet<byte[]>();
        for (HibernateIdentityObjectBinaryAttributeValue value : this.values) {
            vals.add(value.getValue());
        }
        return vals;
    }

    public void setValues(Set<byte[]> values) {
        this.values = new HashSet<HibernateIdentityObjectBinaryAttributeValue>();
        for (byte[] value : values) {
            this.addValue(value);
        }
    }

    public byte[] getValue() {
        if (this.values.size() > 0) {
            return this.values.iterator().next().getValue();
        }
        return null;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public void addValue(Object value) {
        if (value != null && value instanceof byte[]) {
            this.addValue(new HibernateIdentityObjectBinaryAttributeValue((byte[])value));
        }
    }

    public void addValue(HibernateIdentityObjectBinaryAttributeValue value) {
        this.values.add(value);
    }
}

