/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.idm.integration.jboss5;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;
import org.jboss.identity.idm.api.IdentitySessionFactory;
import org.jboss.identity.idm.api.cfg.IdentityConfiguration;
import org.jboss.identity.idm.common.exception.IdentityException;
import org.jboss.identity.idm.common.transaction.TransactionManagerProvider;
import org.jboss.identity.idm.common.transaction.Transactions;
import org.jboss.identity.idm.impl.configuration.IdentityConfigurationImpl;
import org.jboss.identity.idm.impl.configuration.jaxb2.JAXB2IdentityConfiguration;
import org.jboss.identity.idm.integration.jboss5.HibernatePopulator;
import org.jboss.identity.idm.integration.jboss5.SQLPopulator;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityConfigurationMetaData;
import org.jboss.identity.idm.spi.configuration.metadata.IdentityStoreConfigurationMetaData;

public class IDMService {
    public static final String DEFAULT_JNDI = "java:/IdentitySessionFactory";
    private static final String HIBERNATE_CONFIGFILE = "hibernateConfiguration";
    private static Logger logger = Logger.getLogger(IDMService.class.getName());
    private String hibernateConfigLocation;
    private String hibernateSessionFactoryRegistryName;
    private String hibernateSessionFactoryJNDIName;
    private String setupLocation;
    private boolean doChecking;
    private String idmConfigFile;
    private String idmSessionFactoryJNDI;
    private String SQLScript;
    private IdentitySessionFactory identitySessionFactory;
    private SessionFactory hibernateSessionFactory;
    private String exitSQL;
    private String datasource;
    private IdentityConfiguration identityConfiguration;
    private TransactionManager transactionManager;
    protected Configuration config;

    public IDMService(String idmConfigFile) {
        this.idmConfigFile = idmConfigFile;
    }

    public String getIdmConfigFile() {
        return this.idmConfigFile;
    }

    public String getIdmSessionFactoryJNDI() {
        return this.idmSessionFactoryJNDI;
    }

    public String getSQLScript() {
        return this.SQLScript;
    }

    public void setIdmSessionFactoryJNDI(String idmSessionFactoryJNDI) {
        this.idmSessionFactoryJNDI = idmSessionFactoryJNDI;
    }

    public void setSQLScript(String script) {
        this.SQLScript = script;
    }

    public String getHibernateConfigLocation() {
        return this.hibernateConfigLocation;
    }

    public void setHibernateConfigLocation(String hibernateConfigLocation) {
        this.hibernateConfigLocation = hibernateConfigLocation;
    }

    public String getSetupLocation() {
        return this.setupLocation;
    }

    public void setSetupLocation(String setupLocation) {
        this.setupLocation = setupLocation;
    }

    public boolean isDoChecking() {
        return this.doChecking;
    }

    public void setDoChecking(boolean doChecking) {
        this.doChecking = doChecking;
    }

    public String getHibernateSessionFactoryRegistryName() {
        return this.hibernateSessionFactoryRegistryName;
    }

    public void setHibernateSessionFactoryRegistryName(String hibernateSessionFactoryRegistryName) {
        this.hibernateSessionFactoryRegistryName = hibernateSessionFactoryRegistryName;
    }

    public String getHibernateSessionFactoryJNDIName() {
        return this.hibernateSessionFactoryJNDIName;
    }

    public void setHibernateSessionFactoryJNDIName(String hibernateSessionFactoryJNDIName) {
        this.hibernateSessionFactoryJNDIName = hibernateSessionFactoryJNDIName;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public void start() throws Exception {
        logger.info("Starting the JBoss Identity Management Service");
        InitialContext context = new InitialContext();
        IdentityConfigurationMetaData metadata = JAXB2IdentityConfiguration.createConfigurationMetaData(this.idmConfigFile);
        this.identityConfiguration = new IdentityConfigurationImpl().configure(metadata);
        if (this.hibernateConfigLocation != null) {
            this.deployHibernateSessionFactory(context);
        }
        if (this.datasource != null) {
            this.checkTargetDB(this.datasource);
        }
        if (this.needToInitializeDBFromScript()) {
            SQLPopulator sqlPopulator = new SQLPopulator(this.datasource, this.SQLScript, this.exitSQL);
            sqlPopulator.populateSchema();
        }
        if (this.doChecking) {
            if (this.hibernateConfigLocation == null) {
                for (IdentityStoreConfigurationMetaData store : metadata.getIdentityStores()) {
                    this.hibernateConfigLocation = store.getOptionSingleValue(HIBERNATE_CONFIGFILE);
                }
            }
            if (this.hibernateConfigLocation == null) {
                throw new Exception("Couldn't find the hibernate configuration file");
            }
            AnnotationConfiguration configuration = new AnnotationConfiguration().configure(this.hibernateConfigLocation);
            logger.fine("starting to populate the schema from file [" + this.hibernateConfigLocation + "]");
            HibernatePopulator hibernatePopulator = new HibernatePopulator(this.doChecking, this.setupLocation, (Configuration)configuration);
            hibernatePopulator.populateSchema();
        }
        try {
            if (this.transactionManager == null) {
                this.transactionManager = TransactionManagerProvider.JBOSS_PROVIDER.getTransactionManager();
            }
            Transactions.required(this.transactionManager, new Transactions.Runnable(){

                public Object run() throws Exception {
                    IDMService.this.identitySessionFactory = IDMService.this.identityConfiguration.buildIdentitySessionFactory();
                    return null;
                }
            });
        }
        catch (Exception e) {
            throw new Exception("Cannot create IdentitySessionFactory", e);
        }
        context.bind(this.getIdmSessionFactoryJNDI(), (Object)this.identitySessionFactory);
        logger.info("Started the JBoss Identity Management Service");
    }

    private void deployHibernateSessionFactory(InitialContext context) throws NamingException, IdentityException {
        this.hibernateSessionFactory = new AnnotationConfiguration().configure(this.hibernateConfigLocation).buildSessionFactory();
        if (this.hibernateSessionFactoryJNDIName != null) {
            context.bind(this.hibernateSessionFactoryJNDIName, (Object)this.hibernateSessionFactory);
            logger.info("Bind the Hibernate Session Factory in JNDI of " + this.hibernateSessionFactoryJNDIName);
        }
        if (this.hibernateSessionFactoryRegistryName != null) {
            this.identityConfiguration.getIdentityConfigurationRegistry().register(this.hibernateSessionFactory, this.hibernateSessionFactoryRegistryName);
            logger.info("Registered the Hibernate Session Factory in Identity Registration of " + this.hibernateSessionFactoryRegistryName);
        }
    }

    public void destroy() {
        logger.info("Stopping the JBoss Identity Management Service");
        InitialContext context = null;
        try {
            context = new InitialContext();
            if (this.identitySessionFactory != null) {
                this.identitySessionFactory.close();
                if (this.getIdmSessionFactoryJNDI() != null) {
                    context.unbind(this.getIdmSessionFactoryJNDI());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "error in closing identitySessionFactory", e);
        }
        if (this.hibernateSessionFactory != null) {
            try {
                if (this.getHibernateSessionFactoryJNDIName() != null) {
                    context.unbind(this.getHibernateSessionFactoryJNDIName());
                }
                this.hibernateSessionFactory.close();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "error in closing hibernateSessionFactory", e);
            }
        }
        logger.info("Stopped the JBoss Identity Management Service");
    }

    public String getExitSQL() {
        return this.exitSQL;
    }

    public void setExitSQL(String exitSQL) {
        this.exitSQL = exitSQL;
    }

    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    private boolean needToInitializeDBFromScript() {
        return this.getDatasource() != null && this.getSQLScript() != null && this.getExitSQL() != null;
    }

    private int getDatabaseMajorVersion(DatabaseMetaData meta) {
        try {
            Method gdbmvMethod = DatabaseMetaData.class.getMethod("getDatabaseMajorVersion", null);
            return (Integer)gdbmvMethod.invoke((Object)meta, null);
        }
        catch (NoSuchMethodException nsme) {
            return 0;
        }
        catch (Throwable t) {
            logger.info("could not get database version from JDBC metadata");
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTargetDB(String datasource) {
        Connection conn = null;
        Dialect dialectName = null;
        try {
            DataSource ds = (DataSource)new InitialContext().lookup(datasource);
            conn = ds.getConnection();
            DatabaseMetaData meta = conn.getMetaData();
            String databaseName = meta.getDatabaseProductName();
            int databaseMajorVersion = this.getDatabaseMajorVersion(meta);
            dialectName = DialectFactory.determineDialect((String)databaseName, (int)databaseMajorVersion);
            logger.fine("Detected dialect " + dialectName + ", database is (" + databaseName + "," + databaseMajorVersion + ")");
        }
        catch (Exception e) {
            logger.warning(e.getMessage());
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, "error in closing the connection", e);
                }
            }
        }
    }
}

