/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.idp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.valves.ValveBase;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.bindings.tomcat.TomcatRoleGenerator;
import org.jboss.identity.federation.bindings.tomcat.idp.SecurityActions;
import org.jboss.identity.federation.core.config.IDPType;
import org.jboss.identity.federation.core.config.KeyProviderType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.handler.config.Handlers;
import org.jboss.identity.federation.core.impl.DelegatedAttributeManager;
import org.jboss.identity.federation.core.interfaces.AttributeManager;
import org.jboss.identity.federation.core.interfaces.ProtocolContext;
import org.jboss.identity.federation.core.interfaces.RoleGenerator;
import org.jboss.identity.federation.core.interfaces.TrustKeyConfigurationException;
import org.jboss.identity.federation.core.interfaces.TrustKeyManager;
import org.jboss.identity.federation.core.interfaces.TrustKeyProcessingException;
import org.jboss.identity.federation.core.saml.v2.common.SAMLDocumentHolder;
import org.jboss.identity.federation.core.saml.v2.constants.JBossSAMLURIConstants;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssueInstantMissingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.holders.IssuerInfoHolder;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChain;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerRequest;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.util.HandlerUtil;
import org.jboss.identity.federation.core.util.StringUtil;
import org.jboss.identity.federation.saml.v2.SAML2Object;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.StatusResponseType;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.core.IdentityServer;
import org.jboss.identity.federation.web.util.ConfigurationUtil;
import org.jboss.identity.federation.web.util.IDPWebRequestUtil;
import org.jboss.identity.federation.web.util.RedirectBindingSignatureUtil;
import org.jboss.identity.federation.web.util.RedirectBindingUtil;
import org.w3c.dom.Document;

public class IDPWebBrowserSSOValve
extends ValveBase
implements Lifecycle {
    private static Logger log = Logger.getLogger(IDPWebBrowserSSOValve.class);
    private boolean trace = log.isTraceEnabled();
    protected IDPType idpConfiguration = null;
    private RoleGenerator roleGenerator = new TomcatRoleGenerator();
    private long assertionValidity = 5000L;
    private String identityURL = null;
    private TrustKeyManager keyManager;
    private Boolean ignoreIncomingSignatures = true;
    private Boolean signOutgoingMessages = true;
    private transient DelegatedAttributeManager attribManager = new DelegatedAttributeManager();
    private List<String> attributeKeys = new ArrayList<String>();
    private transient SAML2HandlerChain chain = null;
    private Context context = null;
    protected LifecycleSupport lifecycle = new LifecycleSupport((Lifecycle)this);
    private boolean started = false;

    public void setAttributeList(String attribList) {
        if (attribList != null && !"".equals(attribList)) {
            this.attributeKeys.clear();
            StringTokenizer st = new StringTokenizer(attribList, ",");
            while (st != null && st.hasMoreTokens()) {
                this.attributeKeys.add(st.nextToken());
            }
        }
    }

    public Boolean getIgnoreIncomingSignatures() {
        return this.ignoreIncomingSignatures;
    }

    public void setIgnoreIncomingSignatures(Boolean ignoreIncomingSignature) {
        this.ignoreIncomingSignatures = ignoreIncomingSignature;
    }

    public Boolean getSignOutgoingMessages() {
        return this.signOutgoingMessages;
    }

    public void setSignOutgoingMessages(Boolean signOutgoingMessages) {
        this.signOutgoingMessages = signOutgoingMessages;
    }

    public void setRoleGenerator(String rgName) {
        try {
            Class<?> clazz = SecurityActions.getContextClassLoader().loadClass(rgName);
            this.roleGenerator = (RoleGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        block173: {
            Principal userPrincipal;
            String referer = request.getHeader("Referer");
            String relayState = request.getParameter("RelayState");
            if (StringUtil.isNotNull((String)relayState)) {
                relayState = RedirectBindingUtil.urlDecode((String)relayState);
            }
            String samlRequestMessage = request.getParameter("SAMLRequest");
            String samlResponseMessage = request.getParameter("SAMLResponse");
            String signature = request.getParameter("Signature");
            String sigAlg = request.getParameter("SigAlg");
            boolean containsSAMLRequestMessage = StringUtil.isNotNull((String)samlRequestMessage);
            boolean containsSAMLResponseMessage = StringUtil.isNotNull((String)samlResponseMessage);
            Session session = request.getSessionInternal();
            if (containsSAMLRequestMessage || containsSAMLResponseMessage) {
                if (this.trace) {
                    log.trace((Object)"Storing the SAMLRequest/SAMLResponse and RelayState in session");
                }
                if (StringUtil.isNotNull((String)samlRequestMessage)) {
                    session.setNote("SAMLRequest", (Object)samlRequestMessage);
                }
                if (StringUtil.isNotNull((String)samlResponseMessage)) {
                    session.setNote("SAMLResponse", (Object)samlResponseMessage);
                }
                if (StringUtil.isNotNull((String)relayState)) {
                    session.setNote("RelayState", (Object)relayState.trim());
                }
                if (StringUtil.isNotNull((String)signature)) {
                    session.setNote("Signature", (Object)signature.trim());
                }
                if (StringUtil.isNotNull((String)sigAlg)) {
                    session.setNote("sigAlg", (Object)sigAlg.trim());
                }
            }
            if ((userPrincipal = request.getPrincipal()) == null) {
                try {
                    this.getNext().invoke(request, response);
                    Object var14_13 = null;
                }
                catch (Throwable throwable) {
                    Object var14_14 = null;
                    userPrincipal = request.getPrincipal();
                    referer = request.getHeader("Referer");
                    if (this.trace) {
                        log.trace((Object)("Referer in finally block=" + referer + ":user principal=" + userPrincipal));
                    }
                    throw throwable;
                }
                userPrincipal = request.getPrincipal();
                referer = request.getHeader("Referer");
                if (this.trace) {
                    log.trace((Object)("Referer in finally block=" + referer + ":user principal=" + userPrincipal));
                }
            }
            IDPWebRequestUtil webRequestUtil = new IDPWebRequestUtil((HttpServletRequest)request, this.idpConfiguration, this.keyManager);
            webRequestUtil.setAttributeManager((AttributeManager)this.attribManager);
            webRequestUtil.setAttributeKeys(this.attributeKeys);
            Document samlErrorResponse = null;
            if (response.getStatus() == 403) {
                try {
                    samlErrorResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                    if (this.signOutgoingMessages.booleanValue()) {
                        webRequestUtil.send(samlErrorResponse, referer, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), false);
                    } else {
                        webRequestUtil.send(samlErrorResponse, referer, relayState, (HttpServletResponse)response, false, null, false);
                    }
                }
                catch (GeneralSecurityException e) {
                    throw new ServletException((Throwable)e);
                }
                return;
            }
            if (userPrincipal != null) {
                samlRequestMessage = (String)session.getNote("SAMLRequest");
                samlResponseMessage = (String)session.getNote("SAMLResponse");
                relayState = (String)session.getNote("RelayState");
                signature = (String)session.getNote("Signature");
                sigAlg = (String)session.getNote("sigAlg");
                if (this.trace) {
                    StringBuilder builder = new StringBuilder();
                    builder.append("Retrieved saml messages and relay state from session");
                    builder.append("saml Request message=").append(samlRequestMessage);
                    builder.append("::").append("SAMLResponseMessage=");
                    builder.append(samlResponseMessage).append(":").append("relay state=").append(relayState);
                    builder.append("Signature=").append(signature).append("::sigAlg=").append(sigAlg);
                    log.trace((Object)builder.toString());
                }
                if (StringUtil.isNotNull((String)samlRequestMessage)) {
                    session.removeNote("SAMLRequest");
                }
                if (StringUtil.isNotNull((String)samlResponseMessage)) {
                    session.removeNote("SAMLResponse");
                }
                if (StringUtil.isNotNull((String)relayState)) {
                    session.removeNote("RelayState");
                }
                if (StringUtil.isNotNull((String)signature)) {
                    session.removeNote("Signature");
                }
                if (StringUtil.isNotNull((String)sigAlg)) {
                    session.removeNote("sigAlg");
                }
                boolean willSendRequest = false;
                SAMLDocumentHolder samlDocumentHolder = null;
                SAML2Object samlObject = null;
                Document samlResponse = null;
                String destination = null;
                if (samlRequestMessage != null) {
                    block169: {
                        RequestAbstractType requestAbstractType = null;
                        samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlRequestMessage);
                        samlObject = samlDocumentHolder.getSamlObject();
                        boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                        boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlRequestMessage, signature, sigAlg), isPost);
                        if (!isValid) {
                            throw new GeneralSecurityException("Validation check failed");
                        }
                        String issuer = null;
                        IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                        HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
                        DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                        saml2HandlerRequest.setRelayState(relayState);
                        HashMap<String, Object> requestOptions = new HashMap<String, Object>();
                        requestOptions.put("ROLE_GENERATOR", this.roleGenerator);
                        requestOptions.put("ASSERTIONS_VALIDITY", this.assertionValidity);
                        requestOptions.put("CONFIGURATION", this.idpConfiguration);
                        Map attribs = this.attribManager.getAttributes(userPrincipal, this.attributeKeys);
                        requestOptions.put("ATTRIBUTES", attribs);
                        saml2HandlerRequest.setOptions(requestOptions);
                        List roles = this.roleGenerator.generateRoles(userPrincipal);
                        session.getSession().setAttribute("jboss_identity.roles", (Object)roles);
                        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                        Set handlers = this.chain.handlers();
                        if (samlObject instanceof RequestAbstractType) {
                            requestAbstractType = (RequestAbstractType)samlObject;
                            issuer = requestAbstractType.getIssuer().getValue();
                            webRequestUtil.isTrusted(issuer);
                            if (handlers != null) {
                                for (SAML2Handler handler : handlers) {
                                    handler.handleRequestType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                    willSendRequest = saml2HandlerResponse.getSendRequest();
                                }
                            }
                        } else {
                            throw new RuntimeException("Unknown type:" + samlObject.getClass().getName());
                        }
                        samlResponse = saml2HandlerResponse.getResultingDocument();
                        relayState = saml2HandlerResponse.getRelayState();
                        destination = saml2HandlerResponse.getDestination();
                        Object var35_62 = null;
                        try {
                            if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                this.recycle(response);
                            }
                            if (this.signOutgoingMessages.booleanValue()) {
                                webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                break block169;
                            }
                            webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                        }
                        catch (ParsingException e2) {
                            if (this.trace) {
                                log.trace((Object)"Parsing exception:", (Throwable)e2);
                            }
                            break block169;
                        }
                        catch (GeneralSecurityException e3) {
                            if (this.trace) {
                                log.trace((Object)"Security Exception:", (Throwable)e3);
                            }
                            break block169;
                        }
                        {
                            catch (IssuerNotTrustedException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var35_63 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block169;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block169;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block169;
                                }
                            }
                            catch (ParsingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var35_64 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block169;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block169;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block169;
                                }
                            }
                            catch (ConfigurationException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var35_65 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block169;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block169;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block169;
                                }
                            }
                            catch (IssueInstantMissingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var35_66 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block169;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block169;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block169;
                                }
                            }
                            catch (GeneralSecurityException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var35_67 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block169;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block169;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                    break block169;
                                }
                            }
                            catch (Exception e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var35_68 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block169;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                    break block169;
                                }
                                catch (GeneralSecurityException e3) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e3);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block170: {
                                Object var35_69 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                    } else {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                    }
                                }
                                catch (ParsingException e2) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e2);
                                    }
                                }
                                catch (GeneralSecurityException e3) {
                                    if (!this.trace) break block170;
                                    log.trace((Object)"Security Exception:", (Throwable)e3);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return;
                }
                if (StringUtil.isNotNull((String)samlResponseMessage)) {
                    block171: {
                        StatusResponseType statusResponseType = null;
                        samlDocumentHolder = webRequestUtil.getSAMLDocumentHolder(samlResponseMessage);
                        samlObject = samlDocumentHolder.getSamlObject();
                        boolean isPost = webRequestUtil.hasSAMLRequestInPostProfile();
                        boolean isValid = this.validate(request.getRemoteAddr(), request.getQueryString(), new SessionHolder(samlResponseMessage, signature, sigAlg), isPost);
                        if (!isValid) {
                            throw new GeneralSecurityException("Validation check failed");
                        }
                        String issuer = null;
                        IssuerInfoHolder idpIssuer = new IssuerInfoHolder(this.identityURL);
                        HTTPContext protocolContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
                        DefaultSAML2HandlerRequest saml2HandlerRequest = new DefaultSAML2HandlerRequest((ProtocolContext)protocolContext, idpIssuer.getIssuer(), samlDocumentHolder, SAML2Handler.HANDLER_TYPE.IDP);
                        saml2HandlerRequest.setRelayState(relayState);
                        DefaultSAML2HandlerResponse saml2HandlerResponse = new DefaultSAML2HandlerResponse();
                        Set handlers = this.chain.handlers();
                        if (samlObject instanceof StatusResponseType) {
                            statusResponseType = (StatusResponseType)samlObject;
                            issuer = statusResponseType.getIssuer().getValue();
                            webRequestUtil.isTrusted(issuer);
                            if (handlers != null) {
                                for (SAML2Handler handler : handlers) {
                                    handler.reset();
                                    handler.handleStatusResponseType((SAML2HandlerRequest)saml2HandlerRequest, (SAML2HandlerResponse)saml2HandlerResponse);
                                    willSendRequest = saml2HandlerResponse.getSendRequest();
                                }
                            }
                        } else {
                            throw new RuntimeException("Unknown type:" + samlObject.getClass().getName());
                        }
                        samlResponse = saml2HandlerResponse.getResultingDocument();
                        relayState = saml2HandlerResponse.getRelayState();
                        destination = saml2HandlerResponse.getDestination();
                        Object var38_87 = null;
                        try {
                            if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                this.recycle(response);
                            }
                            if (this.signOutgoingMessages.booleanValue()) {
                                webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                break block171;
                            }
                            webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                        }
                        catch (ParsingException e4) {
                            if (this.trace) {
                                log.trace((Object)"Parsing exception:", (Throwable)e4);
                            }
                            break block171;
                        }
                        catch (GeneralSecurityException e5) {
                            if (this.trace) {
                                log.trace((Object)"Security Exception:", (Throwable)e5);
                            }
                            break block171;
                        }
                        {
                            catch (IssuerNotTrustedException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_REQUEST_DENIED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_88 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block171;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block171;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block171;
                                }
                            }
                            catch (ParsingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_89 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block171;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block171;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block171;
                                }
                            }
                            catch (ConfigurationException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_90 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block171;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block171;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block171;
                                }
                            }
                            catch (IssueInstantMissingException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_91 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block171;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block171;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block171;
                                }
                            }
                            catch (GeneralSecurityException e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_92 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block171;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block171;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                    break block171;
                                }
                            }
                            catch (Exception e) {
                                if (this.trace) {
                                    log.trace((Object)"Exception in processing request:", (Throwable)e);
                                }
                                samlResponse = webRequestUtil.getErrorResponse(referer, JBossSAMLURIConstants.STATUS_AUTHNFAILED.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
                                Object var38_93 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                        break block171;
                                    }
                                    webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                    break block171;
                                }
                                catch (GeneralSecurityException e5) {
                                    if (this.trace) {
                                        log.trace((Object)"Security Exception:", (Throwable)e5);
                                    }
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            block172: {
                                Object var38_94 = null;
                                try {
                                    if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                                        this.recycle(response);
                                    }
                                    if (this.signOutgoingMessages.booleanValue()) {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), willSendRequest);
                                    } else {
                                        webRequestUtil.send(samlResponse, destination, relayState, (HttpServletResponse)response, false, null, willSendRequest);
                                    }
                                }
                                catch (ParsingException e4) {
                                    if (this.trace) {
                                        log.trace((Object)"Parsing exception:", (Throwable)e4);
                                    }
                                }
                                catch (GeneralSecurityException e5) {
                                    if (!this.trace) break block172;
                                    log.trace((Object)"Security Exception:", (Throwable)e5);
                                }
                            }
                            throw throwable;
                        }
                    }
                    return;
                }
                log.error((Object)"No SAML Request or Response Message");
                if (this.trace) {
                    log.trace((Object)("Referer=" + referer));
                }
                try {
                    this.sendErrorResponseToSP(referer, response, relayState, webRequestUtil);
                }
                catch (ConfigurationException e) {
                    if (!this.trace) break block173;
                    log.trace((Object)e);
                }
            }
        }
    }

    protected void sendErrorResponseToSP(String referrer, Response response, String relayState, IDPWebRequestUtil webRequestUtil) throws ServletException, IOException, ConfigurationException {
        if (this.trace) {
            log.trace((Object)("About to send error response to SP:" + referrer));
        }
        Document samlResponse = webRequestUtil.getErrorResponse(referrer, JBossSAMLURIConstants.STATUS_RESPONDER.get(), this.identityURL, this.signOutgoingMessages.booleanValue());
        try {
            if (webRequestUtil.hasSAMLRequestInPostProfile()) {
                this.recycle(response);
            }
            if (this.signOutgoingMessages.booleanValue()) {
                webRequestUtil.send(samlResponse, referrer, relayState, (HttpServletResponse)response, true, this.keyManager.getSigningKey(), false);
            } else {
                webRequestUtil.send(samlResponse, referrer, relayState, (HttpServletResponse)response, false, null, false);
            }
        }
        catch (ParsingException e1) {
            throw new ServletException((Throwable)e1);
        }
        catch (GeneralSecurityException e) {
            throw new ServletException((Throwable)e);
        }
    }

    protected boolean validate(String remoteAddress, String queryString, SessionHolder holder, boolean isPost) throws IOException, GeneralSecurityException {
        if (!StringUtil.isNotNull((String)holder.samlRequest)) {
            return false;
        }
        if (!this.ignoreIncomingSignatures.booleanValue() && !isPost) {
            PublicKey validatingKey;
            String sig = holder.signature;
            if (!StringUtil.isNotNull((String)sig)) {
                log.error((Object)("Signature received from SP is null:" + remoteAddress));
                return false;
            }
            byte[] sigValue = RedirectBindingSignatureUtil.getSignatureValueFromSignedURL((String)queryString);
            if (sigValue == null) {
                return false;
            }
            try {
                validatingKey = this.keyManager.getValidatingKey(remoteAddress);
            }
            catch (TrustKeyConfigurationException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            catch (TrustKeyProcessingException e) {
                throw new GeneralSecurityException(e.getCause());
            }
            return RedirectBindingSignatureUtil.validateSignature((String)queryString, (PublicKey)validatingKey, (byte[])sigValue);
        }
        return true;
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this.lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void start() throws LifecycleException {
        ClassLoader tcl;
        Handlers handlers = null;
        if (this.started) {
            throw new LifecycleException("IDPRedirectValve already Started");
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.chain = new DefaultSAML2HandlerChain();
        String configFile = "/WEB-INF/jboss-idfed.xml";
        this.context = (Context)this.getContainer();
        InputStream is = this.context.getServletContext().getResourceAsStream(configFile);
        if (is == null) {
            throw new RuntimeException(configFile + " missing");
        }
        try {
            this.idpConfiguration = ConfigurationUtil.getIDPConfiguration((InputStream)is);
            this.identityURL = this.idpConfiguration.getIdentityURL();
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
            this.assertionValidity = this.idpConfiguration.getAssertionValidity();
            String attributeManager = this.idpConfiguration.getAttributeManager();
            if (attributeManager != null && !"".equals(attributeManager)) {
                tcl = SecurityActions.getContextClassLoader();
                AttributeManager delegate = (AttributeManager)tcl.loadClass(attributeManager).newInstance();
                this.attribManager.setDelegate(delegate);
            }
            String handlerConfigFileName = "/WEB-INF/jbid-handlers.xml";
            handlers = ConfigurationUtil.getHandlers((InputStream)this.context.getServletContext().getResourceAsStream(handlerConfigFileName));
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("ROLE_GENERATOR", this.roleGenerator);
            chainConfigOptions.put("CONFIGURATION", this.idpConfiguration);
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (this.signOutgoingMessages.booleanValue()) {
            KeyProviderType keyProvider = this.idpConfiguration.getKeyProvider();
            if (keyProvider == null) {
                throw new LifecycleException("Key Provider is null for context=" + this.context.getName());
            }
            try {
                tcl = SecurityActions.getContextClassLoader();
                String keyManagerClassName = keyProvider.getClassName();
                if (keyManagerClassName == null) {
                    throw new RuntimeException("KeyManager class name is null");
                }
                Class<?> clazz = tcl.loadClass(keyManagerClassName);
                this.keyManager = (TrustKeyManager)clazz.newInstance();
                this.keyManager.setAuthProperties(keyProvider.getAuth());
                this.keyManager.setValidatingAlias(keyProvider.getValidatingAlias());
            }
            catch (Exception e) {
                log.error((Object)"Exception reading configuration:", (Throwable)e);
                throw new LifecycleException(e.getLocalizedMessage());
            }
            if (this.trace) {
                log.trace((Object)("Key Provider=" + keyProvider.getClassName()));
            }
        }
        String[] ak = new String[]{"mail", "cn", "commonname", "givenname", "surname", "employeeType", "employeeNumber", "facsimileTelephoneNumber"};
        this.attributeKeys.addAll(Arrays.asList(ak));
        IdentityServer identityServer = (IdentityServer)this.context.getServletContext().getAttribute("IDENTITY_SERVER");
        if (identityServer == null) {
            identityServer = new IdentityServer();
            this.context.getServletContext().setAttribute("IDENTITY_SERVER", (Object)identityServer);
        }
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException("IDPRedirectValve NotStarted");
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
    }

    private void recycle(Response response) {
        response.recycle();
    }

    protected static class SessionHolder {
        String samlRequest;
        String signature;
        String sigAlg;

        public SessionHolder(String req, String sig, String alg) {
            this.samlRequest = req;
            this.signature = sig;
            this.sigAlg = alg;
        }
    }
}

