/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.authenticator.FormAuthenticator;
import org.apache.catalina.connector.Request;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.config.SPType;
import org.jboss.identity.federation.core.handler.config.Handlers;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChain;
import org.jboss.identity.federation.core.saml.v2.impl.DefaultSAML2HandlerChainConfig;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2Handler;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerChain;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerChainConfig;
import org.jboss.identity.federation.core.saml.v2.util.HandlerUtil;
import org.jboss.identity.federation.web.util.ConfigurationUtil;

public class BaseFormAuthenticator
extends FormAuthenticator {
    private static Logger log = Logger.getLogger(BaseFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    protected SPType spConfiguration = null;
    protected String serviceURL = null;
    protected String identityURL = null;
    protected String configFile = "/WEB-INF/jboss-idfed.xml";
    protected transient SAML2HandlerChain chain = null;

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    protected boolean validate(Request request) throws IOException, GeneralSecurityException {
        return request.getParameter("SAMLResponse") != null;
    }

    public void start() throws LifecycleException {
        super.start();
        this.processStart();
    }

    public void testStart() throws LifecycleException {
        this.processStart();
    }

    private void processStart() throws LifecycleException {
        Handlers handlers = null;
        ServletContext servletContext = this.context.getServletContext();
        InputStream is = servletContext.getResourceAsStream(this.configFile);
        if (is == null) {
            throw new RuntimeException(this.configFile + " missing");
        }
        this.chain = new DefaultSAML2HandlerChain();
        try {
            this.spConfiguration = ConfigurationUtil.getSPConfiguration((InputStream)is);
            this.identityURL = this.spConfiguration.getIdentityURL();
            this.serviceURL = this.spConfiguration.getServiceURL();
            if (this.trace) {
                log.trace((Object)("Identity Provider URL=" + this.identityURL));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.chain = new DefaultSAML2HandlerChain();
        try {
            String handlerConfigFileName = "/WEB-INF/jbid-handlers.xml";
            handlers = ConfigurationUtil.getHandlers((InputStream)servletContext.getResourceAsStream(handlerConfigFileName));
            this.chain.addAll((Collection)HandlerUtil.getHandlers((Handlers)handlers));
            HashMap<String, Object> chainConfigOptions = new HashMap<String, Object>();
            chainConfigOptions.put("CONFIGURATION", this.spConfiguration);
            chainConfigOptions.put("ROLE_VALIDATOR_IGNORE", "false");
            DefaultSAML2HandlerChainConfig handlerChainConfig = new DefaultSAML2HandlerChainConfig(chainConfigOptions);
            Set samlHandlers = this.chain.handlers();
            for (SAML2Handler handler : samlHandlers) {
                handler.initChainConfig((SAML2HandlerChainConfig)handlerChainConfig);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

