/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.tomcat.sp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Principal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.api.saml.v2.request.SAML2Request;
import org.jboss.identity.federation.bindings.tomcat.sp.BaseFormAuthenticator;
import org.jboss.identity.federation.bindings.tomcat.sp.SPUtil;
import org.jboss.identity.federation.bindings.tomcat.sp.holder.ServiceProviderSAMLContext;
import org.jboss.identity.federation.bindings.util.ValveUtil;
import org.jboss.identity.federation.core.config.TrustType;
import org.jboss.identity.federation.core.exceptions.ConfigurationException;
import org.jboss.identity.federation.core.exceptions.ParsingException;
import org.jboss.identity.federation.core.exceptions.ProcessingException;
import org.jboss.identity.federation.core.saml.v2.exceptions.IssuerNotTrustedException;
import org.jboss.identity.federation.core.saml.v2.interfaces.SAML2HandlerResponse;
import org.jboss.identity.federation.core.saml.v2.util.DocumentUtil;
import org.jboss.identity.federation.core.util.StringUtil;
import org.jboss.identity.federation.saml.v2.protocol.AuthnRequestType;
import org.jboss.identity.federation.saml.v2.protocol.RequestAbstractType;
import org.jboss.identity.federation.saml.v2.protocol.ResponseType;
import org.jboss.identity.federation.web.core.HTTPContext;
import org.jboss.identity.federation.web.process.ServiceProviderBaseProcessor;
import org.jboss.identity.federation.web.process.ServiceProviderSAMLRequestProcessor;
import org.jboss.identity.federation.web.process.ServiceProviderSAMLResponseProcessor;
import org.jboss.identity.federation.web.util.HTTPRedirectUtil;
import org.jboss.identity.federation.web.util.RedirectBindingUtil;
import org.jboss.identity.federation.web.util.ServerDetector;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SPRedirectFormAuthenticator
extends BaseFormAuthenticator {
    private static Logger log = Logger.getLogger(SPRedirectFormAuthenticator.class);
    private boolean trace = log.isTraceEnabled();
    private boolean jbossEnv = false;
    private String logOutPage = "/logout.jsp";

    public SPRedirectFormAuthenticator() {
        ServerDetector detector = new ServerDetector();
        this.jbossEnv = detector.isJboss();
    }

    public boolean authenticate(Request request, Response response, LoginConfig loginConfig) throws IOException {
        String gloStr = request.getParameter("GLO");
        boolean logOutRequest = StringUtil.isNotNull((String)gloStr) && "true".equalsIgnoreCase(gloStr);
        String samlRequest = request.getParameter("SAMLRequest");
        String samlResponse = request.getParameter("SAMLResponse");
        Principal principal = request.getUserPrincipal();
        if (!(principal == null || logOutRequest || StringUtil.isNotNull((String)samlRequest) || StringUtil.isNotNull((String)samlResponse))) {
            return true;
        }
        Session session = request.getSessionInternal(true);
        String relayState = request.getParameter("RelayState");
        HTTPContext httpContext = new HTTPContext((HttpServletRequest)request, (HttpServletResponse)response, this.context.getServletContext());
        Set handlers = this.chain.handlers();
        if (!StringUtil.isNotNull((String)samlRequest) && !StringUtil.isNotNull((String)samlResponse)) {
            SAML2HandlerResponse saml2HandlerResponse = null;
            try {
                ServiceProviderBaseProcessor baseProcessor = new ServiceProviderBaseProcessor(false, this.serviceURL);
                saml2HandlerResponse = baseProcessor.process(httpContext, handlers);
                saml2HandlerResponse.setDestination(this.identityURL);
            }
            catch (ProcessingException pe) {
                log.error((Object)"Processing Exception:", (Throwable)pe);
                throw new RuntimeException(pe);
            }
            catch (ParsingException pe) {
                log.error((Object)"Parsing Exception:", (Throwable)pe);
                throw new RuntimeException(pe);
            }
            catch (ConfigurationException pe) {
                log.error((Object)"Config Exception:", (Throwable)pe);
                throw new RuntimeException(pe);
            }
            Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
            relayState = saml2HandlerResponse.getRelayState();
            String destination = saml2HandlerResponse.getDestination();
            if (destination != null && samlResponseDocument != null) {
                try {
                    String samlMsg = DocumentUtil.getDocumentAsString((Document)samlResponseDocument);
                    String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])samlMsg.getBytes("UTF-8"));
                    String destinationURL = destination + this.getDestination(base64Request, relayState, saml2HandlerResponse.getSendRequest());
                    HTTPRedirectUtil.sendRedirectForRequestor((String)destinationURL, (HttpServletResponse)response);
                    return false;
                }
                catch (Exception e) {
                    if (this.trace) {
                        log.trace((Object)"Exception:", (Throwable)e);
                    }
                    throw new IOException("Server Error");
                }
            }
        }
        if (StringUtil.isNotNull((String)samlResponse)) {
            boolean isValid = false;
            try {
                isValid = this.validate(request);
            }
            catch (Exception e) {
                log.error((Object)"Exception:", (Throwable)e);
                throw new IOException();
            }
            if (!isValid) {
                throw new IOException("Validity check failed");
            }
            try {
                ServiceProviderSAMLResponseProcessor responseProcessor = new ServiceProviderSAMLResponseProcessor(false, this.serviceURL);
                SAML2HandlerResponse saml2HandlerResponse = responseProcessor.process(samlResponse, httpContext, handlers);
                Document samlResponseDocument = saml2HandlerResponse.getResultingDocument();
                relayState = saml2HandlerResponse.getRelayState();
                String destination = saml2HandlerResponse.getDestination();
                if (destination == null || samlResponseDocument == null) {
                    boolean sessionValidity = session.isValid();
                    if (!sessionValidity) {
                        RequestDispatcher dispatch = this.context.getServletContext().getRequestDispatcher(this.logOutPage);
                        if (dispatch == null) {
                            log.error((Object)("Cannot dispatch to the logout page: no request dispatcher:" + this.logOutPage));
                        } else {
                            dispatch.forward((ServletRequest)request, (ServletResponse)response);
                        }
                        return false;
                    }
                    List roles = saml2HandlerResponse.getRoles();
                    if (principal == null) {
                        principal = (Principal)session.getSession().getAttribute("jboss_identity.principal");
                    }
                    String username = principal.getName();
                    String password = "EMPTY_STR";
                    if (new ServerDetector().isJboss() || this.jbossEnv) {
                        GenericPrincipal gp = (GenericPrincipal)principal;
                        ServiceProviderSAMLContext.push(username, Arrays.asList(gp.getRoles()));
                        principal = this.context.getRealm().authenticate(username, password);
                        ServiceProviderSAMLContext.clear();
                    } else {
                        SPUtil spUtil = new SPUtil();
                        principal = spUtil.createGenericPrincipal(request, principal.getName(), roles);
                    }
                    session.setNote("org.apache.catalina.session.USERNAME", (Object)username);
                    session.setNote("org.apache.catalina.session.PASSWORD", (Object)password);
                    request.setUserPrincipal(principal);
                    this.register(request, response, principal, "FORM", username, password);
                    return true;
                }
                String samlMsg = DocumentUtil.getDocumentAsString((Document)samlResponseDocument);
                String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])samlMsg.getBytes("UTF-8"));
                String destinationURL = destination + this.getDestination(base64Request, relayState, saml2HandlerResponse.getSendRequest());
                HTTPRedirectUtil.sendRedirectForRequestor((String)destinationURL, (HttpServletResponse)response);
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)"Server Exception:", (Throwable)e);
                }
                throw new IOException("Server Exception");
            }
        }
        if (StringUtil.isNotNull((String)samlRequest)) {
            try {
                ServiceProviderSAMLRequestProcessor requestProcessor = new ServiceProviderSAMLRequestProcessor(false, this.serviceURL);
                boolean result = requestProcessor.process(samlRequest, httpContext, handlers);
                if (result) {
                    return result;
                }
            }
            catch (Exception e) {
                if (this.trace) {
                    log.trace((Object)"Server Exception:", (Throwable)e);
                }
                throw new IOException("Server Exception");
            }
        }
        return super.authenticate(request, response, loginConfig);
    }

    protected String createSAMLRequestMessage(String relayState, Response response) throws ServletException, ConfigurationException, SAXException, JAXBException, IOException {
        if (this.serviceURL == null) {
            throw new ServletException("serviceURL is not configured");
        }
        SAML2Request saml2Request = new SAML2Request();
        SPUtil spUtil = new SPUtil();
        AuthnRequestType authnRequest = spUtil.createSAMLRequest(this.serviceURL, this.identityURL);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        saml2Request.marshall((RequestAbstractType)authnRequest, (OutputStream)baos);
        String base64Request = RedirectBindingUtil.deflateBase64URLEncode((byte[])baos.toByteArray());
        String destination = authnRequest.getDestination() + this.getDestination(base64Request, relayState, true);
        if (this.trace) {
            log.trace((Object)("Sending to destination=" + destination));
        }
        return destination;
    }

    protected String getDestination(String urlEncodedRequest, String urlEncodedRelayState, boolean sendRequest) {
        StringBuilder sb = new StringBuilder();
        if (sendRequest) {
            sb.append("?SAMLRequest=").append(urlEncodedRequest);
        } else {
            sb.append("?SAMLResponse=").append(urlEncodedRequest);
        }
        if (StringUtil.isNotNull((String)urlEncodedRelayState)) {
            sb.append("&RelayState=").append(urlEncodedRelayState);
        }
        return sb.toString();
    }

    protected void isTrusted(String issuer) throws IssuerNotTrustedException {
        try {
            String issuerDomain = ValveUtil.getDomain(issuer);
            TrustType spTrust = this.spConfiguration.getTrust();
            if (spTrust != null) {
                String domainsTrusted = spTrust.getDomains();
                if (this.trace) {
                    log.trace((Object)("Domains that SP trusts=" + domainsTrusted + " and issuer domain=" + issuerDomain));
                }
                if (domainsTrusted.indexOf(issuerDomain) < 0) {
                    StringTokenizer st = new StringTokenizer(domainsTrusted, ",");
                    while (st != null && st.hasMoreTokens()) {
                        String uriBit = st.nextToken();
                        if (this.trace) {
                            log.trace((Object)("Matching uri bit=" + uriBit));
                        }
                        if (issuerDomain.indexOf(uriBit) <= 0) continue;
                        if (this.trace) {
                            log.trace((Object)("Matched " + uriBit + " trust for " + issuerDomain));
                        }
                        return;
                    }
                    throw new IssuerNotTrustedException(issuer);
                }
            }
        }
        catch (Exception e) {
            throw new IssuerNotTrustedException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    protected ResponseType decryptAssertion(ResponseType responseType) throws IOException, GeneralSecurityException, ConfigurationException, ParsingException {
        throw new RuntimeException("This authenticator does not handle encryption");
    }
}

