/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.bindings.jboss.attribute;

import java.security.Principal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.identity.federation.core.interfaces.AttributeManager;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.identity.Attribute;
import org.jboss.security.mapping.MappingContext;
import org.jboss.security.mapping.MappingManager;
import org.jboss.security.mapping.MappingType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossAppServerAttributeManager
implements AttributeManager {
    private static Logger log = Logger.getLogger(JBossAppServerAttributeManager.class);
    private boolean trace = log.isTraceEnabled();

    public Map<String, Object> getAttributes(Principal userPrincipal, List<String> attributeKeys) {
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        SecurityContext sc = SecurityContextAssociation.getSecurityContext();
        if (sc != null) {
            String mappingType = MappingType.ATTRIBUTE.name();
            MappingManager mm = sc.getMappingManager();
            MappingContext mc = mm.getMappingContext(mappingType);
            if (mc == null) {
                log.error((Object)"Mapping Context returned is null");
                return attributeMap;
            }
            HashMap<String, Principal> contextMap = new HashMap<String, Principal>();
            contextMap.put("Principal", userPrincipal);
            List attList = new ArrayList();
            try {
                mc.performMapping(contextMap, attList);
            }
            catch (Exception e) {
                log.error((Object)"Exception in attribute mapping:", (Throwable)e);
            }
            attList = (List)mc.getMappingResult().getMappedObject();
            if (attList != null) {
                for (Attribute attribute : attList) {
                    attributeMap.put(attribute.getName(), attribute.getValue());
                }
            }
        } else if (this.trace) {
            log.trace((Object)"Could not obtain security context.");
        }
        if (this.trace && attributeMap != null) {
            log.trace((Object)("Final attribute map size:" + attributeMap.size()));
        }
        return attributeMap;
    }
}

