/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.identity.federation.api.openid.provider;

import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.ParameterList;
import org.openid4java.server.InMemoryServerAssociationStore;
import org.openid4java.server.ServerAssociationStore;
import org.openid4java.server.ServerManager;

public class OpenIDProviderManager {
    private ServerManager serverManager = new ServerManager();

    public void initialize() {
        this.serverManager.setSharedAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
        this.serverManager.setPrivateAssociations((ServerAssociationStore)new InMemoryServerAssociationStore());
    }

    public String getEndPoint() {
        return this.serverManager.getOPEndpointUrl();
    }

    public void setEndPoint(String url) {
        this.serverManager.setOPEndpointUrl(url);
    }

    public OpenIDMessage processAuthenticationRequest(ParameterList requestParams, String userSelId, String userSelClaimed, boolean authenticatedAndApproved) {
        Message authMessage = this.serverManager.authResponse(requestParams, userSelId, userSelClaimed, authenticatedAndApproved);
        return new OpenIDMessage(authMessage);
    }

    public OpenIDMessage processAssociationRequest(ParameterList requestParams) {
        return new OpenIDMessage(this.serverManager.associationResponse(requestParams));
    }

    public OpenIDMessage verify(ParameterList requestParams) {
        return new OpenIDMessage(this.serverManager.verify(requestParams));
    }

    public OpenIDMessage getDirectError(String msg) {
        return new OpenIDMessage((Message)DirectError.createDirectError((String)msg));
    }

    public static class OpenIDMessage {
        private Message message;

        OpenIDMessage(Message message) {
            this.message = message;
        }

        public boolean isSuccessful() {
            return this.message instanceof AuthSuccess;
        }

        public String getDestinationURL(boolean httpget) {
            return ((AuthSuccess)this.message).getDestinationUrl(httpget);
        }

        public String getResponseText() {
            return this.message.keyValueFormEncoding();
        }
    }
}

